/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmh.profile;

import java.lang.management.ClassLoadingMXBean;
import java.lang.management.ManagementFactory;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.openjdk.jmh.infra.BenchmarkParams;
import org.openjdk.jmh.infra.IterationParams;
import org.openjdk.jmh.profile.InternalProfiler;
import org.openjdk.jmh.profile.ProfilerResult;
import org.openjdk.jmh.results.AggregationPolicy;
import org.openjdk.jmh.results.Result;

public class ClassloaderProfiler
implements InternalProfiler {
    private long loadedClasses = -1L;
    private long unloadedClasses = -1L;

    @Override
    public String getDescription() {
        return "Classloader profiling via standard MBeans";
    }

    @Override
    public Collection<String> checkSupport() {
        return Collections.emptyList();
    }

    @Override
    public String label() {
        return "cl";
    }

    @Override
    public void beforeIteration(BenchmarkParams benchmarkParams, IterationParams iterationParams) {
        ClassLoadingMXBean cl = ManagementFactory.getClassLoadingMXBean();
        try {
            this.loadedClasses = cl.getLoadedClassCount();
        }
        catch (UnsupportedOperationException e) {
            this.loadedClasses = -1L;
        }
        try {
            this.unloadedClasses = cl.getUnloadedClassCount();
        }
        catch (UnsupportedOperationException e) {
            this.unloadedClasses = -1L;
        }
    }

    @Override
    public Collection<? extends Result> afterIteration(BenchmarkParams benchmarkParams, IterationParams iterationParams) {
        long unloaded;
        long loaded;
        ClassLoadingMXBean cl = ManagementFactory.getClassLoadingMXBean();
        try {
            loaded = (long)cl.getLoadedClassCount() - this.loadedClasses;
        }
        catch (UnsupportedOperationException e) {
            loaded = -1L;
        }
        try {
            unloaded = cl.getUnloadedClassCount() - this.unloadedClasses;
        }
        catch (UnsupportedOperationException e) {
            unloaded = -1L;
        }
        return Arrays.asList(new ProfilerResult("@classload.loaded", loaded, "classes", AggregationPolicy.AVG), new ProfilerResult("@classload.unloaded", unloaded, "classes", AggregationPolicy.AVG));
    }
}

