/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmh.profile;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.infra.BenchmarkParams;
import org.openjdk.jmh.infra.IterationParams;
import org.openjdk.jmh.profile.AbstractHotspotProfiler;
import org.openjdk.jmh.profile.ProfilerResult;
import org.openjdk.jmh.results.AggregationPolicy;
import org.openjdk.jmh.results.Result;
import sun.management.HotspotCompilationMBean;
import sun.management.counter.Counter;

public class HotspotCompilationProfiler
extends AbstractHotspotProfiler {
    public List<Counter> getCounters() {
        return ((HotspotCompilationMBean)AbstractHotspotProfiler.getInstance("HotspotCompilationMBean")).getInternalCompilerCounters();
    }

    @Override
    public String label() {
        return "hs_comp";
    }

    @Override
    public String getDescription() {
        return "HotSpot (tm) JIT compiler profiling via implementation-specific MBeans";
    }

    @Override
    public Collection<? extends Result> afterIteration(BenchmarkParams benchmarkParams, IterationParams iterationParams) {
        Map<String, Long> current = this.counters().getCurrent();
        return Arrays.asList(new ProfilerResult("@compiler.totalTime", TimeUnit.NANOSECONDS.toMillis(current.get("java.ci.totalTime")), "ms", AggregationPolicy.MAX), new ProfilerResult("@compiler.totalCompiles", current.get("sun.ci.totalCompiles").longValue(), "methods", AggregationPolicy.MAX), new ProfilerResult("@compiler.totalBailouts", current.get("sun.ci.totalBailouts").longValue(), "methods", AggregationPolicy.MAX), new ProfilerResult("@compiler.totalInvalidates", current.get("sun.ci.totalInvalidates").longValue(), "methods", AggregationPolicy.MAX), new ProfilerResult("@compiler.nmethodCodeSize", current.get("sun.ci.nmethodCodeSize") / 1024L, "Kb", AggregationPolicy.MAX), new ProfilerResult("@compiler.nmethodSize", current.get("sun.ci.nmethodSize") / 1024L, "Kb", AggregationPolicy.MAX), new ProfilerResult("@compiler.osrCompiles", current.get("sun.ci.osrCompiles").longValue(), "methods", AggregationPolicy.MAX), new ProfilerResult("@compiler.osrBytes", current.get("sun.ci.osrBytes") / 1024L, "Kb", AggregationPolicy.MAX), new ProfilerResult("@compiler.osrTime", TimeUnit.NANOSECONDS.toMillis(current.get("sun.ci.osrTime")), "ms", AggregationPolicy.MAX), new ProfilerResult("@compiler.standardCompiles", current.get("sun.ci.standardCompiles").longValue(), "methods", AggregationPolicy.MAX), new ProfilerResult("@compiler.standardBytes", current.get("sun.ci.standardBytes") / 1024L, "Kb", AggregationPolicy.MAX), new ProfilerResult("@compiler.standardTime", TimeUnit.NANOSECONDS.toMillis(current.get("sun.ci.standardTime")), "ms", AggregationPolicy.MAX));
    }
}

