/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmh.results;

import java.util.Collection;
import org.openjdk.jmh.results.AggregationPolicy;
import org.openjdk.jmh.results.Result;
import org.openjdk.jmh.results.ResultRole;

public final class AggregatorUtils {
    private AggregatorUtils() {
    }

    public static ResultRole aggregateRoles(Collection<? extends Result> results) {
        ResultRole result = null;
        for (Result result2 : results) {
            if (result == null) {
                result = result2.role;
                continue;
            }
            if (result == result2.role) continue;
            throw new IllegalStateException("Combining the results with different roles");
        }
        return result;
    }

    public static String aggregateUnits(Collection<? extends Result> results) {
        String result = null;
        for (Result result2 : results) {
            if (result == null) {
                result = result2.unit;
                continue;
            }
            if (result.equals(result2.unit)) continue;
            throw new IllegalStateException("Combining the results with different units");
        }
        return result;
    }

    public static String aggregateLabels(Collection<? extends Result> results) {
        String result = null;
        for (Result result2 : results) {
            if (result != null) continue;
            result = result2.label;
        }
        return result;
    }

    public static AggregationPolicy aggregatePolicies(Collection<? extends Result> results) {
        AggregationPolicy result = null;
        for (Result result2 : results) {
            if (result == null) {
                result = result2.policy;
                continue;
            }
            if (result.equals((Object)result2.policy)) continue;
            throw new IllegalStateException("Combining the results with different aggregation policies");
        }
        return result;
    }
}

