/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmh.results.format;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import org.openjdk.jmh.infra.BenchmarkParams;
import org.openjdk.jmh.results.BenchmarkResult;
import org.openjdk.jmh.results.IterationResult;
import org.openjdk.jmh.results.Result;
import org.openjdk.jmh.results.RunResult;
import org.openjdk.jmh.results.format.ResultFormat;
import org.openjdk.jmh.util.Statistics;

class JSONResultFormat
implements ResultFormat {
    private final PrintWriter out;

    public JSONResultFormat(PrintWriter out) {
        this.out = out;
    }

    @Override
    public void writeOut(Collection<RunResult> results) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        boolean first = true;
        pw.println("[");
        for (RunResult runResult : results) {
            BenchmarkParams params = runResult.getParams();
            if (first) {
                first = false;
            } else {
                pw.println(",");
            }
            pw.println("{");
            pw.println("\"benchmark\" : \"" + params.getBenchmark() + "\",");
            pw.println("\"mode\" : \"" + params.getMode().shortLabel() + "\",");
            pw.println("\"threads\" : " + params.getThreads() + ",");
            pw.println("\"forks\" : " + params.getForks() + ",");
            pw.println("\"warmupIterations\" : " + params.getWarmup().getCount() + ",");
            pw.println("\"warmupTime\" : \"" + params.getWarmup().getTime() + "\",");
            pw.println("\"measurementIterations\" : " + params.getMeasurement().getCount() + ",");
            pw.println("\"measurementTime\" : \"" + params.getMeasurement().getTime() + "\",");
            if (!params.getParamsKeys().isEmpty()) {
                pw.println("\"params\" : {");
                pw.println(this.emitParams(params));
                pw.println("},");
            }
            Result primaryResult = runResult.getPrimaryResult();
            pw.println("\"primaryMetric\" : {");
            pw.println("\"score\" : " + this.emit(primaryResult.getScore()) + ",");
            pw.println("\"scoreError\" : " + this.emit(primaryResult.getScoreError()) + ",");
            pw.println("\"scoreConfidence\" : " + this.emit(primaryResult.getScoreConfidence()) + ",");
            pw.println(this.emitPercentiles(primaryResult.getStatistics()));
            pw.println("\"scoreUnit\" : \"" + primaryResult.getScoreUnit() + "\",");
            pw.println("\"rawData\" :");
            ArrayList<String> l1 = new ArrayList<String>();
            for (BenchmarkResult benchmarkResult : runResult.getBenchmarkResults()) {
                ArrayList<String> scores = new ArrayList<String>();
                for (IterationResult r : benchmarkResult.getIterationResults()) {
                    scores.add(this.emit(r.getPrimaryResult().getScore()));
                }
                l1.add(this.printMultiple(scores, "[", "]"));
            }
            pw.println(this.printMultiple(l1, "[", "]"));
            pw.println("},");
            ArrayList<String> secondaries = new ArrayList<String>();
            for (String secondaryName : runResult.getSecondaryResults().keySet()) {
                Result result = runResult.getSecondaryResults().get(secondaryName);
                StringBuilder sb = new StringBuilder();
                sb.append("\"").append(secondaryName).append("\" : {");
                sb.append("\"score\" : ").append(this.emit(result.getScore())).append(",");
                sb.append("\"scoreError\" : ").append(this.emit(result.getScoreError())).append(",");
                sb.append("\"scoreConfidence\" : ").append(this.emit(result.getScoreConfidence())).append(",");
                sb.append(this.emitPercentiles(result.getStatistics()));
                sb.append("\"scoreUnit\" : \"").append(result.getScoreUnit()).append("\",");
                sb.append("\"rawData\" :");
                ArrayList<String> l2 = new ArrayList<String>();
                for (BenchmarkResult benchmarkResult : runResult.getBenchmarkResults()) {
                    ArrayList<String> scores = new ArrayList<String>();
                    for (IterationResult r : benchmarkResult.getIterationResults()) {
                        scores.add(this.emit(r.getSecondaryResults().get(secondaryName).getScore()));
                    }
                    l2.add(this.printMultiple(scores, "[", "]"));
                }
                sb.append(this.printMultiple(l2, "[", "]"));
                sb.append("}");
                secondaries.add(sb.toString());
            }
            pw.println("\"secondaryMetrics\" : {");
            pw.println(this.printMultiple(secondaries, "", ""));
            pw.println("}");
            pw.println("}");
        }
        pw.println("]");
        this.out.println(this.tidy(sw.toString()));
    }

    private String emitParams(BenchmarkParams params) {
        StringBuilder sb = new StringBuilder();
        boolean isFirst = true;
        for (String k : params.getParamsKeys()) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append(", ");
            }
            sb.append("\"").append(k).append("\" : ");
            sb.append("\"").append(params.getParam(k)).append("\"");
        }
        return sb.toString();
    }

    private String emitPercentiles(Statistics stats) {
        StringBuilder sb = new StringBuilder();
        sb.append("\"scorePercentiles\" : {");
        boolean firstPercentile = true;
        for (double p : new double[]{0.0, 50.0, 90.0, 95.0, 99.0, 99.9, 99.99, 99.999, 99.9999, 100.0}) {
            if (firstPercentile) {
                firstPercentile = false;
            } else {
                sb.append(",");
            }
            double v = stats.getPercentile(p);
            sb.append("\"").append(this.emit(p)).append("\" : ");
            sb.append(this.emit(v));
        }
        sb.append("},");
        return sb.toString();
    }

    private String emit(double[] ds) {
        StringBuilder sb = new StringBuilder();
        boolean isFirst = true;
        sb.append("[");
        for (double d : ds) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append(",");
            }
            sb.append(this.emit(d));
        }
        sb.append("]");
        return sb.toString();
    }

    private String emit(double d) {
        if (d != d) {
            return "\"NaN\"";
        }
        if (d == Double.NEGATIVE_INFINITY) {
            return "\"-INF\"";
        }
        if (d == Double.POSITIVE_INFINITY) {
            return "\"+INF\"";
        }
        return String.valueOf(d);
    }

    private String tidy(String s) {
        s = s.replaceAll("\n", " ");
        s = s.replaceAll(",", ",\n");
        s = s.replaceAll("\\{", "{\n");
        s = s.replaceAll("\\[", "[\n");
        s = s.replaceAll("\\}", "\n}\n");
        s = s.replaceAll("\\]", "\n]\n");
        s = s.replaceAll("\\]\n,\n", "],\n");
        s = s.replaceAll("\\}\n,\n", "},\n");
        s = s.replaceAll("\n( *)\n", "\n");
        String[] lines = s.split("\n");
        StringBuilder sb = new StringBuilder();
        int ident = 0;
        String prevL = null;
        for (String l : lines) {
            if (prevL != null && (prevL.endsWith("{") || prevL.endsWith("["))) {
                ++ident;
            }
            if (l.endsWith("}") || l.endsWith("]") || l.endsWith("},") || l.endsWith("],")) {
                --ident;
            }
            for (int c = 0; c < ident; ++c) {
                sb.append("    ");
            }
            sb.append(l.trim());
            sb.append("\n");
            prevL = l;
        }
        return sb.toString();
    }

    private String printMultiple(Collection<String> elements, String leftBracket, String rightBracket) {
        StringBuilder sb = new StringBuilder();
        sb.append(leftBracket);
        boolean isFirst = true;
        for (String e : elements) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append(",");
            }
            sb.append(e);
        }
        sb.append(rightBracket);
        return sb.toString();
    }
}

