/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmh.runner;

import java.io.IOException;
import org.openjdk.jmh.infra.BenchmarkParams;
import org.openjdk.jmh.results.BenchmarkResult;
import org.openjdk.jmh.runner.ActionPlan;
import org.openjdk.jmh.runner.BaseRunner;
import org.openjdk.jmh.runner.BenchmarkException;
import org.openjdk.jmh.runner.link.BinaryLinkClient;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.util.Multimap;

class ForkedRunner
extends BaseRunner {
    private final BinaryLinkClient link;

    public ForkedRunner(Options options, BinaryLinkClient link) {
        super(options, link.getOutputFormatHook());
        this.link = link;
    }

    public void run() throws IOException, ClassNotFoundException {
        ActionPlan actionPlan = this.link.requestPlan();
        try {
            Multimap<BenchmarkParams, BenchmarkResult> res = this.runBenchmarks(true, actionPlan);
            this.link.pushResults(res);
        }
        catch (BenchmarkException be) {
            this.link.pushException(be);
        }
        this.out.flush();
        this.out.close();
    }
}

