/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmh.runner;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.infra.BenchmarkParams;
import org.openjdk.jmh.infra.IterationParams;
import org.openjdk.jmh.profile.ExternalProfiler;
import org.openjdk.jmh.profile.Profiler;
import org.openjdk.jmh.profile.ProfilerFactory;
import org.openjdk.jmh.results.BenchmarkResult;
import org.openjdk.jmh.results.Result;
import org.openjdk.jmh.results.RunResult;
import org.openjdk.jmh.results.format.ResultFormat;
import org.openjdk.jmh.results.format.ResultFormatFactory;
import org.openjdk.jmh.results.format.ResultFormatType;
import org.openjdk.jmh.runner.Action;
import org.openjdk.jmh.runner.ActionMode;
import org.openjdk.jmh.runner.ActionPlan;
import org.openjdk.jmh.runner.ActionType;
import org.openjdk.jmh.runner.BaseRunner;
import org.openjdk.jmh.runner.BenchmarkException;
import org.openjdk.jmh.runner.BenchmarkList;
import org.openjdk.jmh.runner.BenchmarkListEntry;
import org.openjdk.jmh.runner.CompilerHints;
import org.openjdk.jmh.runner.Defaults;
import org.openjdk.jmh.runner.ForkedMain;
import org.openjdk.jmh.runner.IterationType;
import org.openjdk.jmh.runner.NoBenchmarksException;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.WorkloadParams;
import org.openjdk.jmh.runner.format.OutputFormat;
import org.openjdk.jmh.runner.format.OutputFormatFactory;
import org.openjdk.jmh.runner.link.BinaryLinkServer;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.TimeValue;
import org.openjdk.jmh.util.FileUtils;
import org.openjdk.jmh.util.HashMultimap;
import org.openjdk.jmh.util.InputStreamDrainer;
import org.openjdk.jmh.util.Multimap;
import org.openjdk.jmh.util.TreeMultimap;
import org.openjdk.jmh.util.Utils;

public class Runner
extends BaseRunner {
    private final BenchmarkList list = BenchmarkList.defaultList();
    private int cpuCount;

    public Runner(Options options, OutputFormat format) {
        super(options, format);
    }

    public Runner(Options options) {
        this(options, Runner.createOutputFormat(options));
    }

    private static OutputFormat createOutputFormat(Options options) {
        PrintStream out;
        if (options == null) {
            throw new IllegalArgumentException("Options not allowed to be null.");
        }
        if (options.getOutput().hasValue()) {
            try {
                out = new PrintStream(new BufferedOutputStream(new FileOutputStream(new File(options.getOutput().get()))));
                System.setOut(out);
            }
            catch (FileNotFoundException ex) {
                throw new IllegalStateException(ex);
            }
        } else {
            out = System.out;
        }
        return OutputFormatFactory.createFormatInstance(out, options.verbosity().orElse(Defaults.VERBOSITY));
    }

    public void list() {
        SortedSet<BenchmarkListEntry> benchmarks = this.list.find(this.out, this.options.getIncludes(), this.options.getExcludes());
        this.out.println("Benchmarks: ");
        for (BenchmarkListEntry benchmark : benchmarks) {
            this.out.println(benchmark.getUsername());
        }
    }

    public RunResult runSingle() throws RunnerException {
        SortedSet<BenchmarkListEntry> benchmarks = this.list.find(this.out, this.options.getIncludes(), this.options.getExcludes());
        if (benchmarks.size() == 1) {
            Collection<RunResult> values = this.run();
            if (values.size() == 1) {
                return values.iterator().next();
            }
            throw new RunnerException("No results returned");
        }
        throw new RunnerException("More than single benchmark is matching the options");
    }

    public Collection<RunResult> run() throws RunnerException {
        ArrayList<BenchmarkListEntry> newBenchmarks;
        for (Class<? extends Profiler> p : this.options.getProfilers()) {
            Collection<String> initMessages = ProfilerFactory.checkSupport(p);
            if (initMessages.isEmpty()) continue;
            StringBuilder sb = new StringBuilder();
            for (String im : initMessages) {
                sb.append(String.format("%5s %s\n", "", im));
            }
            throw new RunnerException("The requested profiler (" + p.getName() + ") is not supported: \n" + sb.toString());
        }
        SortedSet<BenchmarkListEntry> benchmarks = this.list.find(this.out, this.options.getIncludes(), this.options.getExcludes());
        if (benchmarks.isEmpty()) {
            this.out.flush();
            this.out.close();
            throw new NoBenchmarksException();
        }
        if (!this.options.getBenchModes().isEmpty()) {
            newBenchmarks = new ArrayList<BenchmarkListEntry>();
            for (BenchmarkListEntry br : benchmarks) {
                for (Mode m : this.options.getBenchModes()) {
                    newBenchmarks.add(br.cloneWith(m));
                }
            }
            benchmarks.clear();
            benchmarks.addAll(newBenchmarks);
        }
        newBenchmarks = new ArrayList();
        for (BenchmarkListEntry br : benchmarks) {
            if (br.getMode() == Mode.All) {
                for (Mode mode : Mode.values()) {
                    if (mode == Mode.All) continue;
                    newBenchmarks.add(br.cloneWith(mode));
                }
                continue;
            }
            newBenchmarks.add(br);
        }
        benchmarks.clear();
        benchmarks.addAll(newBenchmarks);
        newBenchmarks = new ArrayList();
        for (BenchmarkListEntry br : benchmarks) {
            if (br.getParams().hasValue()) {
                for (WorkloadParams p : this.explodeAllParams(br)) {
                    newBenchmarks.add(br.cloneWith(p));
                }
                continue;
            }
            newBenchmarks.add(br);
        }
        benchmarks.clear();
        benchmarks.addAll(newBenchmarks);
        Collection<RunResult> results = this.runBenchmarks(benchmarks);
        this.out.flush();
        this.out.close();
        ResultFormatType resultFormatType = this.options.getResultFormat().orElse(Defaults.RESULT_FORMAT);
        String resultFormatFile = this.options.getResult().orElse("jmh.out");
        ResultFormat resultFormat = ResultFormatFactory.getInstance(resultFormatType, resultFormatFile);
        resultFormat.writeOut(results);
        return results;
    }

    private List<ActionPlan> getActionPlans(Set<BenchmarkListEntry> benchmarks) {
        ActionPlan base = new ActionPlan(ActionType.FORKED);
        LinkedHashSet<BenchmarkListEntry> warmupBenches = new LinkedHashSet<BenchmarkListEntry>();
        List<String> warmupMicrosRegexp = this.options.getWarmupIncludes();
        if (warmupMicrosRegexp != null && !warmupMicrosRegexp.isEmpty()) {
            warmupBenches.addAll(this.list.find(this.out, warmupMicrosRegexp, Collections.<String>emptyList()));
        }
        if (this.options.getWarmupMode().orElse(Defaults.WARMUP_MODE).isBulk()) {
            warmupBenches.addAll(benchmarks);
        }
        for (BenchmarkListEntry wr : warmupBenches) {
            base.add(this.newAction(wr, ActionMode.WARMUP));
        }
        ActionPlan embeddedPlan = new ActionPlan(ActionType.EMBEDDED);
        embeddedPlan.mixIn(base);
        boolean addEmbedded = false;
        ArrayList<ActionPlan> result = new ArrayList<ActionPlan>();
        for (BenchmarkListEntry br : benchmarks) {
            BenchmarkParams params = this.newBenchmarkParams(br, ActionMode.UNDEF);
            if (params.getForks() <= 0) {
                if (this.options.getWarmupMode().orElse(Defaults.WARMUP_MODE).isIndi()) {
                    embeddedPlan.add(this.newAction(br, ActionMode.WARMUP_MEASUREMENT));
                } else {
                    embeddedPlan.add(this.newAction(br, ActionMode.MEASUREMENT));
                }
                addEmbedded = true;
            }
            if (params.getForks() <= 0) continue;
            ActionPlan r = new ActionPlan(ActionType.FORKED);
            r.mixIn(base);
            if (this.options.getWarmupMode().orElse(Defaults.WARMUP_MODE).isIndi()) {
                r.add(this.newAction(br, ActionMode.WARMUP_MEASUREMENT));
            } else {
                r.add(this.newAction(br, ActionMode.MEASUREMENT));
            }
            result.add(r);
        }
        if (addEmbedded) {
            result.add(embeddedPlan);
        }
        return result;
    }

    private Action newAction(BenchmarkListEntry br, ActionMode mode) {
        return new Action(this.newBenchmarkParams(br, mode), mode);
    }

    private BenchmarkParams newBenchmarkParams(BenchmarkListEntry benchmark, ActionMode mode) {
        IterationParams measurement;
        boolean synchIterations;
        int[] threadGroups = this.options.getThreadGroups().orElse(benchmark.getThreadGroups());
        int threads = this.options.getThreads().orElse(benchmark.getThreads().orElse(1));
        if (threads == -1) {
            if (this.cpuCount == 0) {
                this.out.print("# Detecting actual CPU count: ");
                this.cpuCount = Utils.figureOutHotCPUs();
                this.out.println(this.cpuCount + " detected");
            }
            threads = this.cpuCount;
        }
        threads = Utils.roundUp(threads, Utils.sum(threadGroups));
        boolean bl = synchIterations = benchmark.getMode() != Mode.SingleShotTime && this.options.shouldSyncIterations().orElse(true) != false;
        IterationParams iterationParams = mode.doMeasurement() ? new IterationParams(IterationType.MEASUREMENT, this.options.getMeasurementIterations().orElse(benchmark.getMeasurementIterations().orElse(benchmark.getMode() == Mode.SingleShotTime ? 1 : 20)), this.options.getMeasurementTime().orElse(benchmark.getMeasurementTime().orElse(benchmark.getMode() == Mode.SingleShotTime ? TimeValue.NONE : Defaults.MEASUREMENT_TIME)), benchmark.getMode() != Mode.SingleShotTime ? 1 : this.options.getMeasurementBatchSize().orElse(benchmark.getMeasurementBatchSize().orElse(1))) : (measurement = new IterationParams(IterationType.MEASUREMENT, 0, TimeValue.NONE, 1));
        IterationParams warmup = mode.doWarmup() ? new IterationParams(IterationType.WARMUP, this.options.getWarmupIterations().orElse(benchmark.getWarmupIterations().orElse(benchmark.getMode() == Mode.SingleShotTime ? 0 : 20)), this.options.getWarmupTime().orElse(benchmark.getWarmupTime().orElse(benchmark.getMode() == Mode.SingleShotTime ? TimeValue.NONE : Defaults.WARMUP_TIME)), benchmark.getMode() != Mode.SingleShotTime ? 1 : this.options.getWarmupBatchSize().orElse(benchmark.getWarmupBatchSize().orElse(1))) : new IterationParams(IterationType.WARMUP, 0, TimeValue.NONE, 1);
        int forks = this.options.getForkCount().orElse(benchmark.getForks().orElse(10));
        int warmupForks = this.options.getWarmupForkCount().orElse(benchmark.getWarmupForks().orElse(0));
        TimeUnit timeUnit = this.options.getTimeUnit().orElse(benchmark.getTimeUnit().orElse(Defaults.OUTPUT_TIMEUNIT));
        int opsPerInvocation = this.options.getOperationsPerInvocation().orElse(benchmark.getOperationsPerInvocation().orElse(Defaults.OPS_PER_INVOCATION));
        Collection jvmArgsPrepend = this.options.getJvmArgsPrepend().orElse(benchmark.getJvmArgsPrepend().orElse(Collections.emptyList()));
        Collection jvmArgs = this.options.getJvmArgs().orElse(benchmark.getJvmArgs().orElse(ManagementFactory.getRuntimeMXBean().getInputArguments()));
        Collection jvmArgsAppend = this.options.getJvmArgsAppend().orElse(benchmark.getJvmArgsAppend().orElse(Collections.emptyList()));
        return new BenchmarkParams(benchmark.getUsername(), benchmark.generatedTarget(), synchIterations, threads, threadGroups, forks, warmupForks, warmup, measurement, benchmark.getMode(), benchmark.getWorkloadParams(), timeUnit, opsPerInvocation, jvmArgsPrepend, jvmArgs, jvmArgsAppend);
    }

    private List<WorkloadParams> explodeAllParams(BenchmarkListEntry br) throws RunnerException {
        Map benchParams = br.getParams().orElse(Collections.emptyMap());
        ArrayList<WorkloadParams> ps = new ArrayList<WorkloadParams>();
        for (String k : benchParams.keySet()) {
            Collection values = this.options.getParameter(k).orElse(Arrays.asList((Object[])benchParams.get(k)));
            if (values.isEmpty()) {
                throw new RunnerException("Benchmark \"" + br.getUsername() + "\" defines the parameter \"" + k + "\", but no default values.\n" + "Define the default values within the annotation, or provide the parameter values at runtime.");
            }
            if (ps.isEmpty()) {
                int idx = 0;
                for (String v : values) {
                    WorkloadParams al = new WorkloadParams();
                    al.put(k, v, idx);
                    ps.add(al);
                    ++idx;
                }
                continue;
            }
            ArrayList<WorkloadParams> newPs = new ArrayList<WorkloadParams>();
            for (WorkloadParams p : ps) {
                int idx = 0;
                for (String v : values) {
                    WorkloadParams al = p.copy();
                    al.put(k, v, idx);
                    newPs.add(al);
                    ++idx;
                }
            }
            ps = newPs;
        }
        return ps;
    }

    private Collection<RunResult> runBenchmarks(SortedSet<BenchmarkListEntry> benchmarks) throws RunnerException {
        this.out.startRun();
        TreeMultimap<BenchmarkParams, BenchmarkResult> results = new TreeMultimap<BenchmarkParams, BenchmarkResult>();
        List<ActionPlan> plan = this.getActionPlans(benchmarks);
        this.beforeBenchmarks(plan);
        try {
            for (ActionPlan r : plan) {
                Multimap<BenchmarkParams, BenchmarkResult> res;
                switch (r.getType()) {
                    case EMBEDDED: {
                        res = this.runBenchmarks(false, r);
                        break;
                    }
                    case FORKED: {
                        res = this.runSeparate(r);
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unknown action plan type: " + (Object)((Object)r.getType()));
                    }
                }
                for (BenchmarkParams br : res.keys()) {
                    results.putAll(br, res.get(br));
                }
            }
            this.afterBenchmarks();
            SortedSet<RunResult> runResults = this.mergeRunResults(results);
            this.out.endRun(runResults);
            return runResults;
        }
        catch (BenchmarkException be) {
            throw new RunnerException("Benchmark caught the exception", be.getCause());
        }
    }

    private SortedSet<RunResult> mergeRunResults(Multimap<BenchmarkParams, BenchmarkResult> results) {
        TreeSet<RunResult> result = new TreeSet<RunResult>(RunResult.DEFAULT_SORT_COMPARATOR);
        for (BenchmarkParams key : results.keys()) {
            result.add(new RunResult(results.get(key)));
        }
        return result;
    }

    private Multimap<BenchmarkParams, BenchmarkResult> runSeparate(ActionPlan actionPlan) {
        HashMultimap<BenchmarkParams, BenchmarkResult> results = new HashMultimap<BenchmarkParams, BenchmarkResult>();
        if (actionPlan.getMeasurementActions().size() != 1) {
            throw new IllegalStateException("Expect only single benchmark in the action plan, but was " + actionPlan.getMeasurementActions().size());
        }
        BinaryLinkServer server = null;
        try {
            File stdOut;
            File stdErr;
            int i;
            server = new BinaryLinkServer(this.options, this.out);
            server.setPlan(actionPlan);
            BenchmarkParams params = actionPlan.getMeasurementActions().get(0).getParams();
            ArrayList<ExternalProfiler> profilers = new ArrayList<ExternalProfiler>();
            ArrayList<String> javaInvokeOptions = new ArrayList<String>();
            ArrayList<String> javaOptions = new ArrayList<String>();
            for (Class<? extends Profiler> p : this.options.getProfilers()) {
                if (!ProfilerFactory.isExternal(p)) continue;
                ExternalProfiler prof = (ExternalProfiler)ProfilerFactory.prepareProfiler(p, null);
                profilers.add(prof);
                javaInvokeOptions.addAll(prof.addJVMInvokeOptions(params));
                javaOptions.addAll(prof.addJVMOptions(params));
            }
            Object[] commandString = this.getSeparateExecutionCommand(params, server.getHost(), server.getPort(), javaInvokeOptions, javaOptions);
            String opts = Utils.join(this.getJvmArgs(params), " ");
            if (opts.trim().isEmpty()) {
                opts = "<none>";
            }
            String jvm = this.options.getJvm().orElse(this.getDefaultJvm());
            int forkCount = params.getForks();
            int warmupForkCount = params.getWarmupForks();
            if (warmupForkCount > 0) {
                this.out.verbosePrintln("Warmup forking " + warmupForkCount + " times using command: " + Arrays.toString(commandString));
                for (i = 0; i < warmupForkCount; ++i) {
                    this.beforeBenchmark();
                    this.out.startBenchmark(params);
                    this.out.println("# VM invoker: " + jvm);
                    this.out.println("# VM options: " + opts);
                    this.out.println("# Warmup Fork: " + (i + 1) + " of " + warmupForkCount);
                    stdErr = FileUtils.tempFile("stderr");
                    stdOut = FileUtils.tempFile("stdout");
                    this.doFork(server, (String[])commandString, stdOut, stdErr);
                    this.out.endBenchmark(null);
                    this.afterBenchmark(params);
                }
            }
            this.out.verbosePrintln("Forking " + forkCount + " times using command: " + Arrays.toString(commandString));
            for (i = 0; i < forkCount; ++i) {
                this.beforeBenchmark();
                this.out.startBenchmark(params);
                this.out.println("# VM invoker: " + jvm);
                this.out.println("# VM options: " + opts);
                this.out.println("# Fork: " + (i + 1) + " of " + forkCount);
                stdErr = FileUtils.tempFile("stderr");
                stdOut = FileUtils.tempFile("stdout");
                for (ExternalProfiler profiler : profilers) {
                    profiler.beforeTrial(params);
                }
                Multimap<BenchmarkParams, BenchmarkResult> result = this.doFork(server, (String[])commandString, stdOut, stdErr);
                for (ExternalProfiler profiler : profilers) {
                    for (Result result2 : profiler.afterTrial(params, stdOut, stdErr)) {
                        for (BenchmarkResult r : result.values()) {
                            r.addBenchmarkResult(result2);
                        }
                    }
                }
                results.merge(result);
                this.afterBenchmark(params);
                BenchmarkResult r = null;
                if (result.values().size() == 1) {
                    r = result.values().iterator().next();
                }
                this.out.endBenchmark(r);
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        finally {
            if (server != null) {
                server.terminate();
            }
        }
        return results;
    }

    private Multimap<BenchmarkParams, BenchmarkResult> doFork(BinaryLinkServer reader, String[] commandString, File stdOut, File stdErr) {
        try {
            Process p = Runtime.getRuntime().exec(commandString);
            InputStreamDrainer errDrainer = new InputStreamDrainer(p.getErrorStream(), new FileOutputStream(stdErr));
            InputStreamDrainer outDrainer = new InputStreamDrainer(p.getInputStream(), new FileOutputStream(stdOut));
            errDrainer.start();
            outDrainer.start();
            int ecode = p.waitFor();
            errDrainer.join();
            outDrainer.join();
            reader.waitFinish();
            if (ecode != 0) {
                this.out.println("<forked VM failed with exit code " + ecode + ">");
                this.out.println("<stdout last='10 lines'>");
                for (String l : FileUtils.tail(stdOut, 10)) {
                    this.out.println(l);
                }
                this.out.println("</stdout>");
                this.out.println("<stderr last='10 lines'>");
                for (String l : FileUtils.tail(stdErr, 10)) {
                    this.out.println(l);
                }
                this.out.println("</stderr>");
                this.out.println("");
                if (this.options.shouldFailOnError().orElse(false).booleanValue()) {
                    throw new BenchmarkException(new IllegalStateException("Forked VM failed with exit code " + ecode));
                }
            }
        }
        catch (IOException ex) {
            throw new BenchmarkException(ex);
        }
        catch (InterruptedException ex) {
            throw new BenchmarkException(ex);
        }
        BenchmarkException exception = reader.getException();
        if (exception == null) {
            return reader.getResults();
        }
        throw exception;
    }

    String[] getSeparateExecutionCommand(BenchmarkParams benchmark, String host, int port, List<String> javaInvokeOptions, List<String> javaOptions) {
        ArrayList<String> command = new ArrayList<String>();
        command.addAll(javaInvokeOptions);
        command.add(this.options.getJvm().orElse(this.getDefaultJvm()));
        command.addAll(this.getJvmArgs(benchmark));
        command.addAll(javaOptions);
        CompilerHints.addCompilerHints(command);
        command.add("-cp");
        if (this.isWindows()) {
            command.add('\"' + System.getProperty("java.class.path") + '\"');
        } else {
            command.add(System.getProperty("java.class.path"));
        }
        command.add(ForkedMain.class.getName());
        command.add(host);
        command.add(String.valueOf(port));
        return command.toArray(new String[command.size()]);
    }

    private boolean isWindows() {
        return System.getProperty("os.name").contains("indows");
    }

    private String getDefaultJvm() {
        return System.getProperty("java.home") + File.separator + "bin" + File.separator + "java" + (this.isWindows() ? ".exe" : "");
    }

    private Collection<String> getJvmArgs(BenchmarkParams benchmark) {
        ArrayList<String> res = new ArrayList<String>();
        res.addAll(benchmark.getJvmArgsPrepend());
        res.addAll(benchmark.getJvmArgs());
        res.addAll(benchmark.getJvmArgsAppend());
        return res;
    }
}

