/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmh.runner.link;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.openjdk.jmh.infra.BenchmarkParams;
import org.openjdk.jmh.results.BenchmarkResult;
import org.openjdk.jmh.runner.ActionPlan;
import org.openjdk.jmh.runner.BenchmarkException;
import org.openjdk.jmh.runner.format.OutputFormat;
import org.openjdk.jmh.runner.link.ActionPlanFrame;
import org.openjdk.jmh.runner.link.ClassConventions;
import org.openjdk.jmh.runner.link.ExceptionFrame;
import org.openjdk.jmh.runner.link.FinishingFrame;
import org.openjdk.jmh.runner.link.InfraFrame;
import org.openjdk.jmh.runner.link.OptionsFrame;
import org.openjdk.jmh.runner.link.OutputFormatFrame;
import org.openjdk.jmh.runner.link.OutputFrame;
import org.openjdk.jmh.runner.link.ResultsFrame;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.util.HashMultimap;
import org.openjdk.jmh.util.Multimap;

public final class BinaryLinkServer {
    private final Options opts;
    private final OutputFormat out;
    private final Map<String, Method> methods;
    private final Set<String> forbidden;
    private final Acceptor acceptor;
    private final AtomicReference<Handler> handler;
    private final AtomicReference<Multimap<BenchmarkParams, BenchmarkResult>> results;
    private final AtomicReference<BenchmarkException> exception;
    private final AtomicReference<ActionPlan> plan;

    public BinaryLinkServer(Options opts, OutputFormat out) throws IOException {
        this.opts = opts;
        this.out = out;
        this.methods = new HashMap<String, Method>();
        this.forbidden = new HashSet<String>();
        for (Method m : OutputFormat.class.getMethods()) {
            Method prev;
            if (m.getName().equals("startRun")) {
                this.forbidden.add(ClassConventions.getMethodName(m));
            }
            if (m.getName().equals("endRun")) {
                this.forbidden.add(ClassConventions.getMethodName(m));
            }
            if ((prev = this.methods.put(ClassConventions.getMethodName(m), m)) == null) continue;
            out.println("WARNING: Duplicate methods: " + m + " vs. " + prev);
            throw new IllegalStateException("WARNING: Duplicate methods: " + m + " vs. " + prev);
        }
        this.acceptor = new Acceptor();
        this.acceptor.start();
        this.handler = new AtomicReference();
        this.results = new AtomicReference(new HashMultimap());
        this.exception = new AtomicReference();
        this.plan = new AtomicReference();
    }

    public void terminate() {
        this.acceptor.close();
        Handler h = this.handler.getAndSet(null);
        if (h != null) {
            h.close();
        }
        try {
            this.acceptor.join();
            if (h != null) {
                h.join();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void waitFinish() {
        Handler h = this.handler.getAndSet(null);
        if (h != null) {
            try {
                h.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public BenchmarkException getException() {
        return this.exception.getAndSet(null);
    }

    public Multimap<BenchmarkParams, BenchmarkResult> getResults() {
        Multimap res = this.results.getAndSet(new HashMultimap());
        if (res != null) {
            return res;
        }
        throw new IllegalStateException("Acquiring the null result");
    }

    public void setPlan(ActionPlan actionPlan) {
        this.plan.set(actionPlan);
    }

    private InetAddress getLoopback() {
        try {
            Method m = InetAddress.class.getMethod("getLoopbackAddress", new Class[0]);
            return (InetAddress)m.invoke(null, new Object[0]);
        }
        catch (InvocationTargetException e) {
        }
        catch (NoSuchMethodException e) {
        }
        catch (IllegalAccessException e) {
            // empty catch block
        }
        try {
            return InetAddress.getByAddress(new byte[]{127, 0, 0, 1});
        }
        catch (UnknownHostException e) {
            try {
                return InetAddress.getLocalHost();
            }
            catch (UnknownHostException e2) {
                throw new IllegalStateException("Can not find the address to bind to.", e2);
            }
        }
    }

    public String getHost() {
        return this.acceptor.getHost();
    }

    public int getPort() {
        return this.acceptor.getPort();
    }

    private final class Handler
    extends Thread {
        private final InputStream is;
        private final Socket socket;
        private ObjectInputStream ois;
        private final OutputStream os;
        private ObjectOutputStream oos;

        public Handler(Socket socket) throws IOException {
            this.socket = socket;
            this.is = socket.getInputStream();
            this.os = socket.getOutputStream();
        }

        @Override
        public void run() {
            try {
                Object obj;
                this.ois = new ObjectInputStream(this.is);
                this.oos = new ObjectOutputStream(this.os);
                while ((obj = this.ois.readObject()) != null) {
                    if (obj instanceof OutputFormatFrame) {
                        this.handleOutputFormat((OutputFormatFrame)obj);
                    }
                    if (obj instanceof InfraFrame) {
                        this.handleInfra((InfraFrame)obj);
                    }
                    if (obj instanceof ResultsFrame) {
                        this.handleResults((ResultsFrame)obj);
                    }
                    if (obj instanceof ExceptionFrame) {
                        this.handleException((ExceptionFrame)obj);
                    }
                    if (obj instanceof OutputFrame) {
                        this.handleOutput((OutputFrame)obj);
                    }
                    if (!(obj instanceof FinishingFrame)) continue;
                    break;
                }
            }
            catch (ObjectStreamException e) {
                throw new IllegalStateException(e);
            }
            catch (InterruptedIOException e) {
                throw new IllegalStateException(e);
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException(e);
            }
            catch (InvocationTargetException e) {
                throw new IllegalStateException(e);
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException(e);
            }
            finally {
                this.close();
            }
        }

        private void handleOutput(OutputFrame obj) {
            try {
                switch (obj.getType()) {
                    case OUT: {
                        System.out.write(obj.getData());
                        break;
                    }
                    case ERR: {
                        System.err.write(obj.getData());
                    }
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        private void handleException(ExceptionFrame obj) {
            BinaryLinkServer.this.exception.set(obj.getError());
        }

        private void handleResults(ResultsFrame obj) {
            ((Multimap)BinaryLinkServer.this.results.get()).merge(obj.getRes());
        }

        private void handleInfra(InfraFrame req) throws IOException {
            switch (req.getType()) {
                case OPTIONS_REQUEST: {
                    this.oos.writeObject(new OptionsFrame(BinaryLinkServer.this.opts));
                    this.oos.flush();
                    break;
                }
                case ACTION_PLAN_REQUEST: {
                    this.oos.writeObject(new ActionPlanFrame((ActionPlan)BinaryLinkServer.this.plan.get()));
                    this.oos.flush();
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown infrastructure request: " + req);
                }
            }
        }

        private boolean handleOutputFormat(OutputFormatFrame frame) throws IllegalAccessException, InvocationTargetException {
            Method m = (Method)BinaryLinkServer.this.methods.get(frame.method);
            if (m == null) {
                BinaryLinkServer.this.out.println("WARNING: Unknown method to forward: " + frame.method);
                return true;
            }
            if (BinaryLinkServer.this.forbidden.contains(frame.method)) {
                return true;
            }
            m.invoke((Object)BinaryLinkServer.this.out, frame.args);
            return false;
        }

        public void close() {
            try {
                this.socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private final class Acceptor
    extends Thread {
        private final ServerSocket server;

        public Acceptor() throws IOException {
            this.server = new ServerSocket(0, 50, BinaryLinkServer.this.getLoopback());
        }

        @Override
        public void run() {
            try {
                while (!Thread.interrupted()) {
                    Socket clientSocket = this.server.accept();
                    Handler r = new Handler(clientSocket);
                    if (!BinaryLinkServer.this.handler.compareAndSet(null, r)) {
                        throw new IllegalStateException("The handler is already registered");
                    }
                    r.start();
                }
            }
            catch (SocketException e) {
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
            finally {
                this.close();
            }
        }

        public String getHost() {
            return BinaryLinkServer.this.getLoopback().getHostAddress();
        }

        public int getPort() {
            return this.server.getLocalPort();
        }

        public void close() {
            try {
                this.server.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

