/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmh.runner.options;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.NonOptionArgumentSpec;
import joptsimple.OptionException;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.profile.Profiler;
import org.openjdk.jmh.profile.ProfilerFactory;
import org.openjdk.jmh.results.format.ResultFormatType;
import org.openjdk.jmh.runner.options.CommandLineOptionException;
import org.openjdk.jmh.runner.options.OptionFormatter;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.TimeValue;
import org.openjdk.jmh.runner.options.VerboseMode;
import org.openjdk.jmh.runner.options.WarmupMode;
import org.openjdk.jmh.util.HashMultimap;
import org.openjdk.jmh.util.Multimap;
import org.openjdk.jmh.util.Optional;

public class CommandLineOptions
implements Options {
    private final Optional<Integer> iterations;
    private final Optional<TimeValue> runTime;
    private final Optional<Integer> batchSize;
    private final Optional<Integer> warmupIterations;
    private final Optional<TimeValue> warmupTime;
    private final Optional<Integer> warmupBatchSize;
    private final List<Mode> benchMode = new ArrayList<Mode>();
    private final Optional<Integer> threads;
    private final List<Integer> threadGroups = new ArrayList<Integer>();
    private final Optional<Boolean> synchIterations;
    private final Optional<Boolean> gcEachIteration;
    private final Optional<VerboseMode> verbose;
    private final Optional<Boolean> failOnError;
    private final Set<Class<? extends Profiler>> profilers = new HashSet<Class<? extends Profiler>>();
    private final Optional<TimeUnit> timeUnit;
    private final Optional<Integer> opsPerInvocation;
    private final List<String> regexps = new ArrayList<String>();
    private final Optional<Integer> fork;
    private final Optional<Integer> warmupFork;
    private final Optional<String> output;
    private final Optional<String> result;
    private final Optional<ResultFormatType> resultFormat;
    private final Optional<String> jvm;
    private final Optional<Collection<String>> jvmArgs;
    private final Optional<Collection<String>> jvmArgsAppend;
    private final Optional<Collection<String>> jvmArgsPrepend;
    private final List<String> excludes = new ArrayList<String>();
    private final Optional<WarmupMode> warmupMode;
    private final List<String> warmupMicros = new ArrayList<String>();
    private final Multimap<String, String> params = new HashMultimap<String, String>();
    private final boolean list;
    private final boolean listResultFormats;
    private final boolean help;
    private final boolean listProfilers;
    private final transient OptionParser parser = new OptionParser();

    public CommandLineOptions(String ... argv) throws CommandLineOptionException {
        this.parser.formatHelpWith(new OptionFormatter());
        ArgumentAcceptingOptionSpec<Integer> optMeasureCount = this.parser.accepts("i", "Number of measurement iterations to do.").withRequiredArg().ofType(Integer.class).describedAs("int");
        ArgumentAcceptingOptionSpec<Integer> optMeasureBatchSize = this.parser.accepts("bs", "Batch size: number of benchmark method calls per operation. (some benchmark modes can ignore this setting)").withRequiredArg().ofType(Integer.class).describedAs("int");
        ArgumentAcceptingOptionSpec<String> optMeasureTime = this.parser.accepts("r", "Time to spend at each measurement iteration.").withRequiredArg().ofType(String.class).describedAs("time");
        ArgumentAcceptingOptionSpec<Integer> optWarmupCount = this.parser.accepts("wi", "Number of warmup iterations to do.").withRequiredArg().ofType(Integer.class).describedAs("int");
        ArgumentAcceptingOptionSpec<Integer> optWarmupBatchSize = this.parser.accepts("wbs", "Warmup batch size: number of benchmark method calls per operation. (some benchmark modes can ignore this setting)").withRequiredArg().ofType(Integer.class).describedAs("int");
        ArgumentAcceptingOptionSpec<String> optWarmupTime = this.parser.accepts("w", "Time to spend at each warmup iteration.").withRequiredArg().ofType(String.class).describedAs("time");
        ArgumentAcceptingOptionSpec<String> optThreads = this.parser.accepts("t", "Number of worker threads to run with.").withRequiredArg().ofType(String.class).describedAs("int");
        ArgumentAcceptingOptionSpec<String> optBenchmarkMode = this.parser.accepts("bm", "Benchmark mode. Available modes are: " + Mode.getKnown()).withRequiredArg().ofType(String.class).withValuesSeparatedBy(',').describedAs("mode");
        ArgumentAcceptingOptionSpec<Boolean> optSyncIters = this.parser.accepts("si", "Synchronize iterations?").withOptionalArg().ofType(Boolean.class).describedAs("bool");
        ArgumentAcceptingOptionSpec<Boolean> optGC = this.parser.accepts("gc", "Should JMH force GC between iterations?").withOptionalArg().ofType(Boolean.class).describedAs("bool");
        ArgumentAcceptingOptionSpec<Boolean> optFOE = this.parser.accepts("foe", "Should JMH fail immediately if any benchmark had experienced the unrecoverable error?").withOptionalArg().ofType(Boolean.class).describedAs("bool");
        ArgumentAcceptingOptionSpec<String> optVerboseMode = this.parser.accepts("v", "Verbosity mode. Available modes are: " + Arrays.toString((Object[])VerboseMode.values())).withRequiredArg().ofType(String.class).describedAs("mode");
        NonOptionArgumentSpec<String> optArgs = this.parser.nonOptions("Benchmarks to run (regexp+).").describedAs("regexp+");
        ArgumentAcceptingOptionSpec<Integer> optForks = this.parser.accepts("f", "How many times to forks a single benchmark. Use 0 to disable forking altogether (WARNING: disabling forking may have detrimental impact on benchmark and infrastructure reliability, you might want to use different warmup mode instead).").withOptionalArg().ofType(Integer.class).describedAs("int");
        ArgumentAcceptingOptionSpec<Integer> optWarmupForks = this.parser.accepts("wf", "How many warmup forks to make for a single benchmark. 0 to disable warmup forks.").withRequiredArg().ofType(Integer.class).describedAs("int");
        ArgumentAcceptingOptionSpec<String> optOutput = this.parser.accepts("o", "Redirect human-readable output to file.").withRequiredArg().ofType(String.class).describedAs("filename");
        ArgumentAcceptingOptionSpec<String> optOutputResults = this.parser.accepts("rff", "Write results to given file.").withRequiredArg().ofType(String.class).describedAs("filename");
        ArgumentAcceptingOptionSpec<String> optProfilers = this.parser.accepts("prof", "Use profilers to collect additional data. See the list of available profilers first.").withRequiredArg().withValuesSeparatedBy(',').ofType(String.class).describedAs("profiler+");
        ArgumentAcceptingOptionSpec<Integer> optThreadGroups = this.parser.accepts("tg", "Override thread group distribution for asymmetric benchmarks.").withRequiredArg().withValuesSeparatedBy(',').ofType(Integer.class).describedAs("int+");
        ArgumentAcceptingOptionSpec<String> optJvm = this.parser.accepts("jvm", "Custom JVM to use when forking.").withRequiredArg().ofType(String.class).describedAs("string");
        ArgumentAcceptingOptionSpec<String> optJvmArgs = this.parser.accepts("jvmArgs", "Custom JVM args to use when forking.").withRequiredArg().ofType(String.class).describedAs("string");
        ArgumentAcceptingOptionSpec<String> optJvmArgsAppend = this.parser.accepts("jvmArgsAppend", "Custom JVM args to use when forking (append these)").withRequiredArg().ofType(String.class).describedAs("string");
        ArgumentAcceptingOptionSpec<String> optJvmArgsPrepend = this.parser.accepts("jvmArgsPrepend", "Custom JVM args to use when forking (prepend these)").withRequiredArg().ofType(String.class).describedAs("string");
        ArgumentAcceptingOptionSpec<String> optTU = this.parser.accepts("tu", "Output time unit. Available time units are: [m, s, ms, us, ns].").withRequiredArg().ofType(String.class).describedAs("TU");
        ArgumentAcceptingOptionSpec<Integer> optOPI = this.parser.accepts("opi", "Operations per invocation.").withRequiredArg().ofType(Integer.class).describedAs("int");
        ArgumentAcceptingOptionSpec<String> optResultFormat = this.parser.accepts("rf", "Result format type. See the list of available result formats first.").withRequiredArg().ofType(String.class).describedAs("type");
        ArgumentAcceptingOptionSpec<String> optWarmupMode = this.parser.accepts("wm", "Warmup mode for warming up selected benchmarks. Warmup modes are: " + Arrays.toString((Object[])WarmupMode.values()) + ".").withRequiredArg().ofType(String.class).describedAs("mode");
        ArgumentAcceptingOptionSpec<String> optExcludes = this.parser.accepts("e", "Benchmarks to exclude from the run.").withRequiredArg().withValuesSeparatedBy(',').ofType(String.class).describedAs("regexp+");
        ArgumentAcceptingOptionSpec<String> optParams = this.parser.accepts("p", "Benchmark parameters. This option is expected to be used once per parameter. Parameter name and parameter values should be separated with equals sign. Parameter values should be separated with commas.").withRequiredArg().ofType(String.class).describedAs("param={v,}*");
        ArgumentAcceptingOptionSpec<String> optWarmupBenchmarks = this.parser.accepts("wmb", "Warmup benchmarks to include in the run in addition to already selected. JMH will not measure these benchmarks, but only use them for the warmup.").withRequiredArg().withValuesSeparatedBy(',').ofType(String.class).describedAs("regexp+");
        this.parser.accepts("l", "List matching benchmarks and exit.");
        this.parser.accepts("lrf", "List result formats.");
        this.parser.accepts("lprof", "List profilers.");
        this.parser.accepts("h", "Display help.");
        try {
            String value;
            OptionSet set = this.parser.parse(argv);
            if (set.has(optExcludes)) {
                this.excludes.addAll(optExcludes.values(set));
            }
            if (set.has(optWarmupBenchmarks)) {
                this.warmupMicros.addAll(optWarmupBenchmarks.values(set));
            }
            if (set.has(optTU)) {
                TimeUnit tu;
                String va = (String)optTU.value(set);
                if (va.equalsIgnoreCase("ns")) {
                    tu = TimeUnit.NANOSECONDS;
                } else if (va.equalsIgnoreCase("us")) {
                    tu = TimeUnit.MICROSECONDS;
                } else if (va.equalsIgnoreCase("ms")) {
                    tu = TimeUnit.MILLISECONDS;
                } else if (va.equalsIgnoreCase("s")) {
                    tu = TimeUnit.SECONDS;
                } else if (va.equalsIgnoreCase("m")) {
                    tu = TimeUnit.MINUTES;
                } else if (va.equalsIgnoreCase("h")) {
                    tu = TimeUnit.HOURS;
                } else {
                    throw new CommandLineOptionException("Unknown time unit: " + va);
                }
                this.timeUnit = Optional.of(tu);
            } else {
                this.timeUnit = Optional.none();
            }
            this.opsPerInvocation = Optional.eitherOf(optOPI.value(set));
            if (set.has(optWarmupMode)) {
                try {
                    this.warmupMode = Optional.of(WarmupMode.valueOf((String)optWarmupMode.value(set)));
                }
                catch (IllegalArgumentException iae) {
                    throw new CommandLineOptionException(iae.getMessage(), iae);
                }
            } else {
                this.warmupMode = Optional.none();
            }
            if (set.has(optResultFormat)) {
                try {
                    this.resultFormat = Optional.of(ResultFormatType.valueOf(((String)optResultFormat.value(set)).toUpperCase()));
                }
                catch (IllegalArgumentException iae) {
                    throw new CommandLineOptionException(iae.getMessage(), iae);
                }
            } else {
                this.resultFormat = Optional.none();
            }
            this.help = set.has("h");
            this.list = set.has("l");
            this.listResultFormats = set.has("lrf");
            this.listProfilers = set.has("lprof");
            this.iterations = Optional.eitherOf(optMeasureCount.value(set));
            this.batchSize = Optional.eitherOf(optMeasureBatchSize.value(set));
            if (set.has(optMeasureTime)) {
                value = (String)optMeasureTime.value(set);
                try {
                    this.runTime = Optional.of(TimeValue.fromString(value));
                }
                catch (IllegalArgumentException iae) {
                    throw new CommandLineOptionException(iae.getMessage(), iae);
                }
            } else {
                this.runTime = Optional.none();
            }
            this.warmupIterations = Optional.eitherOf(optWarmupCount.value(set));
            this.warmupBatchSize = Optional.eitherOf(optWarmupBatchSize.value(set));
            if (set.has(optWarmupTime)) {
                value = (String)optWarmupTime.value(set);
                try {
                    this.warmupTime = Optional.of(TimeValue.fromString(value));
                }
                catch (IllegalArgumentException iae) {
                    throw new CommandLineOptionException(iae.getMessage(), iae);
                }
            } else {
                this.warmupTime = Optional.none();
            }
            if (set.has(optThreads)) {
                String v = (String)optThreads.value(set);
                if (v.equalsIgnoreCase("max")) {
                    this.threads = Optional.of(-1);
                } else {
                    try {
                        this.threads = Optional.of(Integer.valueOf(v));
                    }
                    catch (IllegalArgumentException iae) {
                        throw new CommandLineOptionException(iae.getMessage(), iae);
                    }
                }
            } else {
                this.threads = Optional.none();
            }
            if (set.has(optBenchmarkMode)) {
                try {
                    ArrayList<Mode> modes = new ArrayList<Mode>();
                    for (String m : optBenchmarkMode.values(set)) {
                        modes.add(Mode.deepValueOf(m));
                    }
                    this.benchMode.addAll(modes);
                }
                catch (IllegalArgumentException iae) {
                    throw new CommandLineOptionException(iae.getMessage(), iae);
                }
            }
            this.synchIterations = set.has(optSyncIters) ? (set.hasArgument(optSyncIters) ? Optional.of(optSyncIters.value(set)) : Optional.of(true)) : Optional.none();
            this.gcEachIteration = set.has(optGC) ? (set.hasArgument(optGC) ? Optional.of(optGC.value(set)) : Optional.of(true)) : Optional.none();
            this.failOnError = set.has(optFOE) ? (set.hasArgument(optFOE) ? Optional.of(optFOE.value(set)) : Optional.of(true)) : Optional.none();
            if (set.has(optVerboseMode)) {
                try {
                    if (set.hasArgument(optVerboseMode)) {
                        this.verbose = Optional.of(VerboseMode.valueOf(set.valueOf(optVerboseMode).toUpperCase()));
                    }
                    this.verbose = Optional.of(VerboseMode.EXTRA);
                }
                catch (IllegalArgumentException iae) {
                    throw new CommandLineOptionException(iae.getMessage(), iae);
                }
            } else {
                this.verbose = Optional.none();
            }
            this.regexps.addAll(set.valuesOf(optArgs));
            this.fork = set.has(optForks) ? (set.hasArgument(optForks) ? Optional.of(optForks.value(set)) : Optional.of(1)) : Optional.none();
            this.warmupFork = Optional.eitherOf(optWarmupForks.value(set));
            this.output = Optional.eitherOf(optOutput.value(set));
            this.result = Optional.eitherOf(optOutputResults.value(set));
            if (set.has(optProfilers)) {
                try {
                    for (String m : optProfilers.values(set)) {
                        Class<? extends Profiler> pClass = ProfilerFactory.getProfilerByName(m);
                        if (pClass == null) {
                            throw new CommandLineOptionException("Unable to find profiler: " + m);
                        }
                        this.profilers.add(pClass);
                    }
                }
                catch (IllegalArgumentException iae) {
                    throw new CommandLineOptionException(iae.getMessage(), iae);
                }
            }
            if (set.has(optThreadGroups)) {
                this.threadGroups.addAll(set.valuesOf(optThreadGroups));
            }
            this.jvm = Optional.eitherOf(optJvm.value(set));
            this.jvmArgs = set.hasArgument(optJvmArgs) ? Optional.of(Arrays.asList(((String)optJvmArgs.value(set)).trim().split("[ ]+"))) : Optional.none();
            this.jvmArgsAppend = set.hasArgument(optJvmArgsAppend) ? Optional.of(Arrays.asList(((String)optJvmArgsAppend.value(set)).trim().split("[ ]+"))) : Optional.none();
            this.jvmArgsPrepend = set.hasArgument(optJvmArgsPrepend) ? Optional.of(Arrays.asList(((String)optJvmArgsPrepend.value(set)).trim().split("[ ]+"))) : Optional.none();
            if (set.hasArgument(optParams)) {
                for (String p : optParams.values(set)) {
                    String[] keys = p.split("=");
                    if (keys.length != 2) {
                        throw new CommandLineOptionException("Unable to parse parameter string \"" + p + "\"");
                    }
                    this.params.putAll(keys[0], Arrays.asList(keys[1].split(",")));
                }
            }
        }
        catch (OptionException e) {
            throw new CommandLineOptionException(e.getMessage(), e);
        }
    }

    public void showHelp() throws IOException {
        this.parser.printHelpOn(System.err);
    }

    public void listProfilers() {
        StringBuilder supported = new StringBuilder();
        StringBuilder unsupported = new StringBuilder();
        for (Class<? extends Profiler> s : ProfilerFactory.getAvailableProfilers()) {
            Collection<String> initMessages = ProfilerFactory.checkSupport(s);
            if (initMessages.isEmpty()) {
                supported.append(String.format("%20s: %s\n", ProfilerFactory.getLabel(s), ProfilerFactory.getDescription(s)));
                continue;
            }
            unsupported.append(String.format("%20s: %s\n", ProfilerFactory.getLabel(s), ProfilerFactory.getDescription(s)));
            for (String im : initMessages) {
                unsupported.append(String.format("%20s  %s\n", "", im));
            }
            unsupported.append("\n");
        }
        if (!supported.toString().isEmpty()) {
            System.out.println("Supported profilers:\n" + supported.toString());
        }
        if (!unsupported.toString().isEmpty()) {
            System.out.println("Unsupported profilers:\n" + unsupported.toString());
        }
    }

    public void listResultFormats() {
        StringBuilder sb = new StringBuilder();
        for (ResultFormatType f : ResultFormatType.values()) {
            sb.append(f.toString().toLowerCase());
            sb.append(", ");
        }
        sb.setLength(sb.length() - 2);
        System.out.println("Available formats: " + sb.toString());
    }

    public boolean shouldList() {
        return this.list;
    }

    public boolean shouldListResultFormats() {
        return this.listResultFormats;
    }

    public boolean shouldHelp() {
        return this.help;
    }

    public boolean shouldListProfilers() {
        return this.listProfilers;
    }

    @Override
    public Optional<WarmupMode> getWarmupMode() {
        return this.warmupMode;
    }

    @Override
    public List<String> getIncludes() {
        return this.regexps;
    }

    @Override
    public List<String> getExcludes() {
        return this.excludes;
    }

    @Override
    public List<String> getWarmupIncludes() {
        return this.warmupMicros;
    }

    @Override
    public Optional<String> getJvm() {
        return this.jvm;
    }

    @Override
    public Optional<Collection<String>> getJvmArgs() {
        return this.jvmArgs;
    }

    @Override
    public Optional<Collection<String>> getJvmArgsAppend() {
        return this.jvmArgsAppend;
    }

    @Override
    public Optional<Collection<String>> getJvmArgsPrepend() {
        return this.jvmArgsPrepend;
    }

    @Override
    public Optional<Collection<String>> getParameter(String name) {
        Collection<String> list = this.params.get(name);
        if (list == null || list.isEmpty()) {
            return Optional.none();
        }
        return Optional.of(list);
    }

    @Override
    public Optional<Integer> getForkCount() {
        return this.fork;
    }

    @Override
    public Optional<Integer> getWarmupForkCount() {
        return this.warmupFork;
    }

    @Override
    public Optional<String> getOutput() {
        return this.output;
    }

    @Override
    public Optional<ResultFormatType> getResultFormat() {
        return this.resultFormat;
    }

    @Override
    public Optional<String> getResult() {
        return this.result;
    }

    @Override
    public Optional<Integer> getMeasurementIterations() {
        return this.iterations;
    }

    @Override
    public Optional<Integer> getMeasurementBatchSize() {
        return this.batchSize;
    }

    @Override
    public Optional<TimeValue> getMeasurementTime() {
        return this.runTime;
    }

    @Override
    public Optional<TimeValue> getWarmupTime() {
        return this.warmupTime;
    }

    @Override
    public Optional<Integer> getWarmupIterations() {
        return this.warmupIterations;
    }

    @Override
    public Optional<Integer> getWarmupBatchSize() {
        return this.warmupBatchSize;
    }

    @Override
    public Optional<Integer> getThreads() {
        return this.threads;
    }

    @Override
    public Optional<int[]> getThreadGroups() {
        if (this.threadGroups.isEmpty()) {
            return Optional.none();
        }
        int[] r = new int[this.threadGroups.size()];
        for (int c = 0; c < r.length; ++c) {
            r[c] = this.threadGroups.get(c);
        }
        return Optional.of(r);
    }

    @Override
    public Optional<Boolean> shouldDoGC() {
        return this.gcEachIteration;
    }

    @Override
    public Optional<Boolean> shouldSyncIterations() {
        return this.synchIterations;
    }

    @Override
    public Optional<VerboseMode> verbosity() {
        return this.verbose;
    }

    @Override
    public Optional<TimeUnit> getTimeUnit() {
        return this.timeUnit;
    }

    @Override
    public Optional<Integer> getOperationsPerInvocation() {
        return this.opsPerInvocation;
    }

    @Override
    public Optional<Boolean> shouldFailOnError() {
        return this.failOnError;
    }

    public Set<Class<? extends Profiler>> getProfilers() {
        return this.profilers;
    }

    @Override
    public Collection<Mode> getBenchModes() {
        return new HashSet<Mode>(this.benchMode);
    }
}

