/*
 * Decompiled with CFR 0.152.
 */
package rx.internal.operators;

import rx.Notification;
import rx.Observable;
import rx.Subscriber;
import rx.plugins.RxJavaPlugins;

public final class OperatorMaterialize<T>
implements Observable.Operator<Notification<T>, T> {
    public static <T> OperatorMaterialize<T> instance() {
        return Holder.INSTANCE;
    }

    private OperatorMaterialize() {
    }

    @Override
    public Subscriber<? super T> call(final Subscriber<? super Notification<T>> child) {
        return new Subscriber<T>(child){

            @Override
            public void onCompleted() {
                child.onNext(Notification.createOnCompleted());
                child.onCompleted();
            }

            @Override
            public void onError(Throwable e) {
                RxJavaPlugins.getInstance().getErrorHandler().handleError(e);
                child.onNext(Notification.createOnError(e));
                child.onCompleted();
            }

            @Override
            public void onNext(T t) {
                child.onNext(Notification.createOnNext(t));
            }
        };
    }

    private static final class Holder {
        static final OperatorMaterialize<Object> INSTANCE = new OperatorMaterialize();

        private Holder() {
        }
    }
}

