/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmh.profile;

import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.infra.BenchmarkParams;
import org.openjdk.jmh.infra.IterationParams;
import org.openjdk.jmh.profile.InternalProfiler;
import org.openjdk.jmh.profile.ProfilerResult;
import org.openjdk.jmh.results.AggregationPolicy;
import org.openjdk.jmh.results.Result;

public class GCProfiler
implements InternalProfiler {
    private long startGCCount;
    private long startGCTime;
    private long startTime;

    @Override
    public String getDescription() {
        return "GC profiling via standard MBeans";
    }

    @Override
    public Collection<String> checkSupport() {
        return Collections.emptyList();
    }

    @Override
    public String label() {
        return "gc";
    }

    @Override
    public void beforeIteration(BenchmarkParams benchmarkParams, IterationParams iterationParams) {
        this.startTime = System.nanoTime();
        long gcTime = 0L;
        long gcCount = 0L;
        for (GarbageCollectorMXBean bean : ManagementFactory.getGarbageCollectorMXBeans()) {
            gcCount += bean.getCollectionCount();
            gcTime += bean.getCollectionTime();
        }
        this.startGCCount = gcCount;
        this.startGCTime = gcTime;
    }

    @Override
    public Collection<? extends Result> afterIteration(BenchmarkParams benchmarkParams, IterationParams iterationParams) {
        long endTime = System.nanoTime();
        long gcTime = -this.startGCTime;
        long gcCount = -this.startGCCount;
        for (GarbageCollectorMXBean bean : ManagementFactory.getGarbageCollectorMXBeans()) {
            gcCount += bean.getCollectionCount();
            gcTime += bean.getCollectionTime();
        }
        return Arrays.asList(new ProfilerResult("@gc.count", gcCount, "counts", AggregationPolicy.AVG), new ProfilerResult("@gc.time", 100.0 * (double)gcTime / (double)TimeUnit.NANOSECONDS.toMillis(endTime - this.startTime), "%", AggregationPolicy.AVG));
    }
}

