/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmh.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;

public class FileUtils {
    private FileUtils() {
    }

    public static File tempFile(String suffix) throws IOException {
        File file = File.createTempFile("jmh", suffix);
        file.deleteOnExit();
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File extractFromResource(String name) throws IOException {
        InputStream fis = null;
        OutputStream fos = null;
        BufferedInputStream bis = null;
        BufferedOutputStream bos = null;
        try {
            fis = FileUtils.class.getResourceAsStream(name);
            bis = new BufferedInputStream(fis);
            File temp = FileUtils.tempFile("extracted");
            fos = new FileOutputStream(temp);
            bos = new BufferedOutputStream(fos);
            byte[] b = new byte[1024];
            int available = bis.available();
            while (available > 0) {
                int length = Math.min(b.length, available);
                int read = bis.read(b, 0, length);
                bos.write(b, 0, read);
                available = bis.available();
            }
            File file = temp;
            return file;
        }
        finally {
            if (bos != null) {
                try {
                    bos.flush();
                }
                catch (IOException e) {}
                try {
                    bos.close();
                }
                catch (IOException e) {}
            }
            if (bis != null) {
                try {
                    bis.close();
                }
                catch (IOException e) {}
            }
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {}
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {}
            }
        }
    }

    public static String createTempFileWithLines(String prefix, String suffix, Iterable<String> lines) throws IOException {
        File file = FileUtils.tempFile(suffix);
        PrintWriter pw = new PrintWriter(file);
        for (String l : lines) {
            pw.println(l);
        }
        pw.close();
        return file.getAbsolutePath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection<String> tail(File file, int num) throws IOException {
        FileInputStream fis = null;
        try {
            String line;
            fis = new FileInputStream(file);
            BufferedReader reader = new BufferedReader(new InputStreamReader(fis));
            LinkedList<String> lines = new LinkedList<String>();
            while ((line = reader.readLine()) != null) {
                lines.add(line);
                if (lines.size() <= num) continue;
                lines.remove(0);
            }
            LinkedList<String> linkedList = lines;
            return linkedList;
        }
        finally {
            if (fis != null) {
                fis.close();
            }
        }
    }

    public static Collection<File> getClasses(File root) {
        ArrayList<File> result = new ArrayList<File>();
        ArrayList<File> newDirs = new ArrayList<File>();
        newDirs.add(root);
        while (!newDirs.isEmpty()) {
            ArrayList<File> add = new ArrayList<File>();
            for (File dir : newDirs) {
                File[] files = dir.listFiles();
                if (files == null) continue;
                for (File f : files) {
                    if (f.isDirectory()) {
                        add.add(f);
                        continue;
                    }
                    if (!f.getName().endsWith(".class")) continue;
                    result.add(f);
                }
            }
            newDirs.clear();
            newDirs = add;
        }
        return result;
    }
}

