/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmh.util;

import java.io.Serializable;
import org.openjdk.jmh.util.MultisetStatistics;
import org.openjdk.jmh.util.Statistics;

public class SampleBuffer
implements Serializable {
    private static final int PRECISION_BITS = 10;
    private final int[][] hdr = new int[64][];

    public SampleBuffer() {
        for (int p = 0; p < 64; ++p) {
            this.hdr[p] = new int[1024];
        }
    }

    public void half() {
        for (int i = 0; i < 64; ++i) {
            for (int j = 0; j < this.hdr[i].length; ++j) {
                int nV = this.hdr[i][j] / 2;
                if (nV == 0) continue;
                this.hdr[i][j] = nV;
            }
        }
    }

    public void add(long sample) {
        int msb = 64 - Long.numberOfLeadingZeros(sample);
        int bucket = Math.max(0, msb - 10);
        int subBucket = (int)(sample >> bucket);
        int[] nArray = this.hdr[bucket];
        int n = subBucket;
        nArray[n] = nArray[n] + 1;
    }

    public Statistics getStatistics(double multiplier) {
        MultisetStatistics stat = new MultisetStatistics();
        for (int i = 0; i < this.hdr.length; ++i) {
            for (int j = 0; j < this.hdr[i].length; ++j) {
                long ns = (long)j << i;
                stat.addValue(multiplier * (double)ns, this.hdr[i][j]);
            }
        }
        return stat;
    }

    public void addAll(SampleBuffer other) {
        for (int i = 0; i < other.hdr.length; ++i) {
            for (int j = 0; j < other.hdr[i].length; ++j) {
                int[] nArray = this.hdr[i];
                int n = j;
                nArray[n] = nArray[n] + other.hdr[i][j];
            }
        }
    }
}

