/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmh.util;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import sun.misc.Unsafe;

public class Utils {
    private static final Unsafe U;

    private Utils() {
    }

    public static String[] concat(String[] t1, String[] t2) {
        String[] r = new String[t1.length + t2.length];
        System.arraycopy(t1, 0, r, 0, t1.length);
        System.arraycopy(t2, 0, r, t1.length, t2.length);
        return r;
    }

    public static String join(Collection<String> src, String delim) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (String s : src) {
            if (first) {
                first = false;
            } else {
                sb.append(delim);
            }
            sb.append(s);
        }
        return sb.toString();
    }

    public static String join(String[] src, String delim) {
        return Utils.join(Arrays.asList(src), delim);
    }

    public static int sum(int[] arr) {
        int sum = 0;
        for (int i : arr) {
            sum += i;
        }
        return sum;
    }

    public static int roundUp(int v, int quant) {
        if (v % quant == 0) {
            return v;
        }
        return (v / quant + 1) * quant;
    }

    public static int[] unmarshalIntArray(String src) {
        String[] ss = src.split("=");
        int[] arr = new int[ss.length];
        int cnt = 0;
        for (String s : ss) {
            arr[cnt] = Integer.valueOf(s.trim());
            ++cnt;
        }
        return arr;
    }

    public static String marshalIntArray(int[] arr) {
        StringBuilder sb = new StringBuilder();
        for (int i : arr) {
            sb.append(i);
            sb.append("=");
        }
        return sb.toString();
    }

    public static int figureOutHotCPUs() {
        ExecutorService service = Executors.newCachedThreadPool();
        int warmupTime = 1000;
        long lastChange = System.currentTimeMillis();
        ArrayList futures = new ArrayList();
        futures.add(service.submit(new BurningTask()));
        int max = 0;
        while (System.currentTimeMillis() - lastChange < (long)warmupTime) {
            int cur = Runtime.getRuntime().availableProcessors();
            if (cur <= max) continue;
            max = cur;
            lastChange = System.currentTimeMillis();
            futures.add(service.submit(new BurningTask()));
        }
        for (Future future : futures) {
            future.cancel(true);
        }
        service.shutdown();
        return max;
    }

    public static void check(Class<?> klass, String ... fieldNames) {
        for (String fieldName : fieldNames) {
            Utils.check(klass, fieldName);
        }
    }

    public static void check(Class<?> klass, String fieldName) {
        long off;
        long requiredGap = 128L;
        long markerBegin = Utils.getOffset(klass, "markerBegin");
        long markerEnd = Utils.getOffset(klass, "markerEnd");
        if (markerEnd - (off = Utils.getOffset(klass, fieldName)) < 128L || off - markerBegin < 128L) {
            throw new IllegalStateException("Consistency check failed for " + fieldName + ", off = " + off + ", markerBegin = " + markerBegin + ", markerEnd = " + markerEnd);
        }
    }

    public static long getOffset(Class<?> klass, String fieldName) {
        while (true) {
            try {
                Field f = klass.getDeclaredField(fieldName);
                return U.objectFieldOffset(f);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                if ((klass = klass.getSuperclass()) != null) continue;
                throw new IllegalStateException("Can't find field \"" + fieldName + "\"");
            }
            break;
        }
    }

    static {
        try {
            Field unsafe = Unsafe.class.getDeclaredField("theUnsafe");
            unsafe.setAccessible(true);
            U = (Unsafe)unsafe.get(null);
        }
        catch (NoSuchFieldException e) {
            throw new IllegalStateException(e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
    }

    static class BurningTask
    implements Runnable {
        BurningTask() {
        }

        @Override
        public void run() {
            while (!Thread.interrupted()) {
            }
        }
    }
}

