/*
 * Decompiled with CFR 0.152.
 */
package rx.observers;

import rx.Observer;
import rx.exceptions.Exceptions;
import rx.exceptions.OnErrorThrowable;
import rx.internal.operators.NotificationLite;

public class SerializedObserver<T>
implements Observer<T> {
    private final Observer<? super T> actual;
    private boolean emitting;
    private volatile boolean terminated;
    private FastList queue;
    private final NotificationLite<T> nl = NotificationLite.instance();
    private static final int MAX_DRAIN_ITERATION = 1024;

    public SerializedObserver(Observer<? super T> s) {
        this.actual = s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onNext(T t) {
        if (this.terminated) {
            return;
        }
        SerializedObserver serializedObserver = this;
        synchronized (serializedObserver) {
            if (this.terminated) {
                return;
            }
            if (this.emitting) {
                FastList list = this.queue;
                if (list == null) {
                    this.queue = list = new FastList();
                }
                list.add(this.nl.next(t));
                return;
            }
            this.emitting = true;
        }
        try {
            this.actual.onNext(t);
        }
        catch (Throwable e) {
            this.terminated = true;
            Exceptions.throwIfFatal(e);
            this.actual.onError(OnErrorThrowable.addValueAsLastCause(e, t));
            return;
        }
        block10: while (true) {
            int i = 0;
            while (true) {
                FastList list;
                if (i >= 1024) continue block10;
                SerializedObserver serializedObserver2 = this;
                synchronized (serializedObserver2) {
                    list = this.queue;
                    if (list == null) {
                        this.emitting = false;
                        return;
                    }
                    this.queue = null;
                }
                for (Object o : list.array) {
                    if (o == null) break;
                    try {
                        if (!this.nl.accept(this.actual, o)) continue;
                        this.terminated = true;
                        return;
                    }
                    catch (Throwable e) {
                        this.terminated = true;
                        Exceptions.throwIfFatal(e);
                        this.actual.onError(OnErrorThrowable.addValueAsLastCause(e, t));
                        return;
                    }
                }
                ++i;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onError(Throwable e) {
        Exceptions.throwIfFatal(e);
        if (this.terminated) {
            return;
        }
        SerializedObserver serializedObserver = this;
        synchronized (serializedObserver) {
            if (this.terminated) {
                return;
            }
            this.terminated = true;
            if (this.emitting) {
                FastList list = this.queue;
                if (list == null) {
                    this.queue = list = new FastList();
                }
                list.add(this.nl.error(e));
                return;
            }
            this.emitting = true;
        }
        this.actual.onError(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onCompleted() {
        if (this.terminated) {
            return;
        }
        SerializedObserver serializedObserver = this;
        synchronized (serializedObserver) {
            if (this.terminated) {
                return;
            }
            this.terminated = true;
            if (this.emitting) {
                FastList list = this.queue;
                if (list == null) {
                    this.queue = list = new FastList();
                }
                list.add(this.nl.completed());
                return;
            }
            this.emitting = true;
        }
        this.actual.onCompleted();
    }

    static final class FastList {
        Object[] array;
        int size;

        FastList() {
        }

        public void add(Object o) {
            int s = this.size;
            Object[] a = this.array;
            if (a == null) {
                this.array = a = new Object[16];
            } else if (s == a.length) {
                Object[] array2 = new Object[s + (s >> 2)];
                System.arraycopy(a, 0, array2, 0, s);
                this.array = a = array2;
            }
            a[s] = o;
            this.size = s + 1;
        }
    }
}

