/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.netty.examples.http.interceptors.transformation;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.handler.logging.LogLevel;
import io.reactivex.netty.channel.AllocatingTransformer;
import io.reactivex.netty.examples.ExamplesEnvironment;
import io.reactivex.netty.examples.http.interceptors.transformation.TransformingInterceptorsServer;
import io.reactivex.netty.protocol.http.client.HttpClient;
import io.reactivex.netty.protocol.http.client.HttpClientResponse;
import io.reactivex.netty.protocol.http.client.TransformingInterceptor;
import io.reactivex.netty.protocol.http.util.HttpContentStringLineDecoder;
import java.net.SocketAddress;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import rx.Observable;

public final class InterceptingClient {
    public static void main(String[] args) {
        ExamplesEnvironment env = ExamplesEnvironment.newEnvironment(InterceptingClient.class);
        Logger logger = env.getLogger();
        SocketAddress serverAddress = env.getServerAddress(TransformingInterceptorsServer.class, args);
        HttpClient.newClient((SocketAddress)serverAddress).addChannelHandlerLast("line-decoder", HttpContentStringLineDecoder::new).enableWireLogging("inter-client", LogLevel.DEBUG).intercept().nextWithTransform(InterceptingClient.readWriteInts()).finish().createPost("/ints").writeContent(Observable.just((Object)1)).doOnNext(resp -> logger.info(resp.toString())).flatMap(HttpClientResponse::getContent).map(Object::toString).toBlocking().forEach(arg_0 -> ((Logger)logger).info(arg_0));
    }

    private static TransformingInterceptor<ByteBuf, String, Integer, Integer> readWriteInts() {
        return provider -> (version, method, uri) -> provider.createRequest(version, method, uri).transformContent(InterceptingClient.intToByteBuffer()).transformResponseContent(o -> o.filter(s -> !s.isEmpty()).map(Integer::parseInt));
    }

    private static AllocatingTransformer<Integer, ByteBuf> intToByteBuffer() {
        return new AllocatingTransformer<Integer, ByteBuf>(){

            public List<ByteBuf> transform(Integer toTransform, ByteBufAllocator allocator) {
                byte[] toWrite = toTransform.toString().getBytes();
                return Collections.singletonList(allocator.buffer().writeBytes(toWrite));
            }
        };
    }
}

