/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.netty.examples.http.interceptors.transformation;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.handler.logging.LogLevel;
import io.reactivex.netty.channel.AllocatingTransformer;
import io.reactivex.netty.examples.ExamplesEnvironment;
import io.reactivex.netty.protocol.http.server.HttpServer;
import io.reactivex.netty.protocol.http.server.HttpServerInterceptorChain;
import io.reactivex.netty.protocol.http.server.RequestHandler;
import io.reactivex.netty.protocol.http.util.HttpContentStringLineDecoder;
import java.util.Collections;
import java.util.List;
import rx.Observable;

public final class TransformingInterceptorsServer {
    public static void main(String[] args) {
        ExamplesEnvironment env = ExamplesEnvironment.newEnvironment(TransformingInterceptorsServer.class);
        HttpServer server = HttpServer.newServer().addChannelHandlerLast("line-decoder", HttpContentStringLineDecoder::new).enableWireLogging("inter-server", LogLevel.DEBUG).start(HttpServerInterceptorChain.start().nextWithTransform(TransformingInterceptorsServer.readWriteInts()).end(TransformingInterceptorsServer.numberIncrementingHandler()));
        if (env.shouldWaitForShutdown(args)) {
            server.awaitShutdown();
        }
        env.registerServerAddress(server.getServerAddress());
    }

    private static RequestHandler<Integer, Integer> numberIncrementingHandler() {
        return (req, resp) -> resp.write(req.getContent().flatMap(integer -> {
            Integer n = integer;
            integer = integer + 1;
            return Observable.just((Object)n, (Object)integer);
        }));
    }

    private static HttpServerInterceptorChain.TransformingInterceptor<String, ByteBuf, Integer, Integer> readWriteInts() {
        return handler -> (request, response) -> handler.handle(request.transformContent(TransformingInterceptorsServer.stringToInt()), response.transformContent((AllocatingTransformer)new AllocatingTransformer<Integer, ByteBuf>(){

            public List<ByteBuf> transform(Integer toTransform, ByteBufAllocator allocator) {
                String msg = toTransform.toString() + '\n';
                return Collections.singletonList(allocator.buffer().writeBytes(msg.getBytes()));
            }
        }));
    }

    private static Observable.Transformer<String, Integer> stringToInt() {
        return o -> o.filter(s -> !s.isEmpty()).map(Integer::parseInt);
    }
}

