/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.netty.examples.http.proxy;

import io.netty.handler.logging.LogLevel;
import io.reactivex.netty.examples.ExamplesEnvironment;
import io.reactivex.netty.protocol.http.client.HttpClient;
import io.reactivex.netty.protocol.http.client.HttpClientRequest;
import io.reactivex.netty.protocol.http.server.HttpServer;
import java.util.Iterator;
import java.util.Map;
import rx.Observable;

public final class ProxyServer {
    public static void main(String[] args) {
        ExamplesEnvironment env = ExamplesEnvironment.newEnvironment(ProxyServer.class);
        int targetServerPort = ProxyServer.startTargetServer();
        HttpClient targetClient = HttpClient.newClient((String)"127.0.0.1", (int)targetServerPort);
        HttpServer server = HttpServer.newServer().enableWireLogging("proxy-server", LogLevel.DEBUG).start((serverReq, serverResp) -> {
            HttpClientRequest clientReq = targetClient.createRequest(serverReq.getHttpMethod(), serverReq.getUri());
            Iterator serverReqHeaders = serverReq.headerIterator();
            while (serverReqHeaders.hasNext()) {
                Map.Entry next = (Map.Entry)serverReqHeaders.next();
                clientReq = clientReq.setHeader((CharSequence)next.getKey(), next.getValue());
            }
            return clientReq.writeContent((Observable)serverReq.getContent()).flatMap(clientResp -> {
                Iterator clientRespHeaders = clientResp.headerIterator();
                while (clientRespHeaders.hasNext()) {
                    Map.Entry next = (Map.Entry)clientRespHeaders.next();
                    serverResp.setHeader((CharSequence)next.getKey(), next.getValue());
                }
                serverResp.setHeader((CharSequence)"X-Proxied-By", (Object)"RxNetty");
                return serverResp.write((Observable)clientResp.getContent());
            });
        });
        if (env.shouldWaitForShutdown(args)) {
            server.awaitShutdown();
        }
        env.registerServerAddress(server.getServerAddress());
    }

    private static int startTargetServer() {
        return HttpServer.newServer().start((req, resp) -> resp.writeString(Observable.just((Object)"HelloWorld!"))).getServerPort();
    }
}

