/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.netty.examples.http.ws.messaging;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.UnpooledByteBufAllocator;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;

public class MessageFrame
extends BinaryWebSocketFrame {
    private final MessageType type;
    private final long id;

    public MessageFrame(MessageType type, long id) {
        this(type, id, (ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT);
    }

    public MessageFrame(MessageType type, long id, ByteBufAllocator allocator) {
        super(allocator.buffer().writeByte(type.ordinal()).writeLong(id));
        this.type = type;
        this.id = id;
    }

    public MessageFrame(ByteBuf binaryData) {
        super(binaryData);
        binaryData.markReaderIndex();
        byte typeRead = binaryData.readByte();
        switch (typeRead) {
            case 0: {
                this.type = MessageType.Message;
                break;
            }
            case 1: {
                this.type = MessageType.Ack;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected message type: " + typeRead);
            }
        }
        this.id = binaryData.readLong();
        binaryData.resetReaderIndex();
    }

    public long getId() {
        return this.id;
    }

    public MessageType getType() {
        return this.type;
    }

    public String toString() {
        return "MessageFrame{id=" + this.id + ", type=" + (Object)((Object)this.type) + '}';
    }

    public static enum MessageType {
        Message,
        Ack;

    }
}

