/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.netty.examples.local;

import io.netty.buffer.ByteBuf;
import io.netty.channel.DefaultEventLoopGroup;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.local.LocalAddress;
import io.netty.channel.local.LocalChannel;
import io.netty.channel.local.LocalServerChannel;
import io.netty.handler.logging.LogLevel;
import io.reactivex.netty.examples.ExamplesEnvironment;
import io.reactivex.netty.protocol.tcp.client.TcpClient;
import io.reactivex.netty.protocol.tcp.server.TcpServer;
import io.reactivex.netty.threads.RxDefaultThreadFactory;
import java.net.SocketAddress;
import java.nio.charset.Charset;
import java.util.concurrent.ThreadFactory;
import org.slf4j.Logger;
import rx.Observable;

public final class LocalEcho {
    public static void main(String[] args) {
        ExamplesEnvironment env = ExamplesEnvironment.newEnvironment(LocalEcho.class);
        Logger logger = env.getLogger();
        LocalAddress serverAddress = new LocalAddress("local-example");
        DefaultEventLoopGroup eventLoopGroup = new DefaultEventLoopGroup(0, (ThreadFactory)new RxDefaultThreadFactory("local-server"));
        TcpServer.newServer((SocketAddress)serverAddress, (EventLoopGroup)eventLoopGroup, LocalServerChannel.class).enableWireLogging("echo-server", LogLevel.DEBUG).start(connection -> connection.writeStringAndFlushOnEach(connection.getInput().map(bb -> bb.toString(Charset.defaultCharset())).map(msg -> "echo => " + msg)));
        TcpClient.newClient((SocketAddress)serverAddress, (EventLoopGroup)eventLoopGroup, LocalChannel.class).enableWireLogging("echo-client", LogLevel.DEBUG).createConnectionRequest().flatMap(connection -> connection.writeString(Observable.just((Object)"Hello World!")).cast(ByteBuf.class).concatWith((Observable)connection.getInput())).take(1).map(bb -> bb.toString(Charset.defaultCharset())).toBlocking().forEach(arg_0 -> ((Logger)logger).info(arg_0));
    }
}

