/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.netty.examples.tcp.interceptors.simple;

import io.netty.buffer.ByteBuf;
import io.reactivex.netty.examples.ExamplesEnvironment;
import io.reactivex.netty.protocol.tcp.server.ConnectionHandler;
import io.reactivex.netty.protocol.tcp.server.TcpServer;
import io.reactivex.netty.protocol.tcp.server.TcpServerInterceptorChain;
import java.nio.charset.Charset;
import rx.Observable;

public final class InterceptingServer {
    public static void main(String[] args) {
        ExamplesEnvironment env = ExamplesEnvironment.newEnvironment(InterceptingServer.class);
        TcpServer server = TcpServer.newServer((int)0).start(TcpServerInterceptorChain.startRaw(InterceptingServer.sendHello()).end(InterceptingServer.echoHandler()));
        if (env.shouldWaitForShutdown(args)) {
            server.awaitShutdown();
        }
        env.registerServerAddress(server.getServerAddress());
    }

    private static TcpServerInterceptorChain.Interceptor<ByteBuf, ByteBuf> sendHello() {
        return in -> newConnection -> newConnection.writeString(Observable.just((Object)"Hello\n")).concatWith(in.handle(newConnection));
    }

    private static ConnectionHandler<ByteBuf, ByteBuf> echoHandler() {
        return conn -> conn.writeStringAndFlushOnEach(conn.getInput().map(msg -> "echo => " + msg.toString(Charset.defaultCharset()) + "\n"));
    }
}

