/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.netty.examples.tcp.interceptors.transformation;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.reactivex.netty.channel.AllocatingTransformer;
import io.reactivex.netty.channel.Connection;
import io.reactivex.netty.examples.ExamplesEnvironment;
import io.reactivex.netty.examples.tcp.interceptors.transformation.TransformingInterceptorsServer;
import io.reactivex.netty.protocol.tcp.client.TcpClient;
import io.reactivex.netty.util.StringLineDecoder;
import java.net.SocketAddress;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import rx.Observable;
import rx.functions.Func1;

public final class InterceptingClient {
    public static void main(String[] args) {
        ExamplesEnvironment env = ExamplesEnvironment.newEnvironment(InterceptingClient.class);
        Logger logger = env.getLogger();
        SocketAddress serverAddress = env.getServerAddress(TransformingInterceptorsServer.class, args);
        TcpClient.newClient((SocketAddress)serverAddress).addChannelHandlerLast("string-line-decoder", StringLineDecoder::new).intercept().next(provider -> () -> provider.newConnectionRequest().map(InterceptingClient.skipHello())).nextWithReadTransform(provider -> () -> provider.newConnectionRequest().map(InterceptingClient.readIntegers())).nextWithWriteTransform(provider -> () -> provider.newConnectionRequest().map(InterceptingClient.writeIntegers())).finish().createConnectionRequest().flatMap(connection -> connection.write(Observable.just((Object)1)).cast(Integer.class).mergeWith((Observable)connection.getInput())).take(2).map(Object::toString).toBlocking().forEach(arg_0 -> ((Logger)logger).info(arg_0));
    }

    private static Func1<Connection<String, ByteBuf>, Connection<String, ByteBuf>> skipHello() {
        return c -> c.transformRead(o -> o.skip(1));
    }

    private static Func1<Connection<String, ByteBuf>, Connection<Integer, ByteBuf>> readIntegers() {
        return c -> c.transformRead(o -> o.filter(s1 -> !s1.isEmpty()).flatMap(s -> Observable.from((Object[])s.split(" ")).map(Integer::parseInt)));
    }

    private static Func1<? super Connection<Integer, ByteBuf>, Connection<Integer, Integer>> writeIntegers() {
        return c -> c.transformWrite((AllocatingTransformer)new AllocatingTransformer<Integer, ByteBuf>(){

            public List<ByteBuf> transform(Integer toTransform, ByteBufAllocator allocator) {
                ByteBuf b = allocator.buffer().writeBytes((toTransform.toString() + "\n").getBytes());
                return Collections.singletonList(b);
            }
        });
    }
}

