/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.netty.examples.tcp.interceptors.transformation;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.reactivex.netty.channel.AllocatingTransformer;
import io.reactivex.netty.examples.ExamplesEnvironment;
import io.reactivex.netty.protocol.tcp.server.ConnectionHandler;
import io.reactivex.netty.protocol.tcp.server.TcpServer;
import io.reactivex.netty.protocol.tcp.server.TcpServerInterceptorChain;
import io.reactivex.netty.util.StringLineDecoder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import rx.Observable;

public final class TransformingInterceptorsServer {
    public static void main(String[] args) {
        ExamplesEnvironment env = ExamplesEnvironment.newEnvironment(TransformingInterceptorsServer.class);
        TcpServer server = TcpServer.newServer((int)0).addChannelHandlerLast("string-line-decoder", StringLineDecoder::new).start(TcpServerInterceptorChain.start(TransformingInterceptorsServer.sendHello()).nextWithWriteTransform(TransformingInterceptorsServer.writeStrings()).nextWithTransform(TransformingInterceptorsServer.readAndWriteInts()).end(TransformingInterceptorsServer.numberIncrementingHandler()));
        if (env.shouldWaitForShutdown(args)) {
            server.awaitShutdown();
        }
        env.registerServerAddress(server.getServerAddress());
    }

    private static TcpServerInterceptorChain.Interceptor<String, ByteBuf> sendHello() {
        return in -> newConnection -> newConnection.writeString(Observable.just((Object)"Hello\n")).concatWith(in.handle(newConnection));
    }

    private static TcpServerInterceptorChain.TransformingInterceptor<String, ByteBuf, String, String> writeStrings() {
        return in -> newConnection -> in.handle(newConnection.transformWrite(TransformingInterceptorsServer.transformStringToBytes()));
    }

    private static TcpServerInterceptorChain.TransformingInterceptor<String, String, Integer, Integer> readAndWriteInts() {
        return in -> newConnection -> in.handle(newConnection.transformRead(o -> o.map(String::trim).filter(s -> !s.isEmpty()).map(Integer::parseInt)).transformWrite(TransformingInterceptorsServer.transformStringToInteger()));
    }

    private static ConnectionHandler<Integer, Integer> numberIncrementingHandler() {
        return conn -> conn.writeAndFlushOnEach(conn.getInput().map(anInt -> {
            anInt = anInt + 1;
            return anInt;
        }));
    }

    private static AllocatingTransformer<String, ByteBuf> transformStringToBytes() {
        return new AllocatingTransformer<String, ByteBuf>(){

            public List<ByteBuf> transform(String toTransform, ByteBufAllocator allocator) {
                return Collections.singletonList(allocator.buffer().writeBytes(toTransform.getBytes()));
            }
        };
    }

    private static AllocatingTransformer<Integer, String> transformStringToInteger() {
        return new AllocatingTransformer<Integer, String>(){

            public List<String> transform(Integer toTransform, ByteBufAllocator allocator) {
                String[] stringArray = new String[4];
                stringArray[0] = String.valueOf(toTransform);
                stringArray[1] = " ";
                toTransform = toTransform + 1;
                stringArray[2] = String.valueOf(toTransform);
                stringArray[3] = "\n";
                return Arrays.asList(stringArray);
            }
        };
    }
}

