/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.netty.examples.tcp.loadbalancing;

import io.reactivex.netty.client.ConnectionProvider;
import io.reactivex.netty.client.HostConnector;
import io.reactivex.netty.client.events.ClientEventListener;
import io.reactivex.netty.client.loadbalancer.HostHolder;
import io.reactivex.netty.client.loadbalancer.LoadBalancingStrategy;
import java.net.SocketException;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import rx.Observable;
import rx.functions.Func1;

public abstract class AbstractLoadBalancer<W, R>
implements LoadBalancingStrategy<W, R> {
    private final Func1<Integer, Integer> nextIndexFinder;

    protected AbstractLoadBalancer(Func1<Integer, Integer> nextIndexFinder) {
        this.nextIndexFinder = nextIndexFinder;
    }

    protected AbstractLoadBalancer() {
        this(new Func1<Integer, Integer>(){
            private final AtomicInteger nextIndex = new AtomicInteger();

            public Integer call(Integer maxValue) {
                return this.nextIndex.incrementAndGet() % maxValue;
            }
        });
    }

    public ConnectionProvider<W, R> newStrategy(List<HostHolder<W, R>> hosts) {
        int size = hosts.size();
        return () -> Observable.create(subscriber -> {
            long weight2;
            HostHolder host1 = (HostHolder)hosts.get((Integer)this.nextIndexFinder.call((Object)size));
            HostHolder host2 = (HostHolder)hosts.get((Integer)this.nextIndexFinder.call((Object)size));
            long weight1 = this.getWeight(host1.getEventListener());
            ConnectionProvider hostToUse = weight1 >= (weight2 = this.getWeight(host2.getEventListener())) ? host1.getConnector().getConnectionProvider() : host2.getConnector().getConnectionProvider();
            hostToUse.newConnectionRequest().unsafeSubscribe(subscriber);
        }).retry((count, th) -> count < 3 && th instanceof SocketException);
    }

    public final HostHolder<W, R> toHolder(HostConnector<W, R> connector) {
        return new HostHolder(connector, this.newListener());
    }

    protected abstract ClientEventListener newListener();

    protected abstract long getWeight(ClientEventListener var1);
}

