/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.netty.examples.tcp.proxy;

import io.netty.handler.logging.LogLevel;
import io.reactivex.netty.client.ConnectionRequest;
import io.reactivex.netty.examples.ExamplesEnvironment;
import io.reactivex.netty.protocol.tcp.client.TcpClient;
import io.reactivex.netty.protocol.tcp.server.TcpServer;
import java.net.SocketAddress;
import java.nio.charset.Charset;
import rx.Observable;

public final class ProxyServer {
    public static void main(String[] args) {
        ExamplesEnvironment env = ExamplesEnvironment.newEnvironment(ProxyServer.class);
        TcpClient targetClient = TcpClient.newClient((SocketAddress)ProxyServer.startTargetServer());
        ConnectionRequest connReq = targetClient.createConnectionRequest();
        TcpServer server = TcpServer.newServer().enableWireLogging("proxy-server", LogLevel.DEBUG).start(serverConn -> serverConn.writeStringAndFlushOnEach(connReq.flatMap(clientConn -> {
            Observable clientOutput = clientConn.getInput().map(bb -> bb.toString(Charset.defaultCharset())).map(msg -> "proxy => " + msg);
            return clientConn.writeAndFlushOnEach((Observable)serverConn.getInput()).cast(String.class).mergeWith(clientOutput);
        })));
        if (env.shouldWaitForShutdown(args)) {
            server.awaitShutdown();
        }
        env.registerServerAddress(server.getServerAddress());
    }

    private static SocketAddress startTargetServer() {
        return TcpServer.newServer().start(c -> c.writeStringAndFlushOnEach(c.getInput().map(bb -> bb.toString(Charset.defaultCharset())).map(msg -> "echo => " + msg))).getServerAddress();
    }
}

