/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.netty.protocol.http.client.loadbalancer;

import io.reactivex.netty.client.Host;
import io.reactivex.netty.client.events.ClientEventListener;
import io.reactivex.netty.client.loadbalancer.AbstractP2CStrategy;
import io.reactivex.netty.protocol.http.client.events.HttpClientEventsListener;
import java.util.concurrent.TimeUnit;

public class EWMABasedP2CStrategy<W, R>
extends AbstractP2CStrategy<W, R, ClientEventListener> {
    private static final double STARTUP_PENALTY = 2.251799813685247E15;
    private final double tauUp;
    private final double tauDown;
    private double penaltyOnConnectionFailure;
    private double penaltyOn503;

    public EWMABasedP2CStrategy(double tauUp, double tauDown, double penaltyOnConnectionFailure, double penaltyOn503) {
        this.tauUp = tauUp;
        this.tauDown = tauDown;
        this.penaltyOnConnectionFailure = penaltyOnConnectionFailure;
        this.penaltyOn503 = penaltyOn503;
    }

    public EWMABasedP2CStrategy() {
        this(TimeUnit.NANOSECONDS.convert(1L, TimeUnit.SECONDS), TimeUnit.NANOSECONDS.convert(15L, TimeUnit.SECONDS), 2.0, 5.0);
    }

    protected HttpClientListenerImpl newListener(Host host) {
        return new HttpClientListenerImpl();
    }

    protected double getWeight(ClientEventListener listener) {
        return ((HttpClientListenerImpl)listener).getWeight();
    }

    public class HttpClientListenerImpl
    extends HttpClientEventsListener {
        private final long epoch;
        private long stamp;
        private int pending;
        private double cost;

        public HttpClientListenerImpl() {
            this.stamp = this.epoch = System.nanoTime();
            this.pending = 0;
            this.cost = 0.0;
        }

        public double getWeight() {
            this.observe(0.0);
            if (this.cost == 0.0 && this.pending != 0) {
                return 2.251799813685247E15 + (double)this.pending;
            }
            return this.cost * (double)(this.pending + 1);
        }

        @Override
        public synchronized void onRequestWriteComplete(long duration, TimeUnit timeUnit) {
            ++this.pending;
        }

        @Override
        public synchronized void onResponseReceiveComplete(long duration, TimeUnit timeUnit) {
            --this.pending;
            this.observe(TimeUnit.NANOSECONDS.convert(duration, timeUnit));
        }

        @Override
        public void onResponseHeadersReceived(int responseCode, long duration, TimeUnit timeUnit) {
            if (responseCode == 503) {
                this.observe((double)TimeUnit.NANOSECONDS.convert(duration, timeUnit) * EWMABasedP2CStrategy.this.penaltyOn503);
            }
        }

        public void onConnectFailed(long duration, TimeUnit timeUnit, Throwable throwable) {
            this.observe((double)TimeUnit.NANOSECONDS.convert(duration, timeUnit) * EWMABasedP2CStrategy.this.penaltyOnConnectionFailure);
        }

        private void observe(double rtt) {
            long t = System.nanoTime();
            long td = Math.max(t - this.stamp, 0L);
            if (rtt > this.cost) {
                double w = Math.exp((double)(-td) / EWMABasedP2CStrategy.this.tauUp);
                this.cost = this.cost * w + rtt * (1.0 - w);
            } else {
                double w = Math.exp((double)(-td) / EWMABasedP2CStrategy.this.tauDown);
                this.cost = this.cost * w + rtt * (1.0 - w);
            }
            this.stamp = t;
        }
    }
}

