/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.netty.protocol.http.internal;

import io.reactivex.netty.protocol.http.TrailingHeaders;
import rx.Observable;
import rx.Subscriber;
import rx.exceptions.Exceptions;
import rx.exceptions.OnErrorThrowable;
import rx.functions.Func0;
import rx.functions.Func2;

public class OperatorTrailer<T extends TrailingHeaders>
implements Observable.Operator {
    private final Func0<T> trailerFactory;
    private final Func2 trailerMutator;

    public OperatorTrailer(Func0<T> trailerFactory, Func2 trailerMutator) {
        this.trailerFactory = trailerFactory;
        this.trailerMutator = trailerMutator;
    }

    public Object call(Object child) {
        final Subscriber subscriber = (Subscriber)child;
        return new Subscriber(subscriber){
            private T trailer;
            {
                super(x0);
                this.trailer = (TrailingHeaders)OperatorTrailer.this.trailerFactory.call();
            }

            public void onCompleted() {
                subscriber.onNext(this.trailer);
                subscriber.onCompleted();
            }

            public void onError(Throwable e) {
                subscriber.onError(e);
            }

            public void onNext(Object i) {
                try {
                    this.trailer = (TrailingHeaders)OperatorTrailer.this.trailerMutator.call(this.trailer, i);
                    subscriber.onNext(i);
                }
                catch (Throwable e) {
                    Exceptions.throwIfFatal((Throwable)e);
                    this.onError(OnErrorThrowable.addValueAsLastCause((Throwable)e, (Object)i));
                }
            }
        };
    }

    public static <T extends TrailingHeaders> Observable liftFrom(Observable source, Func0<T> trailerFactory, Func2 trailerMutator) {
        return source.lift(new OperatorTrailer<T>(trailerFactory, trailerMutator));
    }
}

