/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.netty.protocol.http.server.events;

import io.reactivex.netty.events.EventListener;
import io.reactivex.netty.events.EventPublisher;
import io.reactivex.netty.events.EventSource;
import io.reactivex.netty.events.ListenersHolder;
import io.reactivex.netty.events.internal.SafeEventListener;
import io.reactivex.netty.protocol.http.server.events.HttpServerEventsListener;
import io.reactivex.netty.protocol.http.server.events.SafeHttpServerEventsListener;
import io.reactivex.netty.protocol.tcp.server.events.TcpServerEventListener;
import io.reactivex.netty.protocol.tcp.server.events.TcpServerEventPublisher;
import java.util.concurrent.TimeUnit;
import rx.Subscription;
import rx.functions.Action1;
import rx.functions.Action3;
import rx.functions.Action4;
import rx.subscriptions.CompositeSubscription;

public final class HttpServerEventPublisher
extends HttpServerEventsListener
implements EventSource<HttpServerEventsListener>,
EventPublisher {
    private static final Action1<HttpServerEventsListener> NEW_REQUEST_ACTION = new Action1<HttpServerEventsListener>(){

        public void call(HttpServerEventsListener l) {
            l.onNewRequestReceived();
        }
    };
    private static final Action3<HttpServerEventsListener, Long, TimeUnit> HANDLE_START_ACTION = new Action3<HttpServerEventsListener, Long, TimeUnit>(){

        public void call(HttpServerEventsListener l, Long duration, TimeUnit timeUnit) {
            l.onRequestHandlingStart(duration, timeUnit);
        }
    };
    private static final Action3<HttpServerEventsListener, Long, TimeUnit> HANDLE_SUCCESS_ACTION = new Action3<HttpServerEventsListener, Long, TimeUnit>(){

        public void call(HttpServerEventsListener l, Long duration, TimeUnit timeUnit) {
            l.onRequestHandlingSuccess(duration, timeUnit);
        }
    };
    private static final Action4<HttpServerEventsListener, Long, TimeUnit, Throwable> HANDLE_FAILED_ACTION = new Action4<HttpServerEventsListener, Long, TimeUnit, Throwable>(){

        public void call(HttpServerEventsListener l, Long duration, TimeUnit timeUnit, Throwable t) {
            l.onRequestHandlingFailed(duration, timeUnit, t);
        }
    };
    private static final Action1<HttpServerEventsListener> HEADER_RECIEVED_ACTION = new Action1<HttpServerEventsListener>(){

        public void call(HttpServerEventsListener l) {
            l.onRequestHeadersReceived();
        }
    };
    private static final Action1<HttpServerEventsListener> CONTENT_RECIEVED_ACTION = new Action1<HttpServerEventsListener>(){

        public void call(HttpServerEventsListener l) {
            l.onRequestContentReceived();
        }
    };
    private static final Action3<HttpServerEventsListener, Long, TimeUnit> REQ_RECV_COMPLETE_ACTION = new Action3<HttpServerEventsListener, Long, TimeUnit>(){

        public void call(HttpServerEventsListener l, Long duration, TimeUnit timeUnit) {
            l.onRequestReceiveComplete(duration, timeUnit);
        }
    };
    private static final Action1<HttpServerEventsListener> RESP_WRITE_START_ACTION = new Action1<HttpServerEventsListener>(){

        public void call(HttpServerEventsListener l) {
            l.onResponseWriteStart();
        }
    };
    private static final Action4<HttpServerEventsListener, Long, TimeUnit, Integer> RESP_WRITE_SUCCESS_ACTION = new Action4<HttpServerEventsListener, Long, TimeUnit, Integer>(){

        public void call(HttpServerEventsListener l, Long duration, TimeUnit timeUnit, Integer respCode) {
            l.onResponseWriteSuccess(duration, timeUnit, respCode);
        }
    };
    private static final Action4<HttpServerEventsListener, Long, TimeUnit, Throwable> RESP_WRITE_FAILED_ACTION = new Action4<HttpServerEventsListener, Long, TimeUnit, Throwable>(){

        public void call(HttpServerEventsListener l, Long duration, TimeUnit timeUnit, Throwable t) {
            l.onResponseWriteFailed(duration, timeUnit, t);
        }
    };
    private final ListenersHolder<HttpServerEventsListener> listeners;
    private final TcpServerEventPublisher tcpDelegate;

    public HttpServerEventPublisher(TcpServerEventPublisher tcpDelegate) {
        this.listeners = new ListenersHolder();
        this.tcpDelegate = tcpDelegate;
    }

    public HttpServerEventPublisher(TcpServerEventPublisher tcpDelegate, ListenersHolder<HttpServerEventsListener> l) {
        this.tcpDelegate = tcpDelegate;
        this.listeners = l;
    }

    @Override
    public void onNewRequestReceived() {
        this.listeners.invokeListeners(NEW_REQUEST_ACTION);
    }

    @Override
    public void onRequestHandlingStart(long duration, TimeUnit timeUnit) {
        this.listeners.invokeListeners(HANDLE_START_ACTION, duration, timeUnit);
    }

    @Override
    public void onRequestHandlingSuccess(long duration, TimeUnit timeUnit) {
        this.listeners.invokeListeners(HANDLE_SUCCESS_ACTION, duration, timeUnit);
    }

    @Override
    public void onRequestHandlingFailed(long duration, TimeUnit timeUnit, Throwable throwable) {
        this.listeners.invokeListeners(HANDLE_FAILED_ACTION, duration, timeUnit, throwable);
    }

    @Override
    public void onRequestHeadersReceived() {
        this.listeners.invokeListeners(HEADER_RECIEVED_ACTION);
    }

    @Override
    public void onRequestContentReceived() {
        this.listeners.invokeListeners(CONTENT_RECIEVED_ACTION);
    }

    @Override
    public void onRequestReceiveComplete(long duration, TimeUnit timeUnit) {
        this.listeners.invokeListeners(REQ_RECV_COMPLETE_ACTION, duration, timeUnit);
    }

    @Override
    public void onResponseWriteStart() {
        this.listeners.invokeListeners(RESP_WRITE_START_ACTION);
    }

    @Override
    public void onResponseWriteSuccess(long duration, TimeUnit timeUnit, int responseCode) {
        this.listeners.invokeListeners(RESP_WRITE_SUCCESS_ACTION, duration, timeUnit, (Object)responseCode);
    }

    @Override
    public void onResponseWriteFailed(long duration, TimeUnit timeUnit, Throwable throwable) {
        this.listeners.invokeListeners(RESP_WRITE_FAILED_ACTION, duration, timeUnit, throwable);
    }

    public void onConnectionCloseFailed(long duration, TimeUnit timeUnit, Throwable throwable) {
        this.tcpDelegate.onConnectionCloseFailed(duration, timeUnit, throwable);
    }

    public void onConnectionCloseSuccess(long duration, TimeUnit timeUnit) {
        this.tcpDelegate.onConnectionCloseSuccess(duration, timeUnit);
    }

    public void onConnectionCloseStart() {
        this.tcpDelegate.onConnectionCloseStart();
    }

    public void onWriteFailed(long duration, TimeUnit timeUnit, Throwable throwable) {
        this.tcpDelegate.onWriteFailed(duration, timeUnit, throwable);
    }

    public void onWriteSuccess(long duration, TimeUnit timeUnit) {
        this.tcpDelegate.onWriteSuccess(duration, timeUnit);
    }

    public void onWriteStart() {
        this.tcpDelegate.onWriteStart();
    }

    public void onFlushComplete(long duration, TimeUnit timeUnit) {
        this.tcpDelegate.onFlushComplete(duration, timeUnit);
    }

    public void onFlushStart() {
        this.tcpDelegate.onFlushStart();
    }

    public void onByteRead(long bytesRead) {
        this.tcpDelegate.onByteRead(bytesRead);
    }

    public void onByteWritten(long bytesWritten) {
        this.tcpDelegate.onByteWritten(bytesWritten);
    }

    public void onConnectionHandlingFailed(long duration, TimeUnit timeUnit, Throwable throwable) {
        this.tcpDelegate.onConnectionHandlingFailed(duration, timeUnit, throwable);
    }

    public void onConnectionHandlingSuccess(long duration, TimeUnit timeUnit) {
        this.tcpDelegate.onConnectionHandlingSuccess(duration, timeUnit);
    }

    public void onConnectionHandlingStart(long duration, TimeUnit timeUnit) {
        this.tcpDelegate.onConnectionHandlingStart(duration, timeUnit);
    }

    public void onCustomEvent(Object event) {
        this.tcpDelegate.onCustomEvent(event);
    }

    public void onCustomEvent(Object event, long duration, TimeUnit timeUnit) {
        this.tcpDelegate.onCustomEvent(event, duration, timeUnit);
    }

    public void onCustomEvent(Object event, long duration, TimeUnit timeUnit, Throwable throwable) {
        this.tcpDelegate.onCustomEvent(event, duration, timeUnit, throwable);
    }

    public void onCustomEvent(Object event, Throwable throwable) {
        this.tcpDelegate.onCustomEvent(event, throwable);
    }

    public void onNewClientConnected() {
        this.tcpDelegate.onNewClientConnected();
    }

    public boolean publishingEnabled() {
        return this.listeners.publishingEnabled();
    }

    public Subscription subscribe(HttpServerEventsListener listener) {
        if (!SafeEventListener.class.isAssignableFrom(((Object)((Object)listener)).getClass())) {
            listener = new SafeHttpServerEventsListener(listener);
        }
        CompositeSubscription cs = new CompositeSubscription();
        cs.add(this.listeners.subscribe((EventListener)listener));
        HttpServerEventsListener tcpListener = listener;
        if (listener instanceof SafeHttpServerEventsListener) {
            tcpListener = ((SafeHttpServerEventsListener)listener).unwrap();
        }
        cs.add(this.tcpDelegate.subscribe((TcpServerEventListener)tcpListener));
        return cs;
    }

    public HttpServerEventPublisher copy(TcpServerEventPublisher newTcpDelegate) {
        return new HttpServerEventPublisher(newTcpDelegate, (ListenersHolder<HttpServerEventsListener>)this.listeners.copy());
    }

    ListenersHolder<HttpServerEventsListener> getListeners() {
        return this.listeners;
    }

    TcpServerEventPublisher getTcpDelegate() {
        return this.tcpDelegate;
    }
}

