/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.netty;

import io.reactivex.netty.SubscribeInfo;
import io.reactivex.netty.codec.Decoder;
import java.util.Map;
import rx.functions.Action2;

public class ConnectConfiguration<T> {
    private String host;
    private int port;
    private String name;
    private Decoder<T> decoder;
    private Map<String, String> subscribeParameters;
    private int subscribeRetryAttempts;
    private Action2<SubscribeInfo, Throwable> subscribeErrorHandler;
    private boolean suppressSubscribeErrors = false;
    private Action2<T, Throwable> deocdingErrorHandler;
    private boolean suppressDecodingErrors = false;

    ConnectConfiguration(Builder<T> builder) {
        this.host = ((Builder)builder).host;
        this.name = ((Builder)builder).name;
        this.port = ((Builder)builder).port;
        this.decoder = ((Builder)builder).decoder;
        this.subscribeParameters = ((Builder)builder).subscribeParameters;
        this.subscribeRetryAttempts = ((Builder)builder).subscribeRetryAttempts;
        this.subscribeErrorHandler = ((Builder)builder).subscribeErrorHandler;
        this.suppressSubscribeErrors = ((Builder)builder).suppressSubscribeErrors;
        this.deocdingErrorHandler = ((Builder)builder).deocdingErrorHandler;
        this.suppressDecodingErrors = ((Builder)builder).suppressDecodingErrors;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getName() {
        return this.name;
    }

    public Decoder<T> getDecoder() {
        return this.decoder;
    }

    public Map<String, String> getSubscribeParameters() {
        return this.subscribeParameters;
    }

    public int getSubscribeRetryAttempts() {
        return this.subscribeRetryAttempts;
    }

    public Action2<SubscribeInfo, Throwable> getSubscribeErrorHandler() {
        return this.subscribeErrorHandler;
    }

    public boolean isSuppressSubscribeErrors() {
        return this.suppressSubscribeErrors;
    }

    public Action2<T, Throwable> getDeocdingErrorHandler() {
        return this.deocdingErrorHandler;
    }

    public boolean isSuppressDecodingErrors() {
        return this.suppressDecodingErrors;
    }

    public static class Builder<T> {
        private String host;
        private int port;
        private String name;
        private Decoder<T> decoder;
        private Map<String, String> subscribeParameters;
        private int subscribeRetryAttempts = 3;
        private Action2<SubscribeInfo, Throwable> subscribeErrorHandler = new Action2<SubscribeInfo, Throwable>(){

            public void call(SubscribeInfo t1, Throwable t2) {
                t2.printStackTrace();
            }
        };
        private boolean suppressSubscribeErrors = false;
        private Action2<T, Throwable> deocdingErrorHandler = new Action2<T, Throwable>(){

            public void call(T t1, Throwable t2) {
                t2.printStackTrace();
            }
        };
        private boolean suppressDecodingErrors = false;

        public Builder<T> host(String host) {
            this.host = host;
            return this;
        }

        public Builder<T> port(int port) {
            this.port = port;
            return this;
        }

        public Builder<T> subscribeErrorHandler(Action2<SubscribeInfo, Throwable> handler, boolean suppressSubscribeErrors) {
            this.subscribeErrorHandler = handler;
            this.suppressSubscribeErrors = suppressSubscribeErrors;
            return this;
        }

        public Builder<T> deocdingErrorHandler(Action2<T, Throwable> handler, boolean suppressDecodingErrors) {
            this.deocdingErrorHandler = handler;
            this.suppressDecodingErrors = suppressDecodingErrors;
            return this;
        }

        public Builder<T> name(String name) {
            this.name = name;
            return this;
        }

        public Builder<T> decoder(Decoder<T> decoder) {
            this.decoder = decoder;
            return this;
        }

        public Builder<T> subscribeParameters(Map<String, String> subscribeParameters) {
            this.subscribeParameters = subscribeParameters;
            return this;
        }

        public Builder<T> subscribeRetryAttempts(int subscribeRetryAttempts) {
            this.subscribeRetryAttempts = subscribeRetryAttempts;
            return this;
        }

        public ConnectConfiguration<T> build() {
            return new ConnectConfiguration(this);
        }
    }
}

