/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.netty;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.LengthFieldBasedFrameDecoder;
import io.netty.handler.codec.LengthFieldPrepender;
import io.reactivex.netty.RemoteObservableConfiguration;
import io.reactivex.netty.RemoteObservableConnectionHandler;
import io.reactivex.netty.RemoteRxEvent;
import io.reactivex.netty.RxEventPipelineConfigurator;
import io.reactivex.netty.RxNetty;
import io.reactivex.netty.ServerMetrics;
import io.reactivex.netty.channel.ConnectionHandler;
import io.reactivex.netty.ingress.IngressPolicies;
import io.reactivex.netty.ingress.IngressPolicy;
import io.reactivex.netty.pipeline.PipelineConfigurator;
import io.reactivex.netty.pipeline.PipelineConfiguratorComposite;
import io.reactivex.netty.server.RxServer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteRxServer {
    private static final Logger logger = LoggerFactory.getLogger(RemoteRxServer.class);
    private RxServer<RemoteRxEvent, RemoteRxEvent> server;
    private CountDownLatch blockUntilCompleted;
    private ServerMetrics metrics;
    private int port;

    RemoteRxServer(RxServer<RemoteRxEvent, RemoteRxEvent> server, ServerMetrics metrics) {
        this.server = server;
        this.metrics = metrics;
    }

    RemoteRxServer(RxServer<RemoteRxEvent, RemoteRxEvent> server, CountDownLatch blockUntilCompleted, ServerMetrics metrics) {
        this(server, metrics);
        this.blockUntilCompleted = blockUntilCompleted;
    }

    public ServerMetrics getMetrics() {
        return this.metrics;
    }

    public void start() {
        this.server.start();
    }

    public void startAndWait() {
        this.server.startAndWait();
        logger.info("RemoteRxServer shutdown on port: " + this.port);
    }

    public void shutdown() {
        try {
            this.server.shutdown();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        logger.info("RemoteRxServer shutdown on port: " + this.port);
    }

    public void blockUntilCompleted() {
        try {
            this.blockUntilCompleted.await();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        logger.info("RemoteRxServer shutdown on port: " + this.port);
    }

    public RemoteRxServer(Builder builder) {
        RxServer server;
        this.port = builder.getPort();
        HashMap<String, RemoteObservableConfiguration> configuredObservables = new HashMap<String, RemoteObservableConfiguration>();
        for (RemoteObservableConfiguration config : builder.getObservablesConfigured()) {
            String observableName = config.getName();
            logger.debug("RemoteRxServer configured with remote observable: " + observableName);
            configuredObservables.put(observableName, config);
        }
        this.metrics = new ServerMetrics();
        this.blockUntilCompleted = new CountDownLatch(1);
        this.server = server = RxNetty.createTcpServer((int)this.port, (PipelineConfigurator)new PipelineConfiguratorComposite(new PipelineConfigurator[]{new PipelineConfigurator<RemoteRxEvent, RemoteRxEvent>(){

            public void configureNewPipeline(ChannelPipeline pipeline) {
                pipeline.addLast("frameEncoder", (ChannelHandler)new LengthFieldPrepender(4));
                pipeline.addLast("frameDecoder", (ChannelHandler)new LengthFieldBasedFrameDecoder(524288, 0, 4, 0, 4));
            }
        }, new RxEventPipelineConfigurator()}), (ConnectionHandler)new RemoteObservableConnectionHandler(configuredObservables, builder.getIngressPolicy(), this.blockUntilCompleted, this.metrics));
        logger.info("RemoteRxServer started on port: " + this.port);
    }

    public static class Builder {
        private int port;
        private Set<RemoteObservableConfiguration> observablesConfigured = new HashSet<RemoteObservableConfiguration>();
        private IngressPolicy ingressPolicy = IngressPolicies.allowAll();

        public Builder port(int port) {
            this.port = port;
            return this;
        }

        public Builder ingressPolicy(IngressPolicy ingressPolicy) {
            this.ingressPolicy = ingressPolicy;
            return this;
        }

        public <T> Builder addObservable(RemoteObservableConfiguration<T> configuration) {
            this.observablesConfigured.add(configuration);
            return this;
        }

        public RemoteRxServer build() {
            return new RemoteRxServer(this);
        }

        int getPort() {
            return this.port;
        }

        Set<RemoteObservableConfiguration> getObservablesConfigured() {
            return this.observablesConfigured;
        }

        IngressPolicy getIngressPolicy() {
            return this.ingressPolicy;
        }
    }
}

