/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.netty.slotting;

import io.reactivex.netty.RemoteRxEvent;
import io.reactivex.netty.channel.ObservableConnection;
import io.reactivex.netty.slotting.SlotAssignment;
import io.reactivex.netty.slotting.SlotValuePair;
import io.reactivex.netty.slotting.SlottingStrategy;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import rx.functions.Func1;

public class HashCodeSlotting<T>
implements SlottingStrategy<T> {
    private int numSlots;
    private List<Integer> slotTokens = new LinkedList<Integer>();
    private Map<ObservableConnection<RemoteRxEvent, RemoteRxEvent>, Integer> slotAssignments = new HashMap<ObservableConnection<RemoteRxEvent, RemoteRxEvent>, Integer>();

    HashCodeSlotting(int numSlots) {
        this.numSlots = numSlots;
        for (int i = 0; i < numSlots; ++i) {
            this.slotTokens.add(i);
        }
    }

    @Override
    public synchronized SlotAssignment assignSlot(ObservableConnection<RemoteRxEvent, RemoteRxEvent> connection) {
        SlotAssignment assignment = SlotAssignment.notAssigned();
        if (this.slotTokens.size() > 0) {
            Integer slot = this.slotTokens.remove(0);
            this.slotAssignments.put(connection, slot);
            assignment = new SlotAssignment(this.slotAssignments.get(connection), this.numSlots);
        }
        return assignment;
    }

    @Override
    public synchronized void releaseSlot(ObservableConnection<RemoteRxEvent, RemoteRxEvent> connection) {
        Integer freeSlot = this.slotAssignments.get(connection);
        if (freeSlot != null) {
            this.slotTokens.add(freeSlot);
            this.slotAssignments.remove(connection);
        }
    }

    @Override
    public Func1<SlotValuePair<T>, Boolean> slottingFunction() {
        return new Func1<SlotValuePair<T>, Boolean>(){

            public Boolean call(SlotValuePair<T> pair) {
                Object value = pair.getValue();
                int slot = pair.getSlot();
                return (value.hashCode() & Integer.MAX_VALUE) % HashCodeSlotting.this.numSlots == slot;
            }
        };
    }
}

