/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.netty;

import io.reactivex.netty.codec.Decoder;
import java.util.Map;

public class ConnectParams<T> {
    private String host;
    private int port;
    private String name;
    private Decoder<T> decoder;
    private Map<String, String> subscribeParameters;

    ConnectParams(Builder<T> builder) {
        this.host = ((Builder)builder).host;
        this.name = ((Builder)builder).name;
        this.port = ((Builder)builder).port;
        this.decoder = ((Builder)builder).decoder;
        this.subscribeParameters = ((Builder)builder).subscribeParameters;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getName() {
        return this.name;
    }

    public Decoder<T> getDecoder() {
        return this.decoder;
    }

    public Map<String, String> getSubscribeParameters() {
        return this.subscribeParameters;
    }

    public static class Builder<T> {
        private String host;
        private int port;
        private String name;
        private Decoder<T> decoder;
        private Map<String, String> subscribeParameters;

        public Builder<T> host(String host) {
            this.host = host;
            return this;
        }

        public Builder<T> port(int port) {
            this.port = port;
            return this;
        }

        public Builder<T> name(String name) {
            this.name = name;
            return this;
        }

        public Builder<T> decoder(Decoder<T> decoder) {
            this.decoder = decoder;
            return this;
        }

        public Builder<T> subscribeParameters(Map<String, String> subscribeParameters) {
            this.subscribeParameters = subscribeParameters;
            return this;
        }

        public ConnectParams<T> build() {
            return new ConnectParams(this);
        }
    }
}

