/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.netty;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelPromise;
import io.reactivex.netty.RemoteRxEvent;
import io.reactivex.netty.pipeline.PipelineConfigurator;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RxEventPipelineConfigurator
implements PipelineConfigurator<RemoteRxEvent, RemoteRxEvent> {
    private static final Logger logger = LoggerFactory.getLogger(RxEventPipelineConfigurator.class);
    private static final byte PROTOCOL_VERSION = 1;

    public void configureNewPipeline(ChannelPipeline pipeline) {
        pipeline.addLast(new ChannelHandler[]{new ChannelDuplexHandler(){

            public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
                ByteBuf byteBuf;
                boolean handled = false;
                if (ByteBuf.class.isAssignableFrom(msg.getClass()) && (byteBuf = (ByteBuf)msg).isReadable()) {
                    byte protocolVersion = byteBuf.readByte();
                    if (protocolVersion != 1) {
                        throw new RuntimeException("Unsupported protocol version: " + protocolVersion);
                    }
                    byte observableNameLength = byteBuf.readByte();
                    String observableName = null;
                    if (observableNameLength > 0) {
                        observableName = new String(byteBuf.readBytes((int)observableNameLength).array());
                    }
                    byte operation = byteBuf.readByte();
                    RemoteRxEvent.Type type = null;
                    Map<String, String> subscribeParams = null;
                    byte[] valueData = null;
                    if (operation == 1) {
                        logger.debug("READ request for RemoteRxEvent: next");
                        type = RemoteRxEvent.Type.next;
                        valueData = new byte[byteBuf.readableBytes()];
                        byteBuf.readBytes(valueData);
                    } else if (operation == 2) {
                        logger.debug("READ request for RemoteRxEvent: error");
                        type = RemoteRxEvent.Type.error;
                        valueData = new byte[byteBuf.readableBytes()];
                        byteBuf.readBytes(valueData);
                    } else if (operation == 3) {
                        logger.debug("READ request for RemoteRxEvent: completed");
                        type = RemoteRxEvent.Type.completed;
                    } else if (operation == 4) {
                        logger.debug("READ request for RemoteRxEvent: subscribed");
                        type = RemoteRxEvent.Type.subscribed;
                        int subscribeParamsLength = byteBuf.readInt();
                        if (subscribeParamsLength > 0) {
                            byte[] subscribeParamsBytes = new byte[subscribeParamsLength];
                            byteBuf.readBytes(subscribeParamsBytes);
                            subscribeParams = RxEventPipelineConfigurator.fromBytesToMap(subscribeParamsBytes);
                        }
                    } else if (operation == 5) {
                        logger.debug("READ request for RemoteRxEvent: unsubscribed");
                        type = RemoteRxEvent.Type.unsubscribed;
                    } else {
                        throw new RuntimeException("operation: " + operation + " not support.");
                    }
                    handled = true;
                    byteBuf.release();
                    ctx.fireChannelRead((Object)new RemoteRxEvent(observableName, type, valueData, subscribeParams));
                }
                if (!handled) {
                    super.channelRead(ctx, msg);
                }
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
                if (msg instanceof RemoteRxEvent) {
                    ByteBuf buf = ctx.alloc().buffer();
                    buf.writeByte(1);
                    RemoteRxEvent event = (RemoteRxEvent)msg;
                    String observableName = event.getName();
                    if (observableName != null && !observableName.isEmpty()) {
                        int nameLength = observableName.length();
                        if (nameLength >= 127) throw new RuntimeException("observableName " + observableName + " exceeds max limit of 127 characters");
                        buf.writeByte(nameLength);
                        buf.writeBytes(observableName.getBytes());
                    } else {
                        buf.writeByte(0);
                    }
                    if (event.getType() == RemoteRxEvent.Type.next) {
                        logger.debug("WRITE request for RemoteRxEvent: next");
                        buf.writeByte(1);
                        buf.writeBytes(event.getData());
                        super.write(ctx, (Object)buf, promise);
                        return;
                    } else if (event.getType() == RemoteRxEvent.Type.error) {
                        logger.debug("WRITE request for RemoteRxEvent: error");
                        buf.writeByte(2);
                        buf.writeBytes(event.getData());
                        super.write(ctx, (Object)buf, promise);
                        return;
                    } else if (event.getType() == RemoteRxEvent.Type.completed) {
                        logger.debug("WRITE request for RemoteRxEvent: completed");
                        buf.writeByte(3);
                        super.write(ctx, (Object)buf, promise);
                        super.flush(ctx);
                        return;
                    } else if (event.getType() == RemoteRxEvent.Type.subscribed) {
                        logger.debug("WRITE request for RemoteRxEvent: subscribed");
                        buf.writeByte(4);
                        Map<String, String> subscribeParameters = event.getSubscribeParameters();
                        if (subscribeParameters != null && !subscribeParameters.isEmpty()) {
                            byte[] subscribeBytes = RxEventPipelineConfigurator.fromMapToBytes(subscribeParameters);
                            buf.writeInt(subscribeBytes.length);
                            buf.writeBytes(subscribeBytes);
                        } else {
                            buf.writeInt(0);
                        }
                        super.write(ctx, (Object)buf, promise);
                        super.flush(ctx);
                        return;
                    } else {
                        if (event.getType() != RemoteRxEvent.Type.unsubscribed) return;
                        logger.debug("WRITE request for RemoteRxEvent: unsubscribed");
                        buf.writeByte(5);
                        super.write(ctx, (Object)buf, promise);
                        super.flush(ctx);
                    }
                    return;
                } else {
                    super.write(ctx, msg, promise);
                }
            }
        }});
    }

    static Map<String, String> fromBytesToMap(byte[] bytes) {
        Map map = null;
        ByteArrayInputStream bis = null;
        ObjectInput in = null;
        try {
            bis = new ByteArrayInputStream(bytes);
            in = new ObjectInputStream(bis);
            map = (Map)in.readObject();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (ClassNotFoundException e1) {
            throw new RuntimeException(e1);
        }
        finally {
            try {
                if (bis != null) {
                    bis.close();
                }
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return map;
    }

    static byte[] fromMapToBytes(Map<String, String> map) {
        ByteArrayOutputStream baos = null;
        ObjectOutput out = null;
        try {
            baos = new ByteArrayOutputStream();
            out = new ObjectOutputStream(baos);
            out.writeObject(map);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
                if (baos != null) {
                    baos.close();
                }
            }
            catch (IOException e1) {
                e1.printStackTrace();
                throw new RuntimeException(e1);
            }
        }
        return baos.toByteArray();
    }
}

