/*
 * Decompiled with CFR 0.152.
 */
package io.realm.kotlin.internal;

import io.realm.kotlin.VersionId;
import io.realm.kotlin.internal.BaseRealmImpl;
import io.realm.kotlin.internal.FrozenRealmReference;
import io.realm.kotlin.internal.FrozenRealmReferenceImpl;
import io.realm.kotlin.internal.RealmReference;
import io.realm.kotlin.internal.interop.FrozenRealmT;
import io.realm.kotlin.internal.interop.LiveRealmT;
import io.realm.kotlin.internal.interop.NativePointer;
import io.realm.kotlin.internal.interop.RealmInterop;
import io.realm.kotlin.internal.schema.CachedSchemaMetadata;
import io.realm.kotlin.internal.schema.SchemaMetadata;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.atomicfu.AtomicFU;
import kotlinx.atomicfu.AtomicRef;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0010\u0010\u0004\u001a\f\u0012\u0004\u0012\u00020\u00060\u0005j\u0002`\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\u0014\u001a\f\u0012\u0004\u0012\u00020\u00060\u0005j\u0002`\u0007H\u00c6\u0003J'\u0010\u0015\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u0012\b\u0002\u0010\u0004\u001a\f\u0012\u0004\u0012\u00020\u00060\u0005j\u0002`\u0007H\u00c6\u0001J\u0013\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u00d6\u0003J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001J\u0006\u0010\u001c\u001a\u00020\u001dJ\u000e\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0002\u001a\u00020\u0003J\t\u0010 \u001a\u00020!H\u00d6\u0001R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0004\u001a\f\u0012\u0004\u0012\u00020\u00060\u0005j\u0002`\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\""}, d2={"Lio/realm/kotlin/internal/LiveRealmReference;", "Lio/realm/kotlin/internal/RealmReference;", "owner", "Lio/realm/kotlin/internal/BaseRealmImpl;", "dbPointer", "Lio/realm/kotlin/internal/interop/NativePointer;", "Lio/realm/kotlin/internal/interop/LiveRealmT;", "Lio/realm/kotlin/internal/interop/LiveRealmPointer;", "(Lio/realm/kotlin/internal/BaseRealmImpl;Lio/realm/kotlin/internal/interop/NativePointer;)V", "_schemaMetadata", "Lkotlinx/atomicfu/AtomicRef;", "Lio/realm/kotlin/internal/schema/SchemaMetadata;", "getDbPointer", "()Lio/realm/kotlin/internal/interop/NativePointer;", "getOwner", "()Lio/realm/kotlin/internal/BaseRealmImpl;", "schemaMetadata", "getSchemaMetadata", "()Lio/realm/kotlin/internal/schema/SchemaMetadata;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "refreshSchemaMetadata", "", "snapshot", "Lio/realm/kotlin/internal/FrozenRealmReference;", "toString", "", "io.realm.kotlin.library"})
public final class LiveRealmReference
implements RealmReference {
    @NotNull
    private final BaseRealmImpl owner;
    @NotNull
    private final NativePointer<LiveRealmT> dbPointer;
    @NotNull
    private final AtomicRef<SchemaMetadata> _schemaMetadata;

    public LiveRealmReference(@NotNull BaseRealmImpl owner, @NotNull NativePointer<LiveRealmT> dbPointer) {
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        Intrinsics.checkNotNullParameter(dbPointer, (String)"dbPointer");
        this.owner = owner;
        this.dbPointer = dbPointer;
        this._schemaMetadata = AtomicFU.atomic((Object)new CachedSchemaMetadata(this.getDbPointer(), this.getOwner().getConfiguration().getMapOfKClassWithCompanion().values()));
    }

    @Override
    @NotNull
    public BaseRealmImpl getOwner() {
        return this.owner;
    }

    @NotNull
    public NativePointer<LiveRealmT> getDbPointer() {
        return this.dbPointer;
    }

    @Override
    @NotNull
    public SchemaMetadata getSchemaMetadata() {
        return (SchemaMetadata)this._schemaMetadata.getValue();
    }

    @NotNull
    public final FrozenRealmReference snapshot(@NotNull BaseRealmImpl owner) {
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        return new FrozenRealmReferenceImpl(owner, (NativePointer<FrozenRealmT>)RealmInterop.INSTANCE.realm_freeze(this.getDbPointer()), this.getSchemaMetadata());
    }

    public final void refreshSchemaMetadata() {
        this._schemaMetadata.setValue((Object)new CachedSchemaMetadata(this.getDbPointer(), this.getOwner().getConfiguration().getMapOfKClassWithCompanion().values()));
    }

    @Override
    @NotNull
    public VersionId version() {
        return RealmReference.DefaultImpls.version(this);
    }

    @Override
    @NotNull
    public VersionId uncheckedVersion() {
        return RealmReference.DefaultImpls.uncheckedVersion(this);
    }

    @Override
    public boolean isFrozen() {
        return RealmReference.DefaultImpls.isFrozen(this);
    }

    @Override
    public boolean isClosed() {
        return RealmReference.DefaultImpls.isClosed(this);
    }

    @Override
    public void close() {
        RealmReference.DefaultImpls.close(this);
    }

    @Override
    @NotNull
    public LiveRealmReference asValidLiveRealmReference() {
        return RealmReference.DefaultImpls.asValidLiveRealmReference(this);
    }

    @Override
    public void checkClosed() {
        RealmReference.DefaultImpls.checkClosed(this);
    }

    @NotNull
    public final BaseRealmImpl component1() {
        return this.owner;
    }

    @NotNull
    public final NativePointer<LiveRealmT> component2() {
        return this.dbPointer;
    }

    @NotNull
    public final LiveRealmReference copy(@NotNull BaseRealmImpl owner, @NotNull NativePointer<LiveRealmT> dbPointer) {
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        Intrinsics.checkNotNullParameter(dbPointer, (String)"dbPointer");
        return new LiveRealmReference(owner, dbPointer);
    }

    public static /* synthetic */ LiveRealmReference copy$default(LiveRealmReference liveRealmReference, BaseRealmImpl baseRealmImpl, NativePointer nativePointer, int n, Object object) {
        if ((n & 1) != 0) {
            baseRealmImpl = liveRealmReference.owner;
        }
        if ((n & 2) != 0) {
            nativePointer = liveRealmReference.dbPointer;
        }
        return liveRealmReference.copy(baseRealmImpl, nativePointer);
    }

    @NotNull
    public String toString() {
        return "LiveRealmReference(owner=" + this.owner + ", dbPointer=" + this.dbPointer + ')';
    }

    public int hashCode() {
        int result = this.owner.hashCode();
        result = result * 31 + this.dbPointer.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof LiveRealmReference)) {
            return false;
        }
        LiveRealmReference liveRealmReference = (LiveRealmReference)other;
        if (!Intrinsics.areEqual((Object)this.owner, (Object)liveRealmReference.owner)) {
            return false;
        }
        return Intrinsics.areEqual(this.dbPointer, liveRealmReference.dbPointer);
    }
}

