/*
 * Decompiled with CFR 0.152.
 */
package io.realm.kotlin.internal;

import io.realm.kotlin.internal.ObjectIdImpl;
import io.realm.kotlin.internal.ObjectIdImplKt;
import io.realm.kotlin.internal.platform.SystemUtilsKt;
import io.realm.kotlin.internal.util.HexadecimalKt;
import io.realm.kotlin.types.ObjectId;
import io.realm.kotlin.types.RealmInstant;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mongodb.kbson.BsonObjectId;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0002\b\u0004\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u0011\b\u0016\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u000f\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007B\u000f\b\u0016\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nB\u000f\b\u0016\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rB\u0013\b\u0012\u0012\n\u0010\u000e\u001a\u00060\u000fj\u0002`\u0010\u00a2\u0006\u0002\u0010\u0011J\u0011\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u0001H\u0096\u0002J\u0013\u0010\u0016\u001a\u00020\u00172\b\u0010\u0015\u001a\u0004\u0018\u00010\u0018H\u0096\u0002J\b\u0010\u0019\u001a\u00020\u0006H\u0016J\b\u0010\u001a\u001a\u00020\tH\u0016R\u0011\u0010\u000b\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0012\u0010\u000e\u001a\u00060\u000fj\u0002`\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lio/realm/kotlin/internal/ObjectIdImpl;", "Lio/realm/kotlin/types/ObjectId;", "timestamp", "Lio/realm/kotlin/types/RealmInstant;", "(Lio/realm/kotlin/types/RealmInstant;)V", "epochSeconds", "", "(I)V", "hexString", "", "(Ljava/lang/String;)V", "bytes", "", "([B)V", "inner", "Lorg/mongodb/kbson/BsonObjectId;", "Lorg/mongodb/kbson/ObjectId;", "(Lorg/mongodb/kbson/BsonObjectId;)V", "getBytes", "()[B", "compareTo", "other", "equals", "", "", "hashCode", "toString", "Companion", "io.realm.kotlin.library"})
public final class ObjectIdImpl
implements ObjectId {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final BsonObjectId inner;
    @NotNull
    private static final Lazy<Regex> OBJECT_ID_REGEX$delegate = LazyKt.lazy((Function0)Companion.OBJECT_ID_REGEX.2.INSTANCE);

    @NotNull
    public final byte[] getBytes() {
        return this.inner.toByteArray();
    }

    public ObjectIdImpl(@NotNull RealmInstant timestamp) {
        Intrinsics.checkNotNullParameter((Object)timestamp, (String)"timestamp");
        this(BsonObjectId.Companion.invoke(ObjectIdImplKt.access$toEpochMillis(timestamp)));
    }

    public /* synthetic */ ObjectIdImpl(RealmInstant realmInstant, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            realmInstant = RealmInstant.Companion.from(SystemUtilsKt.epochInSeconds(), 0);
        }
        this(realmInstant);
    }

    public ObjectIdImpl(int epochSeconds) {
        this(BsonObjectId.Companion.invoke(Duration.getInWholeMilliseconds-impl((long)DurationKt.toDuration((int)epochSeconds, (DurationUnit)DurationUnit.SECONDS))));
    }

    public ObjectIdImpl(@NotNull String hexString) {
        Intrinsics.checkNotNullParameter((Object)hexString, (String)"hexString");
        this(ObjectIdImpl.Companion.parseObjectIdString(hexString));
    }

    public ObjectIdImpl(@NotNull byte[] bytes) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        if (bytes.length != 12) {
            throw new IllegalArgumentException("byte array size must be 12");
        }
        this.inner = BsonObjectId.Companion.invoke(bytes);
    }

    private ObjectIdImpl(BsonObjectId inner) {
        this.inner = inner;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        ObjectIdImpl cfr_ignored_0 = (ObjectIdImpl)other;
        return Intrinsics.areEqual((Object)this.inner, (Object)((ObjectIdImpl)other).inner);
    }

    public int hashCode() {
        return this.inner.hashCode();
    }

    @Override
    public int compareTo(@NotNull ObjectId other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        for (int i = 0; i < 12; ++i) {
            if (this.getBytes()[i] == ((ObjectIdImpl)other).getBytes()[i]) continue;
            return this.getBytes()[i] < ((ObjectIdImpl)other).getBytes()[i] ? -1 : 1;
        }
        return 0;
    }

    @NotNull
    public String toString() {
        return this.inner.toHexString();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002R\u001b\u0010\u0003\u001a\u00020\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\r"}, d2={"Lio/realm/kotlin/internal/ObjectIdImpl$Companion;", "", "()V", "OBJECT_ID_REGEX", "Lkotlin/text/Regex;", "getOBJECT_ID_REGEX", "()Lkotlin/text/Regex;", "OBJECT_ID_REGEX$delegate", "Lkotlin/Lazy;", "parseObjectIdString", "", "hexString", "", "io.realm.kotlin.library"})
    private static final class Companion {
        private Companion() {
        }

        private final Regex getOBJECT_ID_REGEX() {
            Lazy lazy = OBJECT_ID_REGEX$delegate;
            return (Regex)lazy.getValue();
        }

        private final byte[] parseObjectIdString(String hexString) {
            if (!this.getOBJECT_ID_REGEX().matches((CharSequence)hexString)) {
                throw new IllegalArgumentException("invalid hexadecimal representation of an ObjectId: [" + hexString + ']');
            }
            return HexadecimalKt.parseHex(hexString);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

