/*
 * Decompiled with CFR 0.152.
 */
package io.realm.kotlin.compiler;

import io.realm.kotlin.compiler.CollectionType;
import io.realm.kotlin.compiler.CoreType;
import io.realm.kotlin.compiler.FqNames;
import io.realm.kotlin.compiler.IrUtilsKt;
import io.realm.kotlin.compiler.LoggerKt;
import io.realm.kotlin.compiler.PropertyType;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.ir.declarations.IrAnnotationContainer;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.impl.IrConstImpl;
import org.jetbrains.kotlin.ir.interpreter.UtilsKt;
import org.jetbrains.kotlin.name.FqName;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u000e\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u0000 )2\u00020\u0001:\u0001)B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\u0010\b\u0002\u0010\b\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\t\u00a2\u0006\u0002\u0010\u000bJ\t\u0010\u001f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010 \u001a\u00020\u0005H\u00c6\u0003J\t\u0010!\u001a\u00020\u0007H\u00c6\u0003J\u0011\u0010\"\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\tH\u00c6\u0003J9\u0010#\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\u0010\b\u0002\u0010\b\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\tH\u00c6\u0001J\u0013\u0010$\u001a\u00020\u00132\b\u0010%\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010&\u001a\u00020'H\u00d6\u0001J\t\u0010(\u001a\u00020\u0018H\u00d6\u0001R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0019\u0010\b\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0016\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0015R\u0011\u0010\u0017\u001a\u00020\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\u001d\u001a\u00020\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001a\u00a8\u0006*"}, d2={"Lio/realm/kotlin/compiler/SchemaProperty;", "", "propertyType", "Lio/realm/kotlin/compiler/PropertyType;", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrProperty;", "collectionType", "Lio/realm/kotlin/compiler/CollectionType;", "coreGenericTypes", "", "Lio/realm/kotlin/compiler/CoreType;", "(Lio/realm/kotlin/compiler/PropertyType;Lorg/jetbrains/kotlin/ir/declarations/IrProperty;Lio/realm/kotlin/compiler/CollectionType;Ljava/util/List;)V", "getCollectionType", "()Lio/realm/kotlin/compiler/CollectionType;", "getCoreGenericTypes", "()Ljava/util/List;", "getDeclaration", "()Lorg/jetbrains/kotlin/ir/declarations/IrProperty;", "hasPersistedNameAnnotation", "", "getHasPersistedNameAnnotation", "()Z", "isComputed", "persistedName", "", "getPersistedName", "()Ljava/lang/String;", "getPropertyType", "()Lio/realm/kotlin/compiler/PropertyType;", "publicName", "getPublicName", "component1", "component2", "component3", "component4", "copy", "equals", "other", "hashCode", "", "toString", "Companion", "plugin-compiler"})
public final class SchemaProperty {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PropertyType propertyType;
    @NotNull
    private final IrProperty declaration;
    @NotNull
    private final CollectionType collectionType;
    @Nullable
    private final List<CoreType> coreGenericTypes;
    private final boolean isComputed;
    private final boolean hasPersistedNameAnnotation;
    @NotNull
    private final String persistedName;
    @NotNull
    private final String publicName;

    /*
     * Enabled aggressive block sorting
     */
    public SchemaProperty(@NotNull PropertyType propertyType, @NotNull IrProperty declaration, @NotNull CollectionType collectionType, @Nullable List<CoreType> coreGenericTypes) {
        String persistedAnnotationName;
        Intrinsics.checkNotNullParameter((Object)propertyType, "propertyType");
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        Intrinsics.checkNotNullParameter((Object)collectionType, "collectionType");
        this.propertyType = propertyType;
        this.declaration = declaration;
        this.collectionType = collectionType;
        this.coreGenericTypes = coreGenericTypes;
        this.isComputed = this.propertyType == PropertyType.RLM_PROPERTY_TYPE_LINKING_OBJECTS;
        this.hasPersistedNameAnnotation = this.declaration.getBackingField() != null && org.jetbrains.kotlin.ir.util.IrUtilsKt.hasAnnotation((IrAnnotationContainer)((IrAnnotationContainer)this.declaration), (FqName)FqNames.INSTANCE.getPERSISTED_NAME_ANNOTATION());
        String string = this.declaration.getName().getIdentifier();
        Intrinsics.checkNotNullExpressionValue(string, "declaration.name.identifier");
        String declarationName = string;
        String string2 = persistedAnnotationName = this.hasPersistedNameAnnotation ? Companion.getPersistedName(this.declaration) : null;
        if (this.hasPersistedNameAnnotation) {
            String string3 = persistedAnnotationName;
            Intrinsics.checkNotNull(string3);
            if (!Intrinsics.areEqual(string3, declarationName)) {
                CharSequence charSequence = persistedAnnotationName;
                if (charSequence.length() == 0) {
                    boolean bl = false;
                    LoggerKt.logError("Names must contain at least 1 character.", IrUtilsKt.locationOf((IrDeclaration)this.declaration));
                }
                this.persistedName = persistedAnnotationName;
                this.publicName = declarationName;
                return;
            }
        }
        this.persistedName = declarationName;
        this.publicName = "";
    }

    public /* synthetic */ SchemaProperty(PropertyType propertyType, IrProperty irProperty, CollectionType collectionType, List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            collectionType = CollectionType.NONE;
        }
        if ((n & 8) != 0) {
            list = null;
        }
        this(propertyType, irProperty, collectionType, list);
    }

    @NotNull
    public final PropertyType getPropertyType() {
        return this.propertyType;
    }

    @NotNull
    public final IrProperty getDeclaration() {
        return this.declaration;
    }

    @NotNull
    public final CollectionType getCollectionType() {
        return this.collectionType;
    }

    @Nullable
    public final List<CoreType> getCoreGenericTypes() {
        return this.coreGenericTypes;
    }

    public final boolean isComputed() {
        return this.isComputed;
    }

    public final boolean getHasPersistedNameAnnotation() {
        return this.hasPersistedNameAnnotation;
    }

    @NotNull
    public final String getPersistedName() {
        return this.persistedName;
    }

    @NotNull
    public final String getPublicName() {
        return this.publicName;
    }

    @NotNull
    public final PropertyType component1() {
        return this.propertyType;
    }

    @NotNull
    public final IrProperty component2() {
        return this.declaration;
    }

    @NotNull
    public final CollectionType component3() {
        return this.collectionType;
    }

    @Nullable
    public final List<CoreType> component4() {
        return this.coreGenericTypes;
    }

    @NotNull
    public final SchemaProperty copy(@NotNull PropertyType propertyType, @NotNull IrProperty declaration, @NotNull CollectionType collectionType, @Nullable List<CoreType> coreGenericTypes) {
        Intrinsics.checkNotNullParameter((Object)propertyType, "propertyType");
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        Intrinsics.checkNotNullParameter((Object)collectionType, "collectionType");
        return new SchemaProperty(propertyType, declaration, collectionType, coreGenericTypes);
    }

    public static /* synthetic */ SchemaProperty copy$default(SchemaProperty schemaProperty, PropertyType propertyType, IrProperty irProperty, CollectionType collectionType, List list, int n, Object object) {
        if ((n & 1) != 0) {
            propertyType = schemaProperty.propertyType;
        }
        if ((n & 2) != 0) {
            irProperty = schemaProperty.declaration;
        }
        if ((n & 4) != 0) {
            collectionType = schemaProperty.collectionType;
        }
        if ((n & 8) != 0) {
            list = schemaProperty.coreGenericTypes;
        }
        return schemaProperty.copy(propertyType, irProperty, collectionType, list);
    }

    @NotNull
    public String toString() {
        return "SchemaProperty(propertyType=" + (Object)((Object)this.propertyType) + ", declaration=" + this.declaration + ", collectionType=" + (Object)((Object)this.collectionType) + ", coreGenericTypes=" + this.coreGenericTypes + ')';
    }

    public int hashCode() {
        int result2 = this.propertyType.hashCode();
        result2 = result2 * 31 + this.declaration.hashCode();
        result2 = result2 * 31 + this.collectionType.hashCode();
        result2 = result2 * 31 + (this.coreGenericTypes == null ? 0 : ((Object)this.coreGenericTypes).hashCode());
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SchemaProperty)) {
            return false;
        }
        SchemaProperty schemaProperty = (SchemaProperty)other;
        if (this.propertyType != schemaProperty.propertyType) {
            return false;
        }
        if (!Intrinsics.areEqual(this.declaration, schemaProperty.declaration)) {
            return false;
        }
        if (this.collectionType != schemaProperty.collectionType) {
            return false;
        }
        return Intrinsics.areEqual(this.coreGenericTypes, schemaProperty.coreGenericTypes);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lio/realm/kotlin/compiler/SchemaProperty$Companion;", "", "()V", "getPersistedName", "", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrProperty;", "plugin-compiler"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getPersistedName(@NotNull IrProperty declaration) {
            Intrinsics.checkNotNullParameter(declaration, "declaration");
            IrExpression irExpression = UtilsKt.getAnnotation((IrAnnotationContainer)((IrAnnotationContainer)declaration), (FqName)FqNames.INSTANCE.getPERSISTED_NAME_ANNOTATION()).getValueArgument(0);
            Intrinsics.checkNotNull(irExpression);
            return (String)((IrConstImpl)irExpression).getValue();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

