/*
 * Decompiled with CFR 0.152.
 */
package org.mongodb.kbson;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.CollectionToArray;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.markers.KMutableList;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.Serializable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mongodb.kbson.BsonType;
import org.mongodb.kbson.BsonValue;
import org.mongodb.kbson.serialization.BsonArraySerializer;

@Serializable(with=BsonArraySerializer.class)
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0006\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0010)\n\u0002\b\u0002\n\u0002\u0010+\n\u0002\b\t\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0007\u0018\u0000 62\u00020\u00012\b\u0012\u0004\u0012\u00020\u00010\u0002:\u00016B\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005B\u0015\u0012\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u0001H\u0016J\u0010\u0010\u0014\u001a\u00020\u00182\u0006\u0010\u0017\u001a\u00020\u0001H\u0016J\u001e\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u0016\u001a\u00020\u00042\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00010\u001bH\u0016J\u0016\u0010\u0019\u001a\u00020\u00182\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00010\u001bH\u0016J\b\u0010\u001c\u001a\u00020\u0015H\u0016J\u0006\u0010\u001d\u001a\u00020\u0000J\u0011\u0010\u001e\u001a\u00020\u00182\u0006\u0010\u0017\u001a\u00020\u0001H\u0096\u0002J\u0016\u0010\u001f\u001a\u00020\u00182\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00010\u001bH\u0016J\u0013\u0010 \u001a\u00020\u00182\b\u0010!\u001a\u0004\u0018\u00010\"H\u0096\u0002J\u0011\u0010#\u001a\u00020\u00012\u0006\u0010\u0016\u001a\u00020\u0004H\u0096\u0002J\b\u0010$\u001a\u00020\u0004H\u0016J\u0010\u0010%\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u0001H\u0016J\b\u0010&\u001a\u00020\u0018H\u0016J\u000f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00010(H\u0096\u0002J\u0010\u0010)\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u0001H\u0016J\u000e\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00010+H\u0016J\u0016\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00010+2\u0006\u0010\u0016\u001a\u00020\u0004H\u0016J\u0010\u0010,\u001a\u00020\u00182\u0006\u0010\u0017\u001a\u00020\u0001H\u0016J\u0016\u0010-\u001a\u00020\u00182\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00010\u001bH\u0016J\u0010\u0010.\u001a\u00020\u00012\u0006\u0010\u0016\u001a\u00020\u0004H\u0016J\u0016\u0010/\u001a\u00020\u00182\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00010\u001bH\u0016J\u0019\u00100\u001a\u00020\u00012\u0006\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u0001H\u0096\u0002J\u001e\u00101\u001a\b\u0012\u0004\u0012\u00020\u00010\u00022\u0006\u00102\u001a\u00020\u00042\u0006\u00103\u001a\u00020\u0004H\u0016J\b\u00104\u001a\u000205H\u0016R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00010\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0017\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00010\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\u00a8\u00067"}, d2={"Lorg/mongodb/kbson/BsonArray;", "Lorg/mongodb/kbson/BsonValue;", "", "initialCapacity", "", "(I)V", "initial", "", "(Ljava/util/List;)V", "_values", "bsonType", "Lorg/mongodb/kbson/BsonType;", "getBsonType", "()Lorg/mongodb/kbson/BsonType;", "size", "getSize", "()I", "values", "getValues", "()Ljava/util/List;", "add", "", "index", "element", "", "addAll", "elements", "", "clear", "clone", "contains", "containsAll", "equals", "other", "", "get", "hashCode", "indexOf", "isEmpty", "iterator", "", "lastIndexOf", "listIterator", "", "remove", "removeAll", "removeAt", "retainAll", "set", "subList", "fromIndex", "toIndex", "toString", "", "Companion", "kbson"})
public final class BsonArray
extends BsonValue
implements List<BsonValue>,
KMutableList {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<BsonValue> _values;

    public BsonArray(@NotNull List<? extends BsonValue> initial) {
        Intrinsics.checkNotNullParameter(initial, "initial");
        super(null);
        this._values = CollectionsKt.toMutableList((Collection)initial);
    }

    public /* synthetic */ BsonArray(List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            list = CollectionsKt.emptyList();
        }
        this(list);
    }

    public BsonArray(int initialCapacity) {
        this(new ArrayList(initialCapacity));
    }

    @NotNull
    public final List<BsonValue> getValues() {
        return CollectionsKt.toList((Iterable)this._values);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final BsonArray clone() {
        void $this$fold$iv;
        Iterable iterable = this._values;
        ArrayList<Object> initial$iv = new ArrayList<Object>(this._values.size());
        boolean $i$f$fold = false;
        ArrayList<Object> accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            void value;
            BsonValue bsonValue = (BsonValue)element$iv;
            ArrayList<Object> list = accumulator$iv;
            boolean bl = false;
            if (value.isArray()) {
                list.add(value.asArray().clone());
            } else if (value.isDocument()) {
                list.add(value.asDocument().clone());
            } else {
                list.add(value);
            }
            accumulator$iv = list;
        }
        ArrayList<Object> clonedValues = accumulator$iv;
        return new BsonArray((List<? extends BsonValue>)clonedValues);
    }

    @Override
    @NotNull
    public BsonType getBsonType() {
        return BsonType.ARRAY;
    }

    public boolean contains(@NotNull BsonValue element) {
        Intrinsics.checkNotNullParameter(element, "element");
        return this._values.contains(element);
    }

    @Override
    public boolean containsAll(@NotNull Collection<? extends Object> elements) {
        Intrinsics.checkNotNullParameter(elements, "elements");
        return this._values.containsAll(elements);
    }

    @Override
    @NotNull
    public BsonValue get(int index) {
        return this._values.get(index);
    }

    @Override
    public boolean isEmpty() {
        return this._values.isEmpty();
    }

    @Override
    @NotNull
    public Iterator<BsonValue> iterator() {
        return this._values.iterator();
    }

    @Override
    @NotNull
    public ListIterator<BsonValue> listIterator() {
        return this._values.listIterator();
    }

    @Override
    @NotNull
    public ListIterator<BsonValue> listIterator(int index) {
        return this._values.listIterator(index);
    }

    public boolean remove(@NotNull BsonValue element) {
        Intrinsics.checkNotNullParameter(element, "element");
        return this._values.remove(element);
    }

    @Override
    public boolean removeAll(@NotNull Collection<? extends Object> elements) {
        Intrinsics.checkNotNullParameter(elements, "elements");
        return this._values.removeAll(elements);
    }

    @NotNull
    public BsonValue removeAt(int index) {
        return this._values.remove(index);
    }

    @Override
    public boolean retainAll(@NotNull Collection<? extends Object> elements) {
        Intrinsics.checkNotNullParameter(elements, "elements");
        return this._values.retainAll(elements);
    }

    @Override
    @NotNull
    public BsonValue set(int index, @NotNull BsonValue element) {
        Intrinsics.checkNotNullParameter(element, "element");
        return this._values.set(index, element);
    }

    @Override
    @NotNull
    public List<BsonValue> subList(int fromIndex, int toIndex) {
        return this._values.subList(fromIndex, toIndex);
    }

    public int lastIndexOf(@NotNull BsonValue element) {
        Intrinsics.checkNotNullParameter(element, "element");
        return this._values.lastIndexOf(element);
    }

    public int indexOf(@NotNull BsonValue element) {
        Intrinsics.checkNotNullParameter(element, "element");
        return this._values.indexOf(element);
    }

    @NotNull
    public String toString() {
        return "BsonArray(values=" + CollectionsKt.joinToString$default(this._values, ",", "[", "]", 0, null, null, 56, null) + ')';
    }

    public int getSize() {
        return this._values.size();
    }

    @Override
    public void clear() {
        this._values.clear();
    }

    @Override
    public boolean addAll(@NotNull Collection<? extends BsonValue> elements) {
        Intrinsics.checkNotNullParameter(elements, "elements");
        return this._values.addAll(elements);
    }

    @Override
    public boolean addAll(int index, @NotNull Collection<? extends BsonValue> elements) {
        Intrinsics.checkNotNullParameter(elements, "elements");
        return this._values.addAll(index, elements);
    }

    @Override
    public void add(int index, @NotNull BsonValue element) {
        Intrinsics.checkNotNullParameter(element, "element");
        this._values.add(index, element);
    }

    @Override
    public boolean add(@NotNull BsonValue element) {
        Intrinsics.checkNotNullParameter(element, "element");
        return this._values.add(element);
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || !Intrinsics.areEqual(Reflection.getOrCreateKotlinClass(this.getClass()), Reflection.getOrCreateKotlinClass(other.getClass()))) {
            return false;
        }
        BsonArray cfr_ignored_0 = (BsonArray)other;
        return Intrinsics.areEqual(this._values, ((BsonArray)other)._values);
    }

    @Override
    public int hashCode() {
        return ((Object)this._values).hashCode();
    }

    public BsonArray() {
        this(null, 1, null);
    }

    @Override
    public <T> T[] toArray(T[] array) {
        Intrinsics.checkNotNullParameter(array, "array");
        return CollectionToArray.toArray(this, array);
    }

    @Override
    public Object[] toArray() {
        return CollectionToArray.toArray(this);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u00c6\u0001\u00a8\u0006\u0006"}, d2={"Lorg/mongodb/kbson/BsonArray$Companion;", "", "()V", "serializer", "Lkotlinx/serialization/KSerializer;", "Lorg/mongodb/kbson/BsonArray;", "kbson"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final KSerializer<BsonArray> serializer() {
            return BsonArraySerializer.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

