/*
 * Decompiled with CFR 0.152.
 */
package org.mongodb.kbson;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.markers.KMutableMap;
import kotlin.ranges.RangesKt;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.Serializable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mongodb.kbson.BsonArray;
import org.mongodb.kbson.BsonBinary;
import org.mongodb.kbson.BsonBoolean;
import org.mongodb.kbson.BsonDateTime;
import org.mongodb.kbson.BsonDecimal128;
import org.mongodb.kbson.BsonDouble;
import org.mongodb.kbson.BsonElement;
import org.mongodb.kbson.BsonInt32;
import org.mongodb.kbson.BsonInt64;
import org.mongodb.kbson.BsonInvalidOperationException;
import org.mongodb.kbson.BsonNumber;
import org.mongodb.kbson.BsonObjectId;
import org.mongodb.kbson.BsonRegularExpression;
import org.mongodb.kbson.BsonString;
import org.mongodb.kbson.BsonTimestamp;
import org.mongodb.kbson.BsonType;
import org.mongodb.kbson.BsonValue;
import org.mongodb.kbson.internal.Closeable;
import org.mongodb.kbson.internal.io.BsonBinaryReader;
import org.mongodb.kbson.internal.io.BsonBinaryWriter;
import org.mongodb.kbson.internal.io.BsonDocumentReader;
import org.mongodb.kbson.internal.io.BsonDocumentWriter;
import org.mongodb.kbson.serialization.Bson;
import org.mongodb.kbson.serialization.BsonDocumentSerializer;

@Serializable(with=BsonDocumentSerializer.class)
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u00d4\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0010'\n\u0002\b\b\n\u0002\u0010\u001f\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0016\n\u0002\u0010\u0012\n\u0002\b\u0003\b\u0007\u0018\u0000 j2\u00020\u00012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00010\u0002:\u0001jB\u000f\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u0017\b\u0016\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\tB\u0015\b\u0016\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\u0002\u0010\rB3\b\u0016\u0012*\u0010\u000e\u001a\u0016\u0012\u0012\b\u0001\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00010\u00100\u000f\"\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00010\u0010\u00a2\u0006\u0002\u0010\u0011B\u001b\u0012\u0014\b\u0002\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00010\u0013\u00a2\u0006\u0002\u0010\u0014J\u0016\u0010*\u001a\u00020\u00002\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\u0001J\b\u0010+\u001a\u00020,H\u0016J\u0006\u0010-\u001a\u00020\u0000J\u0010\u0010.\u001a\u00020/2\u0006\u0010\u0007\u001a\u00020\u0003H\u0016J\u0010\u00100\u001a\u00020/2\u0006\u0010\b\u001a\u00020\u0001H\u0016J\u0013\u00101\u001a\u00020/2\b\u00102\u001a\u0004\u0018\u000103H\u0096\u0002J\u0013\u00104\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0007\u001a\u00020\u0003H\u0096\u0002J\u0019\u00104\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u00105\u001a\u00020\u0001H\u0086\u0002J\u000e\u00106\u001a\u0002072\u0006\u0010\u0007\u001a\u00020\u0003J\u0016\u00106\u001a\u0002072\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u00105\u001a\u000207J\u000e\u00108\u001a\u0002092\u0006\u0010\u0007\u001a\u00020\u0003J\u0016\u00108\u001a\u0002092\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u00105\u001a\u000209J\u000e\u0010:\u001a\u00020;2\u0006\u0010\u0007\u001a\u00020\u0003J\u0016\u0010:\u001a\u00020;2\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u00105\u001a\u00020;J\u000e\u0010<\u001a\u00020=2\u0006\u0010\u0007\u001a\u00020\u0003J\u0016\u0010<\u001a\u00020=2\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u00105\u001a\u00020=J\u000e\u0010>\u001a\u00020?2\u0006\u0010\u0007\u001a\u00020\u0003J\u0016\u0010>\u001a\u00020?2\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u00105\u001a\u00020?J\u000e\u0010@\u001a\u00020\u00002\u0006\u0010\u0007\u001a\u00020\u0003J\u0016\u0010@\u001a\u00020\u00002\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u00105\u001a\u00020\u0000J\u000e\u0010A\u001a\u00020B2\u0006\u0010\u0007\u001a\u00020\u0003J\u0016\u0010A\u001a\u00020B2\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u00105\u001a\u00020BJ\u0006\u0010C\u001a\u00020\u0003J\u000e\u0010D\u001a\u00020E2\u0006\u0010\u0007\u001a\u00020\u0003J\u0016\u0010D\u001a\u00020E2\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u00105\u001a\u00020EJ\u000e\u0010F\u001a\u00020G2\u0006\u0010\u0007\u001a\u00020\u0003J\u0016\u0010F\u001a\u00020G2\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u00105\u001a\u00020GJ\u000e\u0010H\u001a\u00020I2\u0006\u0010\u0007\u001a\u00020\u0003J\u0016\u0010H\u001a\u00020I2\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u00105\u001a\u00020IJ\u000e\u0010J\u001a\u00020K2\u0006\u0010\u0007\u001a\u00020\u0003J\u0016\u0010J\u001a\u00020K2\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u00105\u001a\u00020KJ\u000e\u0010L\u001a\u00020M2\u0006\u0010\u0007\u001a\u00020\u0003J\u0016\u0010L\u001a\u00020M2\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u00105\u001a\u00020MJ\u000e\u0010N\u001a\u00020O2\u0006\u0010\u0007\u001a\u00020\u0003J\u0016\u0010N\u001a\u00020O2\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u00105\u001a\u00020OJ\u000e\u0010P\u001a\u00020Q2\u0006\u0010\u0007\u001a\u00020\u0003J\u0016\u0010P\u001a\u00020Q2\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u00105\u001a\u00020QJ\b\u0010R\u001a\u00020\u0005H\u0016J\u000e\u0010S\u001a\u00020/2\u0006\u0010\u0007\u001a\u00020\u0003J\u000e\u0010T\u001a\u00020/2\u0006\u0010\u0007\u001a\u00020\u0003J\u000e\u0010U\u001a\u00020/2\u0006\u0010\u0007\u001a\u00020\u0003J\u000e\u0010V\u001a\u00020/2\u0006\u0010\u0007\u001a\u00020\u0003J\u000e\u0010W\u001a\u00020/2\u0006\u0010\u0007\u001a\u00020\u0003J\u000e\u0010X\u001a\u00020/2\u0006\u0010\u0007\u001a\u00020\u0003J\u000e\u0010Y\u001a\u00020/2\u0006\u0010\u0007\u001a\u00020\u0003J\b\u0010Z\u001a\u00020/H\u0016J\u000e\u0010[\u001a\u00020/2\u0006\u0010\u0007\u001a\u00020\u0003J\u000e\u0010\\\u001a\u00020/2\u0006\u0010\u0007\u001a\u00020\u0003J\u000e\u0010]\u001a\u00020/2\u0006\u0010\u0007\u001a\u00020\u0003J\u000e\u0010^\u001a\u00020/2\u0006\u0010\u0007\u001a\u00020\u0003J\u000e\u0010_\u001a\u00020/2\u0006\u0010\u0007\u001a\u00020\u0003J\u000e\u0010`\u001a\u00020/2\u0006\u0010\u0007\u001a\u00020\u0003J\u000e\u0010a\u001a\u00020/2\u0006\u0010\u0007\u001a\u00020\u0003J\u001a\u0010b\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\u0001H\u0016J\u001e\u0010c\u001a\u00020,2\u0014\u0010d\u001a\u0010\u0012\u0006\b\u0001\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00010\u0013H\u0016J\u0012\u0010e\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0007\u001a\u00020\u0003H\u0016J\u0010\u0010f\u001a\u00020,2\u0006\u0010\u0007\u001a\u000203H\u0002J\u0006\u0010g\u001a\u00020hJ\b\u0010i\u001a\u00020\u0003H\u0016R*\u0010\u0015\u001a\u001e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00010\u0016j\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0001`\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0018\u001a\u00020\u00198VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR&\u0010\u001c\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00010\u001e0\u001d8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 R\u001a\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00030\u001d8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010 R\u0014\u0010#\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010%R\u001a\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00010'8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b(\u0010)\u00a8\u0006k"}, d2={"Lorg/mongodb/kbson/BsonDocument;", "Lorg/mongodb/kbson/BsonValue;", "", "", "initialCapacity", "", "(I)V", "key", "value", "(Ljava/lang/String;Lorg/mongodb/kbson/BsonValue;)V", "bsonElements", "", "Lorg/mongodb/kbson/BsonElement;", "(Ljava/util/List;)V", "pairs", "", "Lkotlin/Pair;", "([Lkotlin/Pair;)V", "initial", "", "(Ljava/util/Map;)V", "_values", "Ljava/util/LinkedHashMap;", "Lkotlin/collections/LinkedHashMap;", "bsonType", "Lorg/mongodb/kbson/BsonType;", "getBsonType", "()Lorg/mongodb/kbson/BsonType;", "entries", "", "", "getEntries", "()Ljava/util/Set;", "keys", "getKeys", "size", "getSize", "()I", "values", "", "getValues", "()Ljava/util/Collection;", "append", "clear", "", "clone", "containsKey", "", "containsValue", "equals", "other", "", "get", "defaultValue", "getArray", "Lorg/mongodb/kbson/BsonArray;", "getBinary", "Lorg/mongodb/kbson/BsonBinary;", "getBoolean", "Lorg/mongodb/kbson/BsonBoolean;", "getDateTime", "Lorg/mongodb/kbson/BsonDateTime;", "getDecimal128", "Lorg/mongodb/kbson/BsonDecimal128;", "getDocument", "getDouble", "Lorg/mongodb/kbson/BsonDouble;", "getFirstKey", "getInt32", "Lorg/mongodb/kbson/BsonInt32;", "getInt64", "Lorg/mongodb/kbson/BsonInt64;", "getNumber", "Lorg/mongodb/kbson/BsonNumber;", "getObjectId", "Lorg/mongodb/kbson/BsonObjectId;", "getRegularExpression", "Lorg/mongodb/kbson/BsonRegularExpression;", "getString", "Lorg/mongodb/kbson/BsonString;", "getTimestamp", "Lorg/mongodb/kbson/BsonTimestamp;", "hashCode", "isArray", "isBinary", "isBoolean", "isDateTime", "isDecimal128", "isDocument", "isDouble", "isEmpty", "isInt32", "isInt64", "isNull", "isNumber", "isObjectId", "isString", "isTimestamp", "put", "putAll", "from", "remove", "throwIfKeyAbsent", "toByteArray", "", "toString", "Companion", "kbson"})
public final class BsonDocument
extends BsonValue
implements Map<String, BsonValue>,
KMutableMap {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final LinkedHashMap<String, BsonValue> _values;

    public BsonDocument(@NotNull Map<String, ? extends BsonValue> initial) {
        Intrinsics.checkNotNullParameter(initial, "initial");
        super(null);
        this._values = initial instanceof LinkedHashMap ? (LinkedHashMap<Object, Object>)initial : new LinkedHashMap<String, BsonValue>(initial);
    }

    public /* synthetic */ BsonDocument(Map map2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            map2 = new LinkedHashMap();
        }
        this(map2);
    }

    public BsonDocument(int initialCapacity) {
        this(new LinkedHashMap(initialCapacity));
    }

    public BsonDocument(@NotNull String key, @NotNull BsonValue value) {
        Intrinsics.checkNotNullParameter(key, "key");
        Intrinsics.checkNotNullParameter(value, "value");
        Pair[] pairArray = new Pair[]{TuplesKt.to(key, value)};
        this(MapsKt.linkedMapOf(pairArray));
    }

    /*
     * WARNING - void declaration
     */
    public BsonDocument(@NotNull List<BsonElement> bsonElements) {
        void $this$associateTo$iv$iv;
        void $this$associate$iv;
        Intrinsics.checkNotNullParameter(bsonElements, "bsonElements");
        Iterable iterable = bsonElements;
        BsonDocument bsonDocument = this;
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($this$associate$iv, 10)), 16);
        void var5_6 = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map2 = destination$iv$iv;
            BsonElement it = (BsonElement)element$iv$iv;
            boolean bl = false;
            Pair<String, BsonValue> pair = new Pair<String, BsonValue>(it.getName(), it.getValue());
            map2.put(pair.getFirst(), pair.getSecond());
        }
        bsonDocument(destination$iv$iv);
    }

    public BsonDocument(Pair<String, ? extends BsonValue> ... pairs) {
        Intrinsics.checkNotNullParameter(pairs, "pairs");
        this(MapsKt.toMap(pairs));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final byte[] toByteArray() {
        byte[] byArray;
        Closeable $this$use$iv = BsonBinaryWriter.Companion.invoke();
        boolean $i$f$use = false;
        try {
            BsonBinaryWriter w = (BsonBinaryWriter)$this$use$iv;
            boolean bl = false;
            w.pipe(new BsonDocumentReader(this));
            byArray = w.getBsonOutput().toByteArray();
        }
        finally {
            Closeable closeable = $this$use$iv;
            if (closeable != null) {
                closeable.close();
            }
        }
        return byArray;
    }

    @NotNull
    public Set<Map.Entry<String, BsonValue>> getEntries() {
        Set<Map.Entry<String, BsonValue>> set = this._values.entrySet();
        Intrinsics.checkNotNullExpressionValue(set, "_values.entries");
        return set;
    }

    @NotNull
    public Set<String> getKeys() {
        Set<String> set = this._values.keySet();
        Intrinsics.checkNotNullExpressionValue(set, "_values.keys");
        return set;
    }

    public int getSize() {
        return this._values.size();
    }

    @NotNull
    public Collection<BsonValue> getValues() {
        Collection<BsonValue> collection = this._values.values();
        Intrinsics.checkNotNullExpressionValue(collection, "_values.values");
        return collection;
    }

    @Override
    public void clear() {
        this._values.clear();
    }

    public boolean containsKey(@NotNull String key) {
        Intrinsics.checkNotNullParameter(key, "key");
        return this._values.containsKey(key);
    }

    public boolean containsValue(@NotNull BsonValue value) {
        Intrinsics.checkNotNullParameter(value, "value");
        return this._values.containsValue(value);
    }

    @Nullable
    public BsonValue get(@NotNull String key) {
        Intrinsics.checkNotNullParameter(key, "key");
        return this._values.get(key);
    }

    @Override
    public boolean isEmpty() {
        return this._values.isEmpty();
    }

    @Nullable
    public BsonValue remove(@NotNull String key) {
        Intrinsics.checkNotNullParameter(key, "key");
        return (BsonValue)this._values.remove(key);
    }

    @Override
    public void putAll(@NotNull Map<? extends String, ? extends BsonValue> from) {
        Intrinsics.checkNotNullParameter(from, "from");
        this._values.putAll(from);
    }

    @Override
    @Nullable
    public BsonValue put(@NotNull String key, @NotNull BsonValue value) {
        Intrinsics.checkNotNullParameter(key, "key");
        Intrinsics.checkNotNullParameter(value, "value");
        return this._values.put(key, value);
    }

    @Override
    @NotNull
    public BsonType getBsonType() {
        return BsonType.DOCUMENT;
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || !(other instanceof BsonDocument)) {
            return false;
        }
        return Intrinsics.areEqual(this.entrySet(), ((BsonDocument)other).entrySet());
    }

    @Override
    public int hashCode() {
        return this._values.hashCode();
    }

    @NotNull
    public String toString() {
        return "BsonDocument(" + this._values + ')';
    }

    @NotNull
    public final BsonDocument clone() {
        Map map2;
        HashMap clonedValues = new HashMap();
        Map $this$onEach$iv = this._values;
        boolean $i$f$onEach = false;
        Map $this$onEach_u24lambda_u2d2$iv = map2 = $this$onEach$iv;
        boolean bl = false;
        Iterator iterator2 = $this$onEach_u24lambda_u2d2$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry element$iv;
            Map.Entry entry = element$iv = iterator2.next();
            boolean bl2 = false;
            if (((BsonValue)entry.getValue()).isArray()) {
                ((Map)clonedValues).put(entry.getKey(), ((BsonValue)entry.getValue()).asArray().clone());
                continue;
            }
            if (((BsonValue)entry.getValue()).isDocument()) {
                ((Map)clonedValues).put(entry.getKey(), ((BsonValue)entry.getValue()).asDocument().clone());
                continue;
            }
            ((Map)clonedValues).put(entry.getKey(), entry.getValue());
        }
        return new BsonDocument(clonedValues);
    }

    @NotNull
    public final String getFirstKey() {
        return this.keySet().iterator().next();
    }

    @NotNull
    public final BsonDocument append(@NotNull String key, @NotNull BsonValue value) {
        Intrinsics.checkNotNullParameter(key, "key");
        Intrinsics.checkNotNullParameter(value, "value");
        this.put(key, value);
        return this;
    }

    public final boolean isNull(@NotNull String key) {
        boolean bl;
        Intrinsics.checkNotNullParameter(key, "key");
        BsonValue bsonValue = (BsonValue)this.get((Object)key);
        return bsonValue == null ? false : (bl = bsonValue.isNull());
    }

    public final boolean isDocument(@NotNull String key) {
        boolean bl;
        Intrinsics.checkNotNullParameter(key, "key");
        BsonValue bsonValue = (BsonValue)this.get((Object)key);
        return bsonValue == null ? false : (bl = bsonValue.isDocument());
    }

    public final boolean isArray(@NotNull String key) {
        boolean bl;
        Intrinsics.checkNotNullParameter(key, "key");
        BsonValue bsonValue = (BsonValue)this.get((Object)key);
        return bsonValue == null ? false : (bl = bsonValue.isArray());
    }

    public final boolean isNumber(@NotNull String key) {
        boolean bl;
        Intrinsics.checkNotNullParameter(key, "key");
        BsonValue bsonValue = (BsonValue)this.get((Object)key);
        return bsonValue == null ? false : (bl = bsonValue.isNumber());
    }

    public final boolean isInt32(@NotNull String key) {
        boolean bl;
        Intrinsics.checkNotNullParameter(key, "key");
        BsonValue bsonValue = (BsonValue)this.get((Object)key);
        return bsonValue == null ? false : (bl = bsonValue.isInt32());
    }

    public final boolean isInt64(@NotNull String key) {
        boolean bl;
        Intrinsics.checkNotNullParameter(key, "key");
        BsonValue bsonValue = (BsonValue)this.get((Object)key);
        return bsonValue == null ? false : (bl = bsonValue.isInt64());
    }

    public final boolean isDecimal128(@NotNull String key) {
        boolean bl;
        Intrinsics.checkNotNullParameter(key, "key");
        BsonValue bsonValue = (BsonValue)this.get((Object)key);
        return bsonValue == null ? false : (bl = bsonValue.isDecimal128());
    }

    public final boolean isDouble(@NotNull String key) {
        boolean bl;
        Intrinsics.checkNotNullParameter(key, "key");
        BsonValue bsonValue = (BsonValue)this.get((Object)key);
        return bsonValue == null ? false : (bl = bsonValue.isDouble());
    }

    public final boolean isBoolean(@NotNull String key) {
        boolean bl;
        Intrinsics.checkNotNullParameter(key, "key");
        BsonValue bsonValue = (BsonValue)this.get((Object)key);
        return bsonValue == null ? false : (bl = bsonValue.isBoolean());
    }

    public final boolean isString(@NotNull String key) {
        boolean bl;
        Intrinsics.checkNotNullParameter(key, "key");
        BsonValue bsonValue = (BsonValue)this.get((Object)key);
        return bsonValue == null ? false : (bl = bsonValue.isString());
    }

    public final boolean isDateTime(@NotNull String key) {
        boolean bl;
        Intrinsics.checkNotNullParameter(key, "key");
        BsonValue bsonValue = (BsonValue)this.get((Object)key);
        return bsonValue == null ? false : (bl = bsonValue.isDateTime());
    }

    public final boolean isTimestamp(@NotNull String key) {
        boolean bl;
        Intrinsics.checkNotNullParameter(key, "key");
        BsonValue bsonValue = (BsonValue)this.get((Object)key);
        return bsonValue == null ? false : (bl = bsonValue.isTimestamp());
    }

    public final boolean isObjectId(@NotNull String key) {
        boolean bl;
        Intrinsics.checkNotNullParameter(key, "key");
        BsonValue bsonValue = (BsonValue)this.get((Object)key);
        return bsonValue == null ? false : (bl = bsonValue.isObjectId());
    }

    public final boolean isBinary(@NotNull String key) {
        boolean bl;
        Intrinsics.checkNotNullParameter(key, "key");
        BsonValue bsonValue = (BsonValue)this.get((Object)key);
        return bsonValue == null ? false : (bl = bsonValue.isBinary());
    }

    @NotNull
    public final BsonValue get(@NotNull String key, @NotNull BsonValue defaultValue) {
        Intrinsics.checkNotNullParameter(key, "key");
        Intrinsics.checkNotNullParameter(defaultValue, "defaultValue");
        BsonValue value = (BsonValue)this.get((Object)key);
        BsonValue bsonValue = value;
        if (bsonValue == null) {
            bsonValue = defaultValue;
        }
        return bsonValue;
    }

    @NotNull
    public final BsonDocument getDocument(@NotNull String key, @NotNull BsonDocument defaultValue) {
        BsonDocument bsonDocument;
        Intrinsics.checkNotNullParameter(key, "key");
        Intrinsics.checkNotNullParameter(defaultValue, "defaultValue");
        BsonValue bsonValue = (BsonValue)this.get((Object)key);
        if (bsonValue == null) {
            bsonDocument = defaultValue;
        } else {
            bsonDocument = bsonValue.asDocument();
            if (bsonDocument == null) {
                bsonDocument = defaultValue;
            }
        }
        return bsonDocument;
    }

    @NotNull
    public final BsonArray getArray(@NotNull String key, @NotNull BsonArray defaultValue) {
        BsonArray bsonArray;
        Intrinsics.checkNotNullParameter(key, "key");
        Intrinsics.checkNotNullParameter(defaultValue, "defaultValue");
        BsonValue bsonValue = (BsonValue)this.get((Object)key);
        if (bsonValue == null) {
            bsonArray = defaultValue;
        } else {
            bsonArray = bsonValue.asArray();
            if (bsonArray == null) {
                bsonArray = defaultValue;
            }
        }
        return bsonArray;
    }

    @NotNull
    public final BsonNumber getNumber(@NotNull String key, @NotNull BsonNumber defaultValue) {
        BsonNumber bsonNumber;
        Intrinsics.checkNotNullParameter(key, "key");
        Intrinsics.checkNotNullParameter(defaultValue, "defaultValue");
        BsonValue bsonValue = (BsonValue)this.get((Object)key);
        if (bsonValue == null) {
            bsonNumber = defaultValue;
        } else {
            bsonNumber = bsonValue.asNumber();
            if (bsonNumber == null) {
                bsonNumber = defaultValue;
            }
        }
        return bsonNumber;
    }

    @NotNull
    public final BsonInt32 getInt32(@NotNull String key, @NotNull BsonInt32 defaultValue) {
        BsonInt32 bsonInt32;
        Intrinsics.checkNotNullParameter(key, "key");
        Intrinsics.checkNotNullParameter(defaultValue, "defaultValue");
        BsonValue bsonValue = (BsonValue)this.get((Object)key);
        if (bsonValue == null) {
            bsonInt32 = defaultValue;
        } else {
            bsonInt32 = bsonValue.asInt32();
            if (bsonInt32 == null) {
                bsonInt32 = defaultValue;
            }
        }
        return bsonInt32;
    }

    @NotNull
    public final BsonInt64 getInt64(@NotNull String key, @NotNull BsonInt64 defaultValue) {
        BsonInt64 bsonInt64;
        Intrinsics.checkNotNullParameter(key, "key");
        Intrinsics.checkNotNullParameter(defaultValue, "defaultValue");
        BsonValue bsonValue = (BsonValue)this.get((Object)key);
        if (bsonValue == null) {
            bsonInt64 = defaultValue;
        } else {
            bsonInt64 = bsonValue.asInt64();
            if (bsonInt64 == null) {
                bsonInt64 = defaultValue;
            }
        }
        return bsonInt64;
    }

    @NotNull
    public final BsonDecimal128 getDecimal128(@NotNull String key, @NotNull BsonDecimal128 defaultValue) {
        BsonDecimal128 bsonDecimal128;
        Intrinsics.checkNotNullParameter(key, "key");
        Intrinsics.checkNotNullParameter(defaultValue, "defaultValue");
        BsonValue bsonValue = (BsonValue)this.get((Object)key);
        if (bsonValue == null) {
            bsonDecimal128 = defaultValue;
        } else {
            bsonDecimal128 = bsonValue.asDecimal128();
            if (bsonDecimal128 == null) {
                bsonDecimal128 = defaultValue;
            }
        }
        return bsonDecimal128;
    }

    @NotNull
    public final BsonDouble getDouble(@NotNull String key, @NotNull BsonDouble defaultValue) {
        BsonDouble bsonDouble;
        Intrinsics.checkNotNullParameter(key, "key");
        Intrinsics.checkNotNullParameter(defaultValue, "defaultValue");
        BsonValue bsonValue = (BsonValue)this.get((Object)key);
        if (bsonValue == null) {
            bsonDouble = defaultValue;
        } else {
            bsonDouble = bsonValue.asDouble();
            if (bsonDouble == null) {
                bsonDouble = defaultValue;
            }
        }
        return bsonDouble;
    }

    @NotNull
    public final BsonBoolean getBoolean(@NotNull String key, @NotNull BsonBoolean defaultValue) {
        BsonBoolean bsonBoolean;
        Intrinsics.checkNotNullParameter(key, "key");
        Intrinsics.checkNotNullParameter(defaultValue, "defaultValue");
        BsonValue bsonValue = (BsonValue)this.get((Object)key);
        if (bsonValue == null) {
            bsonBoolean = defaultValue;
        } else {
            bsonBoolean = bsonValue.asBoolean();
            if (bsonBoolean == null) {
                bsonBoolean = defaultValue;
            }
        }
        return bsonBoolean;
    }

    @NotNull
    public final BsonString getString(@NotNull String key, @NotNull BsonString defaultValue) {
        BsonString bsonString;
        Intrinsics.checkNotNullParameter(key, "key");
        Intrinsics.checkNotNullParameter(defaultValue, "defaultValue");
        BsonValue bsonValue = (BsonValue)this.get((Object)key);
        if (bsonValue == null) {
            bsonString = defaultValue;
        } else {
            bsonString = bsonValue.asString();
            if (bsonString == null) {
                bsonString = defaultValue;
            }
        }
        return bsonString;
    }

    @NotNull
    public final BsonDateTime getDateTime(@NotNull String key, @NotNull BsonDateTime defaultValue) {
        BsonDateTime bsonDateTime;
        Intrinsics.checkNotNullParameter(key, "key");
        Intrinsics.checkNotNullParameter(defaultValue, "defaultValue");
        BsonValue bsonValue = (BsonValue)this.get((Object)key);
        if (bsonValue == null) {
            bsonDateTime = defaultValue;
        } else {
            bsonDateTime = bsonValue.asDateTime();
            if (bsonDateTime == null) {
                bsonDateTime = defaultValue;
            }
        }
        return bsonDateTime;
    }

    @NotNull
    public final BsonTimestamp getTimestamp(@NotNull String key, @NotNull BsonTimestamp defaultValue) {
        BsonTimestamp bsonTimestamp;
        Intrinsics.checkNotNullParameter(key, "key");
        Intrinsics.checkNotNullParameter(defaultValue, "defaultValue");
        BsonValue bsonValue = (BsonValue)this.get((Object)key);
        if (bsonValue == null) {
            bsonTimestamp = defaultValue;
        } else {
            bsonTimestamp = bsonValue.asTimestamp();
            if (bsonTimestamp == null) {
                bsonTimestamp = defaultValue;
            }
        }
        return bsonTimestamp;
    }

    @NotNull
    public final BsonObjectId getObjectId(@NotNull String key, @NotNull BsonObjectId defaultValue) {
        BsonObjectId bsonObjectId;
        Intrinsics.checkNotNullParameter(key, "key");
        Intrinsics.checkNotNullParameter(defaultValue, "defaultValue");
        BsonValue bsonValue = (BsonValue)this.get((Object)key);
        if (bsonValue == null) {
            bsonObjectId = defaultValue;
        } else {
            bsonObjectId = bsonValue.asObjectId();
            if (bsonObjectId == null) {
                bsonObjectId = defaultValue;
            }
        }
        return bsonObjectId;
    }

    @NotNull
    public final BsonBinary getBinary(@NotNull String key, @NotNull BsonBinary defaultValue) {
        BsonBinary bsonBinary;
        Intrinsics.checkNotNullParameter(key, "key");
        Intrinsics.checkNotNullParameter(defaultValue, "defaultValue");
        BsonValue bsonValue = (BsonValue)this.get((Object)key);
        if (bsonValue == null) {
            bsonBinary = defaultValue;
        } else {
            bsonBinary = bsonValue.asBinary();
            if (bsonBinary == null) {
                bsonBinary = defaultValue;
            }
        }
        return bsonBinary;
    }

    @NotNull
    public final BsonRegularExpression getRegularExpression(@NotNull String key, @NotNull BsonRegularExpression defaultValue) {
        BsonRegularExpression bsonRegularExpression;
        Intrinsics.checkNotNullParameter(key, "key");
        Intrinsics.checkNotNullParameter(defaultValue, "defaultValue");
        BsonValue bsonValue = (BsonValue)this.get((Object)key);
        if (bsonValue == null) {
            bsonRegularExpression = defaultValue;
        } else {
            bsonRegularExpression = bsonValue.asRegularExpression();
            if (bsonRegularExpression == null) {
                bsonRegularExpression = defaultValue;
            }
        }
        return bsonRegularExpression;
    }

    @NotNull
    public final BsonDocument getDocument(@NotNull String key) {
        Intrinsics.checkNotNullParameter(key, "key");
        this.throwIfKeyAbsent(key);
        Object object = this.get((Object)key);
        Intrinsics.checkNotNull(object);
        return ((BsonValue)object).asDocument();
    }

    @NotNull
    public final BsonArray getArray(@NotNull String key) {
        Intrinsics.checkNotNullParameter(key, "key");
        this.throwIfKeyAbsent(key);
        Object object = this.get((Object)key);
        Intrinsics.checkNotNull(object);
        return ((BsonValue)object).asArray();
    }

    @NotNull
    public final BsonNumber getNumber(@NotNull String key) {
        Intrinsics.checkNotNullParameter(key, "key");
        this.throwIfKeyAbsent(key);
        Object object = this.get((Object)key);
        Intrinsics.checkNotNull(object);
        return ((BsonValue)object).asNumber();
    }

    @NotNull
    public final BsonInt32 getInt32(@NotNull String key) {
        Intrinsics.checkNotNullParameter(key, "key");
        this.throwIfKeyAbsent(key);
        Object object = this.get((Object)key);
        Intrinsics.checkNotNull(object);
        return ((BsonValue)object).asInt32();
    }

    @NotNull
    public final BsonInt64 getInt64(@NotNull String key) {
        Intrinsics.checkNotNullParameter(key, "key");
        this.throwIfKeyAbsent(key);
        Object object = this.get((Object)key);
        Intrinsics.checkNotNull(object);
        return ((BsonValue)object).asInt64();
    }

    @NotNull
    public final BsonDecimal128 getDecimal128(@NotNull String key) {
        Intrinsics.checkNotNullParameter(key, "key");
        this.throwIfKeyAbsent(key);
        Object object = this.get((Object)key);
        Intrinsics.checkNotNull(object);
        return ((BsonValue)object).asDecimal128();
    }

    @NotNull
    public final BsonDouble getDouble(@NotNull String key) {
        Intrinsics.checkNotNullParameter(key, "key");
        this.throwIfKeyAbsent(key);
        Object object = this.get((Object)key);
        Intrinsics.checkNotNull(object);
        return ((BsonValue)object).asDouble();
    }

    @NotNull
    public final BsonBoolean getBoolean(@NotNull String key) {
        Intrinsics.checkNotNullParameter(key, "key");
        this.throwIfKeyAbsent(key);
        Object object = this.get((Object)key);
        Intrinsics.checkNotNull(object);
        return ((BsonValue)object).asBoolean();
    }

    @NotNull
    public final BsonString getString(@NotNull String key) {
        Intrinsics.checkNotNullParameter(key, "key");
        this.throwIfKeyAbsent(key);
        Object object = this.get((Object)key);
        Intrinsics.checkNotNull(object);
        return ((BsonValue)object).asString();
    }

    @NotNull
    public final BsonDateTime getDateTime(@NotNull String key) {
        Intrinsics.checkNotNullParameter(key, "key");
        this.throwIfKeyAbsent(key);
        Object object = this.get((Object)key);
        Intrinsics.checkNotNull(object);
        return ((BsonValue)object).asDateTime();
    }

    @NotNull
    public final BsonTimestamp getTimestamp(@NotNull String key) {
        Intrinsics.checkNotNullParameter(key, "key");
        this.throwIfKeyAbsent(key);
        Object object = this.get((Object)key);
        Intrinsics.checkNotNull(object);
        return ((BsonValue)object).asTimestamp();
    }

    @NotNull
    public final BsonObjectId getObjectId(@NotNull String key) {
        Intrinsics.checkNotNullParameter(key, "key");
        this.throwIfKeyAbsent(key);
        Object object = this.get((Object)key);
        Intrinsics.checkNotNull(object);
        return ((BsonValue)object).asObjectId();
    }

    @NotNull
    public final BsonRegularExpression getRegularExpression(@NotNull String key) {
        Intrinsics.checkNotNullParameter(key, "key");
        this.throwIfKeyAbsent(key);
        Object object = this.get((Object)key);
        Intrinsics.checkNotNull(object);
        return ((BsonValue)object).asRegularExpression();
    }

    @NotNull
    public final BsonBinary getBinary(@NotNull String key) {
        Intrinsics.checkNotNullParameter(key, "key");
        this.throwIfKeyAbsent(key);
        Object object = this.get((Object)key);
        Intrinsics.checkNotNull(object);
        return ((BsonValue)object).asBinary();
    }

    private final void throwIfKeyAbsent(Object key) {
        if (!((Map)this).containsKey(key)) {
            throw new BsonInvalidOperationException("Document does not contain key: '" + key + '\'', null, 2, null);
        }
    }

    public BsonDocument() {
        this(null, 1, null);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0011\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0086\u0002J\u0011\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\bH\u0086\u0002J\u000f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\nH\u00c6\u0001\u00a8\u0006\u000b"}, d2={"Lorg/mongodb/kbson/BsonDocument$Companion;", "", "()V", "invoke", "Lorg/mongodb/kbson/BsonDocument;", "byteArray", "", "json", "", "serializer", "Lkotlinx/serialization/KSerializer;", "kbson"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public final BsonDocument invoke(@NotNull byte[] byteArray) {
            BsonDocument bsonDocument;
            Intrinsics.checkNotNullParameter(byteArray, "byteArray");
            Closeable $this$use$iv = new BsonDocumentWriter();
            boolean $i$f$use = false;
            try {
                BsonDocumentWriter w = (BsonDocumentWriter)$this$use$iv;
                boolean bl = false;
                w.pipe(BsonBinaryReader.Companion.invoke(byteArray));
                bsonDocument = w.getBsonDocument();
            }
            finally {
                Closeable closeable = $this$use$iv;
                closeable.close();
            }
            return bsonDocument;
        }

        @NotNull
        public final BsonDocument invoke(@NotNull String json) {
            Intrinsics.checkNotNullParameter(json, "json");
            return Bson.INSTANCE.invoke(json).asDocument();
        }

        @NotNull
        public final KSerializer<BsonDocument> serializer() {
            return BsonDocumentSerializer.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

