/*
 * Decompiled with CFR 0.152.
 */
package org.mongodb.kbson;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mongodb.kbson.BsonValue;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Lorg/mongodb/kbson/BsonElement;", "", "name", "", "value", "Lorg/mongodb/kbson/BsonValue;", "(Ljava/lang/String;Lorg/mongodb/kbson/BsonValue;)V", "getName", "()Ljava/lang/String;", "getValue", "()Lorg/mongodb/kbson/BsonValue;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "kbson"})
public final class BsonElement {
    @NotNull
    private final String name;
    @NotNull
    private final BsonValue value;

    public BsonElement(@NotNull String name, @NotNull BsonValue value) {
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(value, "value");
        this.name = name;
        this.value = value;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final BsonValue getValue() {
        return this.value;
    }

    @NotNull
    public final String component1() {
        return this.name;
    }

    @NotNull
    public final BsonValue component2() {
        return this.value;
    }

    @NotNull
    public final BsonElement copy(@NotNull String name, @NotNull BsonValue value) {
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(value, "value");
        return new BsonElement(name, value);
    }

    public static /* synthetic */ BsonElement copy$default(BsonElement bsonElement, String string, BsonValue bsonValue, int n, Object object) {
        if ((n & 1) != 0) {
            string = bsonElement.name;
        }
        if ((n & 2) != 0) {
            bsonValue = bsonElement.value;
        }
        return bsonElement.copy(string, bsonValue);
    }

    @NotNull
    public String toString() {
        return "BsonElement(name=" + this.name + ", value=" + this.value + ')';
    }

    public int hashCode() {
        int result2 = this.name.hashCode();
        result2 = result2 * 31 + this.value.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof BsonElement)) {
            return false;
        }
        BsonElement bsonElement = (BsonElement)other;
        if (!Intrinsics.areEqual(this.name, bsonElement.name)) {
            return false;
        }
        return Intrinsics.areEqual(this.value, bsonElement.value);
    }
}

