/*
 * Decompiled with CFR 0.152.
 */
package org.mongodb.kbson;

import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.random.Random;
import kotlin.random.RandomKt;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.Serializable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mongodb.kbson.BsonType;
import org.mongodb.kbson.BsonValue;
import org.mongodb.kbson.internal.AtomicInt;
import org.mongodb.kbson.internal.CurrentTime;
import org.mongodb.kbson.internal.HexUtils;
import org.mongodb.kbson.serialization.BsonObjectIdSerializer;

@Serializable(with=BsonObjectIdSerializer.class)
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\n\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0007\u0018\u0000 \u001b2\u00020\u00012\b\u0012\u0004\u0012\u00020\u00000\u0002:\u0001\u001bB%\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\tJ\u0011\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u0000H\u0096\u0002J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0011\u001a\u0004\u0018\u00010\u0014H\u0096\u0002J\b\u0010\u0015\u001a\u00020\u0004H\u0016J\u0006\u0010\u0016\u001a\u00020\u0017J\u0006\u0010\u0018\u001a\u00020\u0019J\b\u0010\u001a\u001a\u00020\u0019H\u0016R\u0014\u0010\n\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u000e\u0010\b\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001c"}, d2={"Lorg/mongodb/kbson/BsonObjectId;", "Lorg/mongodb/kbson/BsonValue;", "", "timestamp", "", "randomValue1", "randomValue2", "", "counter", "(IISI)V", "bsonType", "Lorg/mongodb/kbson/BsonType;", "getBsonType", "()Lorg/mongodb/kbson/BsonType;", "getTimestamp", "()I", "compareTo", "other", "equals", "", "", "hashCode", "toByteArray", "", "toHexString", "", "toString", "Companion", "kbson"})
public final class BsonObjectId
extends BsonValue
implements Comparable<BsonObjectId> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int timestamp;
    private final int randomValue1;
    private final short randomValue2;
    private final int counter;
    public static final int OBJECT_ID_LENGTH = 12;
    private static final int MILLIS_IN_SECOND = 1000;
    private static final int LOW_ORDER_THREE_BYTES = 0xFFFFFF;
    private static final int RANDOM_VALUE1;
    private static final short RANDOM_VALUE2;
    @NotNull
    private static final AtomicInt NEXT_COUNTER;

    public BsonObjectId(int timestamp, int randomValue1, short randomValue2, int counter) {
        super(null);
        this.timestamp = timestamp;
        this.randomValue1 = randomValue1;
        this.randomValue2 = randomValue2;
        this.counter = counter;
        if (!((this.randomValue1 & 0xFF000000) == 0)) {
            boolean $i$a$-require-BsonObjectId$32 = false;
            String $i$a$-require-BsonObjectId$32 = "The random value must be between 0 and 16777215 (it must fit in three bytes).";
            throw new IllegalArgumentException($i$a$-require-BsonObjectId$32.toString());
        }
        if (!((this.counter & 0xFF000000) == 0)) {
            boolean bl = false;
            String string = "The counter must be between 0 and 16777215 (it must fit in three bytes).";
            throw new IllegalArgumentException(string.toString());
        }
    }

    public final int getTimestamp() {
        return this.timestamp;
    }

    @NotNull
    public final byte[] toByteArray() {
        byte[] bytes = new byte[]{(byte)(this.timestamp >> 24), (byte)(this.timestamp >> 16), (byte)(this.timestamp >> 8), (byte)this.timestamp, (byte)(this.randomValue1 >> 16), (byte)(this.randomValue1 >> 8), (byte)this.randomValue1, (byte)(this.randomValue2 >> 8), (byte)this.randomValue2, (byte)(this.counter >> 16), (byte)(this.counter >> 8), (byte)this.counter};
        return bytes;
    }

    @NotNull
    public final String toHexString() {
        String string = HexUtils.INSTANCE.toHexString(this.toByteArray()).toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(string, "this as java.lang.String).toLowerCase(Locale.ROOT)");
        return string;
    }

    @Override
    @NotNull
    public BsonType getBsonType() {
        return BsonType.OBJECT_ID;
    }

    @NotNull
    public String toString() {
        return "BsonObjectId(" + this.toHexString() + ')';
    }

    @Override
    public int compareTo(@NotNull BsonObjectId other) {
        Intrinsics.checkNotNullParameter(other, "other");
        byte[] byteArray = this.toByteArray();
        byte[] otherByteArray = other.toByteArray();
        int n = 0;
        while (n < 12) {
            int i;
            if (byteArray[i = n++] == otherByteArray[i]) continue;
            return (byteArray[i] & 0xFF) < (otherByteArray[i] & 0xFF) ? -1 : 1;
        }
        return 0;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || !Intrinsics.areEqual(Reflection.getOrCreateKotlinClass(this.getClass()), Reflection.getOrCreateKotlinClass(other.getClass()))) {
            return false;
        }
        BsonObjectId cfr_ignored_0 = (BsonObjectId)other;
        if (this.timestamp != ((BsonObjectId)other).timestamp) {
            return false;
        }
        if (this.randomValue1 != ((BsonObjectId)other).randomValue1) {
            return false;
        }
        if (this.randomValue2 != ((BsonObjectId)other).randomValue2) {
            return false;
        }
        return this.counter == ((BsonObjectId)other).counter;
    }

    public int hashCode() {
        int result2 = this.timestamp;
        result2 = 31 * result2 + this.randomValue1;
        result2 = 31 * result2 + this.randomValue2;
        result2 = 31 * result2 + this.counter;
        return result2;
    }

    static {
        Random random = RandomKt.Random(CurrentTime.INSTANCE.getCurrentTimeInSeconds());
        NEXT_COUNTER = new AtomicInt(random.nextInt());
        RANDOM_VALUE1 = random.nextInt(0x1000000);
        RANDOM_VALUE2 = (short)random.nextInt(32768);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\n\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0004H\u0002J\t\u0010\u000f\u001a\u00020\rH\u0086\u0002J\u0011\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0011H\u0086\u0002J\u0011\u0010\u000f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0012H\u0086\u0002J\u0011\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u0014H\u0086\u0002J\u0014\u0010\u0015\u001a\u00020\u00042\n\u0010\u0016\u001a\u00020\u0011\"\u00020\u0017H\u0002J\u0014\u0010\u0018\u001a\u00020\u000b2\n\u0010\u0016\u001a\u00020\u0011\"\u00020\u0017H\u0002J\b\u0010\u0019\u001a\u00020\u0004H\u0002J\u000f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\r0\u001bH\u00c6\u0001R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/mongodb/kbson/BsonObjectId$Companion;", "", "()V", "LOW_ORDER_THREE_BYTES", "", "MILLIS_IN_SECOND", "NEXT_COUNTER", "Lorg/mongodb/kbson/internal/AtomicInt;", "OBJECT_ID_LENGTH", "RANDOM_VALUE1", "RANDOM_VALUE2", "", "fromTimeInSeconds", "Lorg/mongodb/kbson/BsonObjectId;", "timestamp", "invoke", "byteArray", "", "", "hexString", "", "makeInt", "bytes", "", "makeShort", "nextCounter", "serializer", "Lkotlinx/serialization/KSerializer;", "kbson"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final BsonObjectId invoke() {
            return this.fromTimeInSeconds(CurrentTime.INSTANCE.getCurrentTimeInSeconds());
        }

        @NotNull
        public final BsonObjectId invoke(long timestamp) {
            return this.fromTimeInSeconds((int)(timestamp / (long)1000));
        }

        @NotNull
        public final BsonObjectId invoke(@NotNull String hexString) {
            Intrinsics.checkNotNullParameter(hexString, "hexString");
            if (!(hexString.length() == 24)) {
                boolean bl = false;
                String string = "invalid hexadecimal representation of an ObjectId: [" + hexString + ']';
                throw new IllegalArgumentException(string.toString());
            }
            return this.invoke(HexUtils.INSTANCE.toByteArray(hexString));
        }

        @NotNull
        public final BsonObjectId invoke(@NotNull byte[] byteArray) {
            Intrinsics.checkNotNullParameter(byteArray, "byteArray");
            if (!(byteArray.length == 12)) {
                boolean $i$a$-require-BsonObjectId$Companion$invoke$32 = false;
                String $i$a$-require-BsonObjectId$Companion$invoke$32 = "invalid byteArray.size() " + byteArray.length + " != 12";
                throw new IllegalArgumentException($i$a$-require-BsonObjectId$Companion$invoke$32.toString());
            }
            int pos = 0;
            byte[] byArray = new byte[4];
            int n = pos;
            pos = n + 1;
            byArray[0] = byteArray[n];
            n = pos;
            pos = n + 1;
            byArray[1] = byteArray[n];
            n = pos;
            pos = n + 1;
            byArray[2] = byteArray[n];
            n = pos;
            pos = n + 1;
            byArray[3] = byteArray[n];
            int timestamp = this.makeInt(byArray);
            byte[] byArray2 = new byte[4];
            byArray2[0] = 0;
            int n2 = pos;
            pos = n2 + 1;
            byArray2[1] = byteArray[n2];
            n2 = pos;
            pos = n2 + 1;
            byArray2[2] = byteArray[n2];
            n2 = pos;
            pos = n2 + 1;
            byArray2[3] = byteArray[n2];
            int randomValue1 = this.makeInt(byArray2);
            byte[] byArray3 = new byte[2];
            int n3 = pos;
            pos = n3 + 1;
            byArray3[0] = byteArray[n3];
            n3 = pos;
            pos = n3 + 1;
            byArray3[1] = byteArray[n3];
            short randomValue2 = this.makeShort(byArray3);
            byte[] byArray4 = new byte[4];
            byArray4[0] = 0;
            int n4 = pos;
            pos = n4 + 1;
            byArray4[1] = byteArray[n4];
            n4 = pos;
            pos = n4 + 1;
            byArray4[2] = byteArray[n4];
            byArray4[3] = byteArray[pos];
            int counter = this.makeInt(byArray4);
            return new BsonObjectId(timestamp, randomValue1, randomValue2, counter);
        }

        private final BsonObjectId fromTimeInSeconds(int timestamp) {
            return new BsonObjectId(timestamp, RANDOM_VALUE1, RANDOM_VALUE2, this.nextCounter());
        }

        private final int nextCounter() {
            return NEXT_COUNTER.addAndGet(1) & 0xFFFFFF;
        }

        private final int makeInt(byte ... bytes) {
            if (!(bytes.length == 4)) {
                boolean bl = false;
                String string = "The byte array must be 4 bytes long.";
                throw new IllegalArgumentException(string.toString());
            }
            return bytes[0] << 24 | (bytes[1] & 0xFF) << 16 | (bytes[2] & 0xFF) << 8 | bytes[3] & 0xFF;
        }

        private final short makeShort(byte ... bytes) {
            if (!(bytes.length == 2)) {
                boolean bl = false;
                String string = "The byte array must be 2 bytes long.";
                throw new IllegalArgumentException(string.toString());
            }
            return (short)((bytes[0] & 0xFF) << 8 | bytes[1] & 0xFF);
        }

        @NotNull
        public final KSerializer<BsonObjectId> serializer() {
            return BsonObjectIdSerializer.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

