/*
 * Decompiled with CFR 0.152.
 */
package org.mongodb.kbson.internal.io;

import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.internal.ProgressionUtilKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.mongodb.kbson.BsonObjectId;
import org.mongodb.kbson.BsonSerializationException;
import org.mongodb.kbson.internal.io.BsonInput;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u0005\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0000\u0018\u0000 $2\u00020\u0001:\u0001$B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u000e\u001a\u00020\u0005H\u0002J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0002\u001a\u00020\u0003H\u0016J \u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u0005H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0005H\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010\u001b\u001a\u00020\u001cH\u0016J\b\u0010\u001d\u001a\u00020\u0015H\u0016J\u0010\u0010\u001d\u001a\u00020\u00152\u0006\u0010\u001e\u001a\u00020\u0005H\u0002J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u0005H\u0016J\b\u0010\"\u001a\u00020 H\u0016J\u000e\u0010#\u001a\u00020\u00002\u0006\u0010\u001e\u001a\u00020\u0005R\u0011\u0010\u0007\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u00020\u0005X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\t\"\u0004\b\f\u0010\r\u00a8\u0006%"}, d2={"Lorg/mongodb/kbson/internal/io/ByteArrayBsonInput;", "Lorg/mongodb/kbson/internal/io/BsonInput;", "bytes", "", "endIndex", "", "([BI)V", "availableBytes", "getAvailableBytes", "()I", "position", "getPosition", "setPosition", "(I)V", "calculateStringSize", "readByte", "", "readBytes", "offset", "length", "readCString", "", "readDouble", "", "readInt32", "readInt64", "", "readObjectId", "Lorg/mongodb/kbson/BsonObjectId;", "readString", "size", "skip", "", "numBytes", "skipCString", "slice", "Companion", "kbson"})
public final class ByteArrayBsonInput
implements BsonInput {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final byte[] bytes;
    private final int endIndex;
    private int position;
    @Deprecated
    @NotNull
    private static final String REPLACEMENT_CHARACTER = "\ufffd";
    @Deprecated
    @NotNull
    private static final String[] ONE_BYTE_ASCII_STRINGS = new String[128];

    public ByteArrayBsonInput(@NotNull byte[] bytes, int endIndex) {
        Intrinsics.checkNotNullParameter(bytes, "bytes");
        this.bytes = bytes;
        this.endIndex = endIndex;
    }

    public /* synthetic */ ByteArrayBsonInput(byte[] byArray, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            n = byArray.length;
        }
        this(byArray, n);
    }

    @Override
    public int getPosition() {
        return this.position;
    }

    public void setPosition(int n) {
        this.position = n;
    }

    public final int getAvailableBytes() {
        return this.endIndex - this.getPosition();
    }

    @Override
    public byte readByte() {
        boolean value$iv = this.getAvailableBytes() >= 1;
        boolean $i$f$validateSerialization = false;
        if (!value$iv) {
            boolean bl = false;
            String message$iv = "Unexpected EOF, only " + this.getAvailableBytes() + " bytes available. Requested 1.";
            throw new BsonSerializationException(message$iv.toString(), null, 2, null);
        }
        int n = this.getPosition();
        this.setPosition(n + 1);
        return this.bytes[n];
    }

    @Override
    @NotNull
    public byte[] readBytes(@NotNull byte[] bytes) {
        Intrinsics.checkNotNullParameter(bytes, "bytes");
        return this.readBytes(bytes, 0, bytes.length);
    }

    @Override
    @NotNull
    public byte[] readBytes(@NotNull byte[] bytes, int offset, int length) {
        Intrinsics.checkNotNullParameter(bytes, "bytes");
        if (!(offset >= 0 && offset <= bytes.length)) {
            boolean $i$a$-require-ByteArrayBsonInput$readBytes$32 = false;
            String $i$a$-require-ByteArrayBsonInput$readBytes$32 = "Invalid offset: " + offset + ". Only " + bytes.length;
            throw new IllegalArgumentException($i$a$-require-ByteArrayBsonInput$readBytes$32.toString());
        }
        if (!(length >= 0 && length <= bytes.length - offset)) {
            boolean $i$a$-require-ByteArrayBsonInput$readBytes$42 = false;
            String $i$a$-require-ByteArrayBsonInput$readBytes$42 = "Invalid length: " + length + ". Only " + this.getAvailableBytes() + " bytes available.";
            throw new IllegalArgumentException($i$a$-require-ByteArrayBsonInput$readBytes$42.toString());
        }
        boolean value$iv = this.getAvailableBytes() >= length;
        boolean $i$f$validateSerialization = false;
        if (!value$iv) {
            boolean bl = false;
            String message$iv = "Unexpected EOF, only " + this.getAvailableBytes() + " bytes available. Requested " + length + '.';
            throw new BsonSerializationException(message$iv.toString(), null, 2, null);
        }
        ArraysKt.copyInto(this.bytes, bytes, offset, this.getPosition(), this.getPosition() + length);
        this.setPosition(this.getPosition() + length);
        return bytes;
    }

    @Override
    public long readInt64() {
        ByteArrayBsonInput longBytes = this.slice(8);
        long longValue = 0L;
        int n = 0;
        int n2 = ProgressionUtilKt.getProgressionLastElement(0, 56, 8);
        if (n <= n2) {
            int i;
            do {
                i = n;
                n += 8;
                longValue |= (0xFFL & (long)longBytes.readByte()) << i;
            } while (i != n2);
        }
        return longValue;
    }

    @Override
    public double readDouble() {
        return Double.longBitsToDouble(this.readInt64());
    }

    @Override
    public int readInt32() {
        ByteArrayBsonInput intBytes = this.slice(4);
        int intValue = 0;
        int n = 0;
        int n2 = ProgressionUtilKt.getProgressionLastElement(0, 24, 8);
        if (n <= n2) {
            int i;
            do {
                i = n;
                n += 8;
                intValue |= (0xFF & intBytes.readByte()) << i;
            } while (i != n2);
        }
        return intValue;
    }

    @Override
    @NotNull
    public String readString() {
        int size = this.readInt32();
        return this.readString(size);
    }

    @Override
    @NotNull
    public BsonObjectId readObjectId() {
        return BsonObjectId.Companion.invoke(this.readBytes(new byte[12]));
    }

    @Override
    @NotNull
    public String readCString() {
        return this.readString(this.calculateStringSize());
    }

    @Override
    public void skip(int numBytes) {
        boolean value$iv = this.getAvailableBytes() >= numBytes;
        boolean $i$f$validateSerialization = false;
        if (!value$iv) {
            boolean bl = false;
            String message$iv = "Unexpected EOF, only " + this.getAvailableBytes() + " bytes available. Requested " + numBytes + '.';
            throw new BsonSerializationException(message$iv.toString(), null, 2, null);
        }
        this.setPosition(this.getPosition() + numBytes);
    }

    @Override
    public void skipCString() {
        this.skip(this.calculateStringSize());
    }

    private final int calculateStringSize() {
        int localPosition = this.getPosition();
        int size = 1;
        while (localPosition < this.endIndex) {
            int n = localPosition;
            localPosition = n + 1;
            if (this.bytes[n] == 0) {
                return size;
            }
            n = size;
            size = n + 1;
        }
        throw new BsonSerializationException("Found a BSON string that is not null-terminated", null, 2, null);
    }

    private final String readString(int size) {
        byte nullByte;
        boolean value$iv = size > 0;
        boolean $i$f$validateSerialization = false;
        if (!value$iv) {
            boolean bl = false;
            String message$iv = "While decoding a BSON string found a size that is not a positive number: " + size + '.';
            throw new BsonSerializationException(message$iv.toString(), null, 2, null);
        }
        value$iv = this.getAvailableBytes() >= size;
        $i$f$validateSerialization = false;
        if (!value$iv) {
            boolean bl = false;
            String message$iv = "Unexpected EOF, only " + this.getAvailableBytes() + " bytes available. Requested " + size + '.';
            throw new BsonSerializationException(message$iv.toString(), null, 2, null);
        }
        if (size == 2) {
            byte asciiByte = this.readByte();
            nullByte = this.readByte();
            boolean value$iv2 = nullByte == 0;
            boolean $i$f$validateSerialization2 = false;
            if (!value$iv2) {
                boolean bl = false;
                String message$iv = "Found a BSON string that is not null-terminated";
                throw new BsonSerializationException(message$iv.toString(), null, 2, null);
            }
            return asciiByte < 0 ? REPLACEMENT_CHARACTER : String.valueOf(ONE_BYTE_ASCII_STRINGS[asciiByte]);
        }
        String result2 = StringsKt.decodeToString$default(this.bytes, this.getPosition(), this.getPosition() + size - 1, false, 4, null);
        this.setPosition(this.getPosition() + (size - 1));
        nullByte = this.readByte();
        boolean value$iv3 = nullByte == 0;
        boolean $i$f$validateSerialization3 = false;
        if (!value$iv3) {
            boolean bl = false;
            String message$iv = "Found a BSON string that is not null-terminated";
            throw new BsonSerializationException(message$iv.toString(), null, 2, null);
        }
        return result2;
    }

    @NotNull
    public final ByteArrayBsonInput slice(int size) {
        boolean value$iv = this.getAvailableBytes() >= size;
        boolean $i$f$validateSerialization = false;
        if (!value$iv) {
            boolean bl = false;
            String message$iv = "Unexpected EOF, only " + this.getAvailableBytes() + " bytes available. Requested " + size + '.';
            throw new BsonSerializationException(message$iv.toString(), null, 2, null);
        }
        ByteArrayBsonInput result2 = new ByteArrayBsonInput(this.bytes, this.getPosition() + size);
        result2.setPosition(this.getPosition());
        this.setPosition(this.getPosition() + size);
        return result2;
    }

    static {
        int n = 0;
        int n2 = ONE_BYTE_ASCII_STRINGS.length;
        while (n < n2) {
            int b = n++;
            ByteArrayBsonInput.ONE_BYTE_ASCII_STRINGS[b] = String.valueOf((char)b);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0018\u0010\u0003\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lorg/mongodb/kbson/internal/io/ByteArrayBsonInput$Companion;", "", "()V", "ONE_BYTE_ASCII_STRINGS", "", "", "[Ljava/lang/String;", "REPLACEMENT_CHARACTER", "kbson"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

