/*
 * Decompiled with CFR 0.152.
 */
package io.redlink.geocoding;

public final class AddressComponent
implements Comparable<AddressComponent> {
    private final Type type;
    private final String value;

    private AddressComponent(Type type, String value) {
        this.type = type;
        this.value = value;
    }

    public Type getType() {
        return this.type;
    }

    public String getValue() {
        return this.value;
    }

    @Override
    public int compareTo(AddressComponent o) {
        return Integer.compare(this.type.ordinal(), o.type.ordinal());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AddressComponent other = (AddressComponent)obj;
        if (this.type != other.type) {
            return false;
        }
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public String toString() {
        return "AddressComponent [type=" + this.type + ", value=" + this.value + "]";
    }

    public static AddressComponent create(Type type, String value) {
        return new AddressComponent(type, value);
    }

    public static enum Type {
        streetNumber,
        street,
        sublocality,
        postalCode,
        city,
        state,
        countryCode,
        country;

    }
}

