/*
 * Decompiled with CFR 0.152.
 */
package io.redlink.geocoding;

import io.redlink.geocoding.LatLon;
import io.redlink.geocoding.Place;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import java.util.Optional;

public interface Geocoder {
    default public List<Place> geocode(String address) throws IOException {
        return this.geocode(address, (Locale)null);
    }

    default public List<Place> geocode(String address, String language) throws IOException {
        return this.geocode(address, Locale.forLanguageTag(language));
    }

    public List<Place> geocode(String var1, Locale var2) throws IOException;

    default public List<Place> reverseGeocode(LatLon coordinates) throws IOException {
        return this.reverseGeocode(coordinates, (Locale)null);
    }

    default public List<Place> reverseGeocode(LatLon coordinates, String language) throws IOException {
        return this.reverseGeocode(coordinates, language != null ? Locale.forLanguageTag(language) : null);
    }

    public List<Place> reverseGeocode(LatLon var1, Locale var2) throws IOException;

    default public Optional<Place> lookup(String placeId) throws IOException {
        return this.lookup(placeId, (Locale)null);
    }

    default public Optional<Place> lookup(String placeId, String language) throws IOException {
        return this.lookup(placeId, Locale.forLanguageTag(language));
    }

    public Optional<Place> lookup(String var1, Locale var2) throws IOException;
}

