/*
 * Decompiled with CFR 0.152.
 */
package io.redlink.geocoding;

public final class LatLon {
    private final double lat;
    private final double lon;

    private LatLon(double lat, double lon) {
        this.lat = lat;
        this.lon = lon;
    }

    public double lat() {
        return this.lat;
    }

    public double lon() {
        return this.lon;
    }

    public static LatLon create(double lat, double lon) {
        return new LatLon(lat, lon);
    }

    public static LatLon valueOf(String lat, String lon) {
        try {
            return LatLon.create(Double.parseDouble(lat), Double.parseDouble(lon));
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(String.format("Parsing '%s,%s' failed", lat, lon), e);
        }
    }

    public static LatLon valueOf(String latLon) {
        String[] s = latLon.split(",", 2);
        return LatLon.valueOf(s[0], s[1]);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LatLon latLon = (LatLon)o;
        return Double.compare(latLon.lat, this.lat) == 0 && Double.compare(latLon.lon, this.lon) == 0;
    }

    public int hashCode() {
        return (Double.toString(this.lat) + this.lon).hashCode();
    }

    public String toString() {
        return "LatLon{lat=" + this.lat + ", lon=" + this.lon + "}";
    }
}

