/*
 * Decompiled with CFR 0.152.
 */
package io.redlink.geocoding;

import io.redlink.geocoding.AddressComponent;
import io.redlink.geocoding.LatLon;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public final class Place {
    private final String placeId;
    private final String address;
    private final LatLon latLon;
    private final Collection<AddressComponent> components;
    private final Map<String, String> metadata;

    private Place(String placeId, String address, LatLon latLon, Collection<AddressComponent> components, Map<String, String> metadata) {
        this.placeId = placeId;
        this.address = address;
        this.latLon = latLon;
        this.components = components;
        this.metadata = metadata;
    }

    public String getPlaceId() {
        return this.placeId;
    }

    public String getAddress() {
        return this.address;
    }

    public LatLon getLatLon() {
        return this.latLon;
    }

    public Collection<AddressComponent> getComponents() {
        return Set.copyOf(this.components);
    }

    public Map<String, String> getMetadata() {
        return Map.copyOf(this.metadata);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Place)) {
            return false;
        }
        Place place = (Place)o;
        return Objects.equals(this.placeId, place.placeId) && Objects.equals(this.address, place.address) && Objects.equals(this.latLon, place.latLon) && Objects.equals(this.components, place.components) && Objects.equals(this.metadata, place.metadata);
    }

    public int hashCode() {
        return Objects.hash(this.placeId, this.address, this.latLon, this.components, this.metadata);
    }

    public String toString() {
        return "Place{placeId='" + this.placeId + "', address='" + this.address + "', latLon=" + this.latLon + "}";
    }

    public static Place create(String placeId, String address, LatLon latLon) {
        return Place.create(placeId, address, latLon, Set.of(), Map.of());
    }

    public static Place create(String placeId, String address, LatLon latLon, Collection<AddressComponent> addressComponents, Map<String, String> metadata) {
        return new Place(placeId, address, latLon, addressComponents, metadata);
    }
}

