/*
 * Decompiled with CFR 0.152.
 */
package io.redlink.geocoding.google;

import com.google.maps.GeoApiContext;
import io.redlink.geocoding.google.GoogleMapsGeocoder;
import java.net.Proxy;
import java.util.Locale;
import java.util.Objects;

public class GoogleMapsBuilder {
    private final GeoApiContext.Builder context = new GeoApiContext.Builder();
    private boolean apiKeySet;
    private boolean cryptoSecretSet;
    private Locale lang = Locale.getDefault(Locale.Category.DISPLAY);

    public GoogleMapsBuilder setLocale(String language) {
        this.lang = Locale.forLanguageTag(language);
        return this;
    }

    public GoogleMapsBuilder setLocale(Locale locale) {
        this.lang = locale;
        return this;
    }

    public GoogleMapsBuilder setProxy(Proxy proxy) {
        this.context.proxy(proxy);
        return this;
    }

    public GoogleMapsBuilder setQueryRateLimit(int maxQps) {
        this.context.queryRateLimit(maxQps);
        return this;
    }

    public GoogleMapsBuilder setApiKey(String apiKey) {
        this.context.apiKey(apiKey);
        this.apiKeySet = Objects.nonNull(apiKey);
        return this;
    }

    public GoogleMapsBuilder setChannel(String channel) {
        this.context.channel(channel);
        return this;
    }

    public GoogleMapsBuilder setCredentials(String clientId, String cryptoSecret) {
        this.context.enterpriseCredentials(clientId, cryptoSecret);
        this.cryptoSecretSet = Objects.nonNull(cryptoSecret);
        return this;
    }

    public GoogleMapsGeocoder create() {
        if (this.cryptoSecretSet || this.apiKeySet) {
            return new GoogleMapsGeocoder(this.context.build(), this.lang, this.cryptoSecretSet, this.apiKeySet);
        }
        throw new IllegalStateException("Must provide either API key or Maps for Work credentials.");
    }
}

