/*
 * Decompiled with CFR 0.152.
 */
package io.redlink.geocoding.google;

import com.google.maps.GeoApiContext;
import com.google.maps.GeocodingApi;
import com.google.maps.GeocodingApiRequest;
import com.google.maps.PlaceDetailsRequest;
import com.google.maps.PlacesApi;
import com.google.maps.errors.InvalidRequestException;
import com.google.maps.model.GeocodingResult;
import com.google.maps.model.LatLng;
import com.google.maps.model.PlaceDetails;
import io.redlink.geocoding.Geocoder;
import io.redlink.geocoding.LatLon;
import io.redlink.geocoding.Place;
import io.redlink.geocoding.google.GoogleMapsBuilder;
import io.redlink.geocoding.google.GoogleUtils;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GoogleMapsGeocoder
implements Geocoder {
    private static final Logger LOG = LoggerFactory.getLogger(GoogleMapsGeocoder.class);
    private final GeoApiContext context;
    private final Locale language;
    private final boolean apiKeySet;
    private final boolean cryptoSecretSet;

    protected GoogleMapsGeocoder(GeoApiContext context, Locale lang, boolean cryptoSecretSet, boolean apiKeySet) {
        this.context = context;
        this.language = lang;
        this.cryptoSecretSet = cryptoSecretSet;
        this.apiKeySet = apiKeySet;
    }

    public List<Place> geocode(String address, Locale lang) throws IOException {
        try {
            List<Place> places = GoogleUtils.google2Places((GeocodingResult[])((GeocodingApiRequest)GeocodingApi.geocode((GeoApiContext)this.context, (String)address).language((lang == null ? this.language : lang).toLanguageTag())).await());
            LOG.debug("Geocoding '{}' resulted in {} places", (Object)address, (Object)places.size());
            return places;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IOException(e);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public List<Place> reverseGeocode(LatLon coordinates, Locale lang) throws IOException {
        try {
            List<Place> places = GoogleUtils.google2Places((GeocodingResult[])((GeocodingApiRequest)GeocodingApi.reverseGeocode((GeoApiContext)this.context, (LatLng)GoogleUtils.latLon2LatLng(coordinates)).language((lang == null ? this.language : lang).toLanguageTag())).await());
            LOG.debug("Reverse-Geocoding '{}' resulted in {} places", (Object)coordinates, (Object)places.size());
            return places;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IOException(e);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public Optional<Place> lookup(String placeId, Locale lang) throws IOException {
        try {
            Place place = GoogleUtils.placeDetails2Place((PlaceDetails)((PlaceDetailsRequest)PlacesApi.placeDetails((GeoApiContext)this.context, (String)placeId).language((lang == null ? this.language : lang).toLanguageTag())).await());
            LOG.debug("Lookup of {} resulted in {}", (Object)placeId, (Object)place);
            return Optional.of(place);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IOException(e);
        }
        catch (InvalidRequestException e) {
            LOG.trace("Invalid Request for lookup {}", (Object)placeId, (Object)e);
            return Optional.empty();
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public String toString() {
        return "GoogleMapsGeocoder [auth:" + (this.cryptoSecretSet ? " cryptoSecret" : "") + (this.apiKeySet ? " apiKey" : "") + ",language=" + this.language + "]";
    }

    public static GoogleMapsBuilder configure() {
        return new GoogleMapsBuilder();
    }
}

