/*
 * Decompiled with CFR 0.152.
 */
package io.redlink.geocoding.google;

import com.google.common.collect.Lists;
import com.google.maps.model.AddressComponentType;
import com.google.maps.model.GeocodingResult;
import com.google.maps.model.LatLng;
import com.google.maps.model.PlaceDetails;
import io.redlink.geocoding.AddressComponent;
import io.redlink.geocoding.LatLon;
import io.redlink.geocoding.Place;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

final class GoogleUtils {
    private GoogleUtils() {
    }

    public static List<Place> google2Places(GeocodingResult[] results) {
        return Lists.transform(Arrays.asList(results), GoogleUtils::geocodingResult2Place);
    }

    private static Place geocodingResult2Place(GeocodingResult google) {
        return Place.create((String)google.placeId, (String)google.formattedAddress, (LatLon)GoogleUtils.latLng2latLon(google.geometry.location), GoogleUtils.mapAddressComponents(google.addressComponents), Map.of());
    }

    public static LatLng latLon2LatLng(LatLon coordinates) {
        return new LatLng(coordinates.lat(), coordinates.lon());
    }

    public static Place placeDetails2Place(PlaceDetails placeDetails) {
        return Place.create((String)placeDetails.placeId, (String)placeDetails.formattedAddress, (LatLon)GoogleUtils.latLng2latLon(placeDetails.geometry.location));
    }

    private static LatLon latLng2latLon(LatLng latLng) {
        return LatLon.create((double)latLng.lat, (double)latLng.lng);
    }

    private static Collection<AddressComponent> mapAddressComponents(com.google.maps.model.AddressComponent[] acs) {
        if (acs == null) {
            return Collections.emptyList();
        }
        EnumMap components = new EnumMap(AddressComponent.Type.class);
        Arrays.stream(acs).forEach(ac -> {
            EnumSet<AddressComponentType> types = EnumSet.noneOf(AddressComponentType.class);
            Arrays.stream(ac.types).collect(Collectors.toCollection(() -> types));
            if (types.contains(AddressComponentType.COUNTRY)) {
                components.putIfAbsent(AddressComponent.Type.country, AddressComponent.create((AddressComponent.Type)AddressComponent.Type.country, (String)ac.longName));
                components.putIfAbsent(AddressComponent.Type.countryCode, AddressComponent.create((AddressComponent.Type)AddressComponent.Type.countryCode, (String)ac.shortName.toLowerCase(Locale.ROOT)));
            }
            if (types.contains(AddressComponentType.ADMINISTRATIVE_AREA_LEVEL_1)) {
                components.putIfAbsent(AddressComponent.Type.state, AddressComponent.create((AddressComponent.Type)AddressComponent.Type.state, (String)ac.longName));
            }
            if (types.contains(AddressComponentType.POSTAL_CODE)) {
                components.putIfAbsent(AddressComponent.Type.postalCode, AddressComponent.create((AddressComponent.Type)AddressComponent.Type.postalCode, (String)ac.longName));
            }
            if (types.contains(AddressComponentType.LOCALITY)) {
                components.putIfAbsent(AddressComponent.Type.city, AddressComponent.create((AddressComponent.Type)AddressComponent.Type.city, (String)ac.longName));
            }
            if (types.contains(AddressComponentType.SUBLOCALITY_LEVEL_1)) {
                components.putIfAbsent(AddressComponent.Type.sublocality, AddressComponent.create((AddressComponent.Type)AddressComponent.Type.sublocality, (String)ac.longName));
            }
            if (types.contains(AddressComponentType.ROUTE)) {
                components.putIfAbsent(AddressComponent.Type.street, AddressComponent.create((AddressComponent.Type)AddressComponent.Type.street, (String)ac.longName));
            }
            if (types.contains(AddressComponentType.STREET_NUMBER)) {
                components.putIfAbsent(AddressComponent.Type.streetNumber, AddressComponent.create((AddressComponent.Type)AddressComponent.Type.streetNumber, (String)ac.longName));
            }
        });
        return components.values();
    }
}

