/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bootgraph.api;

import java.lang.annotation.Annotation;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.core.type.MethodMetadata;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=2, d1={"\u0000\"\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u001b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a.\u0010\u0000\u001a\u00020\u0001\"\b\b\u0000\u0010\u0002*\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00020\t\u001a(\u0010\n\u001a\u00020\u0001\"\b\b\u0000\u0010\u0002*\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\f\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00020\tH\u0002\u001a(\u0010\u000b\u001a\u00020\u0001\"\b\b\u0000\u0010\u0002*\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00020\tH\u0002\u00a8\u0006\f"}, d2={"isBeanAnnotated", "", "T", "", "bean", "", "beanDefinition", "Lorg/springframework/beans/factory/config/BeanDefinition;", "annotationClazz", "Ljava/lang/Class;", "isBeanAnnotatedDirectly", "isFactoryMethodAnnotated", "bootgraph-core"})
public final class AnnotationUtilKt {
    public static final <T extends Annotation> boolean isBeanAnnotated(@NotNull Object bean, @NotNull BeanDefinition beanDefinition, @NotNull Class<T> annotationClazz) {
        Intrinsics.checkParameterIsNotNull((Object)bean, (String)"bean");
        Intrinsics.checkParameterIsNotNull((Object)beanDefinition, (String)"beanDefinition");
        Intrinsics.checkParameterIsNotNull(annotationClazz, (String)"annotationClazz");
        return AnnotationUtilKt.isBeanAnnotatedDirectly(bean, annotationClazz) || AnnotationUtilKt.isFactoryMethodAnnotated(beanDefinition, annotationClazz);
    }

    private static final <T extends Annotation> boolean isBeanAnnotatedDirectly(Object bean, Class<T> annotationClazz) {
        return bean.getClass().isAnnotationPresent(annotationClazz);
    }

    private static final <T extends Annotation> boolean isFactoryMethodAnnotated(BeanDefinition beanDefinition, Class<T> annotationClazz) {
        if (!(beanDefinition instanceof AnnotatedBeanDefinition)) {
            return false;
        }
        MethodMetadata methodMetadata = ((AnnotatedBeanDefinition)beanDefinition).getFactoryMethodMetadata();
        return methodMetadata != null ? methodMetadata.isAnnotated(annotationClazz.getName()) : false;
    }
}

