/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bootgraph.api.model;

import com.atlassian.bootgraph.api.model.Edge;
import com.atlassian.bootgraph.api.model.ExternalNode;
import com.atlassian.bootgraph.api.model.InternalNode;
import com.atlassian.bootgraph.api.model.Node;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\n\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0005\b&\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0000J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00002\b\u0010\u0014\u001a\u0004\u0018\u00010\u0003J\u000e\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0000J\u0018\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u00002\b\u0010\u0014\u001a\u0004\u0018\u00010\u0003J\u0013\u0010\u0017\u001a\u00020\u00052\b\u0010\u0018\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\n\u0010\u0019\u001a\u0004\u0018\u00010\u0000H\u0002J\u000e\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u0000J\u000e\u0010\u001b\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u0000J\b\u0010\u001c\u001a\u00020\u001dH\u0016J\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\t0\u001fJ\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\t0\u001fJ\u0006\u0010!\u001a\u00020\u0000J\u0006\u0010\"\u001a\u00020\u0003J\b\u0010#\u001a\u00020\u0003H\u0016R \u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\t0\bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR \u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\t0\bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000b\u00a8\u0006$"}, d2={"Lcom/atlassian/bootgraph/api/model/Node;", "", "name", "", "isExternal", "", "(Ljava/lang/String;Z)V", "inputs", "", "Lcom/atlassian/bootgraph/api/model/Edge;", "getInputs$bootgraph_core", "()Ljava/util/Map;", "()Z", "getName", "()Ljava/lang/String;", "outputs", "getOutputs$bootgraph_core", "addEdgeFrom", "", "fromNode", "connectionLabel", "addEdgeTo", "toNode", "equals", "other", "getConnectedNodeWithLongestName", "hasEdgeFrom", "hasEdgeTo", "hashCode", "", "incomingEdges", "", "outgoingEdges", "shallowCopy", "toDebugString", "toString", "bootgraph-core"})
public abstract class Node {
    @NotNull
    private final Map<Node, Edge> inputs;
    @NotNull
    private final Map<Node, Edge> outputs;
    @NotNull
    private final String name;
    private final boolean isExternal;

    @NotNull
    public final Map<Node, Edge> getInputs$bootgraph_core() {
        return this.inputs;
    }

    @NotNull
    public final Map<Node, Edge> getOutputs$bootgraph_core() {
        return this.outputs;
    }

    public final void addEdgeTo(@NotNull Node toNode) {
        Intrinsics.checkParameterIsNotNull((Object)toNode, (String)"toNode");
        this.addEdgeTo(toNode, null);
    }

    public final void addEdgeTo(@NotNull Node toNode, @Nullable String connectionLabel) {
        Intrinsics.checkParameterIsNotNull((Object)toNode, (String)"toNode");
        Edge edge = new Edge(this, toNode, connectionLabel);
        this.outputs.put(toNode, edge);
        toNode.inputs.put(this, edge);
    }

    public final boolean hasEdgeTo(@NotNull Node toNode) {
        Intrinsics.checkParameterIsNotNull((Object)toNode, (String)"toNode");
        return this.outputs.containsKey(toNode);
    }

    public final void addEdgeFrom(@NotNull Node fromNode, @Nullable String connectionLabel) {
        Intrinsics.checkParameterIsNotNull((Object)fromNode, (String)"fromNode");
        Edge edge = new Edge(fromNode, this, connectionLabel);
        this.inputs.put(fromNode, edge);
        fromNode.outputs.put(this, edge);
    }

    public final void addEdgeFrom(@NotNull Node fromNode) {
        Intrinsics.checkParameterIsNotNull((Object)fromNode, (String)"fromNode");
        this.addEdgeFrom(fromNode, null);
    }

    public final boolean hasEdgeFrom(@NotNull Node fromNode) {
        Intrinsics.checkParameterIsNotNull((Object)fromNode, (String)"fromNode");
        return this.inputs.containsKey(fromNode);
    }

    @NotNull
    public final Collection<Edge> incomingEdges() {
        return this.inputs.values();
    }

    @NotNull
    public final Collection<Edge> outgoingEdges() {
        return this.outputs.values();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null) ^ true) {
            return false;
        }
        Object object2 = other;
        if (object2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.atlassian.bootgraph.api.model.Node");
        }
        Node cfr_ignored_0 = (Node)object2;
        return !(Intrinsics.areEqual((Object)this.name, (Object)((Node)other).name) ^ true);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    @NotNull
    public final Node shallowCopy() {
        return this.isExternal ? (Node)new ExternalNode(this.name) : (Node)new InternalNode(this.name);
    }

    @NotNull
    public String toString() {
        return this.name;
    }

    @NotNull
    public final String toDebugString() {
        String string;
        boolean bl;
        StringBuilder stringBuilder;
        Object[] objectArray;
        String string2;
        Object node;
        Object object;
        Object object2;
        String string3;
        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
        Object object3 = "  node '%s'";
        Object object4 = new Object[]{this.name};
        boolean bl2 = false;
        String string4 = String.format((String)object3, Arrays.copyOf(object4, ((Object[])object4).length));
        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"java.lang.String.format(format, *args)");
        String string5 = string3 = string4;
        StringBuilder stringBuilder2 = new StringBuilder(string5);
        if (this.inputs.isEmpty() && this.outputs.isEmpty()) {
            stringBuilder2.append(" with no edges\n");
        } else {
            stringBuilder2.append(" with edges:\n");
        }
        int indent = (object2 = this.getConnectedNodeWithLongestName()) != null && (object2 = ((Node)object2).name) != null ? ((String)object2).length() : 0;
        Map<Node, Edge> map = this.inputs;
        boolean bl3 = false;
        object4 = map.entrySet().iterator();
        while (object4.hasNext()) {
            object = object3 = (Map.Entry)object4.next();
            boolean bl4 = false;
            node = (Node)object.getKey();
            object = object3;
            bl4 = false;
            Edge edge = (Edge)object.getValue();
            object = StringCompanionObject.INSTANCE;
            string2 = "    %-" + indent + "s <-- %s\n";
            objectArray = new Object[]{this.name, ((Node)node).name};
            stringBuilder = stringBuilder2;
            bl = false;
            Intrinsics.checkExpressionValueIsNotNull((Object)String.format(string2, Arrays.copyOf(objectArray, objectArray.length)), (String)"java.lang.String.format(format, *args)");
            stringBuilder.append(string);
        }
        node = this.outputs;
        boolean edge = false;
        object4 = node.entrySet().iterator();
        while (object4.hasNext()) {
            object = object3 = (Map.Entry)object4.next();
            boolean bl5 = false;
            node = (Node)object.getKey();
            object = object3;
            bl5 = false;
            Edge edge2 = (Edge)object.getValue();
            object = StringCompanionObject.INSTANCE;
            string2 = "    %-" + indent + "s --> %s\n";
            objectArray = new Object[]{this.name, ((Node)node).name};
            stringBuilder = stringBuilder2;
            bl = false;
            Intrinsics.checkExpressionValueIsNotNull((Object)String.format(string2, Arrays.copyOf(objectArray, objectArray.length)), (String)"java.lang.String.format(format, *args)");
            stringBuilder.append(string);
        }
        String string6 = stringBuilder2.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"stringBuilder.toString()");
        return string6;
    }

    private final Node getConnectedNodeWithLongestName() {
        HashSet allNodes = new HashSet();
        allNodes.addAll(this.inputs.keySet());
        allNodes.addAll(this.outputs.keySet());
        return (Node)allNodes.stream().max(Comparator.comparingInt(getConnectedNodeWithLongestName.1.INSTANCE)).orElseGet(getConnectedNodeWithLongestName.2.INSTANCE);
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    public final boolean isExternal() {
        return this.isExternal;
    }

    public Node(@NotNull String name, boolean isExternal) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        this.name = name;
        this.isExternal = isExternal;
        this.inputs = new HashMap();
        this.outputs = new HashMap();
    }
}

