/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bootgraph.graphviz;

import com.atlassian.bootgraph.api.model.Edge;
import com.atlassian.bootgraph.api.model.GraphModel;
import com.atlassian.bootgraph.api.model.Node;
import com.atlassian.bootgraph.graphviz.ExportConfiguration;
import guru.nidi.graphviz.attribute.Attributes;
import guru.nidi.graphviz.attribute.Font;
import guru.nidi.graphviz.attribute.GraphAttr;
import guru.nidi.graphviz.attribute.Label;
import guru.nidi.graphviz.attribute.Rank;
import guru.nidi.graphviz.attribute.Shape;
import guru.nidi.graphviz.attribute.Style;
import guru.nidi.graphviz.engine.Graphviz;
import guru.nidi.graphviz.model.Factory;
import guru.nidi.graphviz.model.Link;
import guru.nidi.graphviz.model.LinkSource;
import guru.nidi.graphviz.model.LinkTarget;
import guru.nidi.graphviz.model.MutableGraph;
import guru.nidi.graphviz.model.MutableNode;
import java.io.File;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0018\u0010\u000b\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\f\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u000e\u0010\r\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0018\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0010\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/atlassian/bootgraph/graphviz/GraphVizModelExporter;", "", "config", "Lcom/atlassian/bootgraph/graphviz/ExportConfiguration;", "(Lcom/atlassian/bootgraph/graphviz/ExportConfiguration;)V", "addInputConnections", "", "graphModel", "Lcom/atlassian/bootgraph/api/model/GraphModel;", "mainGraph", "Lguru/nidi/graphviz/model/MutableGraph;", "addOutputConnections", "applicationCluster", "export", "exportToFile", "graph", "inputCluster", "outputCluster", "bootgraph-core"})
public final class GraphVizModelExporter {
    private final ExportConfiguration config;

    public final void export(@NotNull GraphModel graphModel) {
        boolean bl;
        boolean bl2;
        Object object;
        Intrinsics.checkParameterIsNotNull((Object)graphModel, (String)"graphModel");
        MutableGraph mainGraph = Factory.mutGraph().setDirected(true);
        mainGraph.graphAttrs().add(GraphAttr.splines((GraphAttr.SplineMode)this.config.getArrowFormat().getGraphVizFormat()));
        mainGraph.graphAttrs().add((Attributes)Rank.dir((Rank.RankDir)Rank.RankDir.LEFT_TO_RIGHT));
        String string = this.config.getFontName();
        if (string != null) {
            object = string;
            bl2 = false;
            bl = false;
            String it = object;
            boolean bl3 = false;
            mainGraph.graphAttrs().add(Font.name((String)it));
            mainGraph.linkAttrs().add(Font.name((String)it));
            MutableGraph cfr_ignored_0 = (MutableGraph)mainGraph.nodeAttrs().add(Font.name((String)it));
        }
        Float f = this.config.getNodeWidthInInches();
        if (f != null) {
            object = f;
            bl2 = false;
            bl = false;
            float it = ((Number)object).floatValue();
            boolean bl4 = false;
            mainGraph.nodeAttrs().add("fixedsize", (Object)"true");
            MutableGraph cfr_ignored_1 = (MutableGraph)mainGraph.nodeAttrs().add("width", (Object)String.valueOf(it));
        }
        Float f2 = this.config.getNodeHeightInInches();
        if (f2 != null) {
            object = f2;
            bl2 = false;
            bl = false;
            float it = ((Number)object).floatValue();
            boolean bl5 = false;
            mainGraph.nodeAttrs().add("fixedsize", (Object)"true");
            MutableGraph cfr_ignored_2 = (MutableGraph)mainGraph.nodeAttrs().add("height", (Object)String.valueOf(it));
        }
        mainGraph.nodeAttrs().add((Attributes)Shape.RECTANGLE);
        mainGraph.add((LinkSource)this.applicationCluster(graphModel));
        MutableGraph mutableGraph = mainGraph;
        Intrinsics.checkExpressionValueIsNotNull((Object)mutableGraph, (String)"mainGraph");
        this.addInputConnections(graphModel, mutableGraph);
        this.addOutputConnections(graphModel, mainGraph);
        this.exportToFile(mainGraph, this.config);
    }

    private final void addInputConnections(GraphModel graphModel, MutableGraph mainGraph) {
        for (Node targetNode : graphModel.getInternalNodes()) {
            for (Edge inputEdge : targetNode.incomingEdges()) {
                Link link = this.config.getShowConnectionLabels() && inputEdge.getLabel() != null ? Link.to((MutableNode)Factory.mutNode((String)targetNode.getName())).with((Attributes)Label.of((String)inputEdge.getLabel())) : Link.to((MutableNode)Factory.mutNode((String)targetNode.getName()));
                mainGraph.add((LinkSource)Factory.mutNode((String)inputEdge.getFrom().getName()).addLink((LinkTarget)link));
            }
        }
    }

    private final void addOutputConnections(GraphModel graphModel, MutableGraph mainGraph) {
        for (Node sourceNode : graphModel.getInternalNodes()) {
            for (Edge outputEdge : sourceNode.outgoingEdges()) {
                Link link = this.config.getShowConnectionLabels() && outputEdge.getLabel() != null ? Link.to((MutableNode)Factory.mutNode((String)outputEdge.getTo().getName())).with((Attributes)Label.of((String)outputEdge.getLabel())) : Link.to((MutableNode)Factory.mutNode((String)outputEdge.getTo().getName()));
                mainGraph.add((LinkSource)Factory.mutNode((String)sourceNode.getName()).addLink((LinkTarget)link));
            }
        }
    }

    private final MutableGraph inputCluster(GraphModel graphModel) {
        MutableGraph cluster = Factory.mutGraph((String)"input components");
        cluster.graphAttrs().add((Attributes)Style.INVIS);
        MutableGraph mutableGraph = cluster;
        Intrinsics.checkExpressionValueIsNotNull((Object)mutableGraph, (String)"cluster");
        mutableGraph.setCluster(true);
        return cluster;
    }

    private final MutableGraph outputCluster(GraphModel graphModel) {
        MutableGraph cluster = Factory.mutGraph((String)"output components");
        cluster.graphAttrs().add((Attributes)Style.INVIS);
        MutableGraph mutableGraph = cluster;
        Intrinsics.checkExpressionValueIsNotNull((Object)mutableGraph, (String)"cluster");
        mutableGraph.setCluster(true);
        return cluster;
    }

    private final MutableGraph applicationCluster(GraphModel graphModel) {
        MutableGraph applicationCluster = Factory.mutGraph((String)"application");
        applicationCluster.graphAttrs().add((Attributes)Label.of((String)(graphModel.getName() + "\\l")));
        MutableGraph mutableGraph = applicationCluster;
        Intrinsics.checkExpressionValueIsNotNull((Object)mutableGraph, (String)"applicationCluster");
        mutableGraph.setCluster(true);
        MutableGraph inputCluster = this.inputCluster(graphModel);
        MutableGraph outputCluster = this.outputCluster(graphModel);
        for (Node node : graphModel.getInternalNodes()) {
            Node it;
            boolean $i$f$any;
            Iterable $this$any$iv;
            if (!node.isExternal()) {
                boolean bl;
                block11: {
                    $this$any$iv = node.getInputs$bootgraph_core().keySet();
                    $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            it = (Node)element$iv;
                            boolean bl2 = false;
                            if (!it.isExternal()) continue;
                            bl = true;
                            break block11;
                        }
                        bl = false;
                    }
                }
                if (bl) {
                    inputCluster.add((LinkSource)Factory.node((String)node.getName()));
                    continue;
                }
            }
            if (!node.isExternal()) {
                boolean bl;
                block12: {
                    $this$any$iv = node.getOutputs$bootgraph_core().keySet();
                    $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            it = (Node)element$iv;
                            boolean bl3 = false;
                            if (!it.isExternal()) continue;
                            bl = true;
                            break block12;
                        }
                        bl = false;
                    }
                }
                if (bl) {
                    outputCluster.add((LinkSource)Factory.node((String)node.getName()));
                    continue;
                }
            }
            applicationCluster.add((LinkSource)Factory.node((String)node.getName()));
        }
        applicationCluster.add((LinkSource)inputCluster);
        applicationCluster.add((LinkSource)outputCluster);
        return applicationCluster;
    }

    private final void exportToFile(MutableGraph graph, ExportConfiguration config) {
        int it;
        boolean bl;
        boolean bl2;
        Integer n;
        Graphviz graphViz = Graphviz.fromGraph((MutableGraph)graph);
        Integer n2 = config.getWidthInPixels();
        if (n2 != null) {
            n = n2;
            bl2 = false;
            bl = false;
            it = ((Number)n).intValue();
            boolean bl3 = false;
            graphViz.width(it);
        }
        Integer n3 = config.getHeightInPixels();
        if (n3 != null) {
            n = n3;
            bl2 = false;
            bl = false;
            it = ((Number)n).intValue();
            boolean bl4 = false;
            graphViz.height(it);
        }
        graphViz.render(config.getOutputFormat().getGraphVizFormat()).toFile(new File(config.getOutputFilePath()));
    }

    public GraphVizModelExporter(@NotNull ExportConfiguration config) {
        Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
        this.config = config;
    }
}

